<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die('Restricted access');

class MjHtml
{
    /**
     * @param string $name
     * @param string $text_code
     * @param string $tooltip_code
     * @param string $tooltip_extra
     * @return string
     */
    public static function label($name, $text_code, $tooltip_code = '', $tooltip_extra = '')
    {
        if ($name === '') {
            $html =
                '<label class="control-label' . ($tooltip_code ? ' hasTip hasTooltip' : '') . '"' .
                ($tooltip_code ? ' data-toggle="tooltip" title="' . htmlspecialchars(JText::_($tooltip_code) . JText::_($tooltip_extra)) . '"' : '') .
                '>' .
                JText::_($text_code) .
                '</label>';
        } else {
            $name = self::id($name);

            $html =
                '<label for="' . $name . '"' .
                ' class="control-label' . ($tooltip_code ? ' hasTip hasTooltip' : '') . '"' .
                ($tooltip_code ? ' data-toggle="tooltip" title="' . htmlspecialchars(JText::_($tooltip_code) . JText::_($tooltip_extra)) . '"' : '') .
                '>' .
                JText::_($text_code) .
                '</label>';
        }

        return $html;
    }

    /**
     * @param string $name
     * @return string
     */
    public static function id($name)
    {
        return 'mj_' . str_replace('.', '-', $name);
    }

    /**
     * @param string $text
     * @return string
     */
    public static function text($text)
    {
        $html = '<p class="help-inline">' . $text . '</p>';
        return $html;
    }

    /**
     * @param string $name
     * @param string $value
     * @param array $attrs
     * @return string
     */
    public static function textinput($name, $value, $attrs = array())
    {
        $name = self::id($name);

        $attrs['name'] = $name;
        $attrs['id'] = $name;
        $attrs['value'] = htmlspecialchars($value);
        $attrs['class'] = isset($attrs['class']) ? $attrs['class'] . ' ' : '';
        $attrs['class'] .= 'form-control input-large input-block-level';

        $html = '<input type="text"';
        foreach ($attrs as $attrName => $attrValue) {
            $html .= ' ' . $attrName . '="' . $attrValue . '"';
        }
        $html .= '>';

        return $html;
    }

    /**
     * @param string $name
     * @param string $value
     * @param array $attrs
     * @param string $default
     * @return string
     */
    public static function numberinput($name, $value, $attrs = array(), $default = '')
    {
        $name = self::id($name);

        $attrs['name'] = $name;
        $attrs['id'] = $name;
        $attrs['value'] = htmlspecialchars($value);
        $attrs['class'] = isset($attrs['class']) ? $attrs['class'] . ' ' : '';
        $attrs['class'] .= 'form-control input-small input-block-level';
        $attrs['placeholder'] = htmlspecialchars($default);

//        $html = '<input type="number"';
        $html = '<input type="text"'; // allow empty value
        foreach ($attrs as $name => $value) {
            $html .= ' ' . $name . '="' . $value . '"';
        }
        $html .= '>';

        return $html;

    }

    /**
     * @param string $name
     * @param string $value
     * @param array $items
     * @return string
     */
    public static function radio($name, $value, $items)
    {
        $name = self::id($name);

        if ($value === null) {
            $value = ''; // "global" value
        }

        $value = (string)$value;

        $html = '<fieldset class="radio btn-group btn-group-yesno">';
        foreach ($items as $key => $title) {
            $html .=
                '<label for="jform_' . $name . $key . '">' .
                '<input type="radio"' .
                ' name="' . $name . '"' .
                ' id="jform_' . $name . $key . '"' .
                ' value="' . $key . '"' .
                ($value === (string)$key ? ' checked="checked"' : '') .
                '>' .
                $title .
                '</label>';
        }
        $html .= '</fieldset>';

        return $html;
    }

    /**
     * @param string $name
     * @param bool $value
     * @return string
     */
    public static function onoff($name, $value)
    {
        $name = self::id($name);

        $html =
            '<fieldset class="radio btn-group btn-group-yesno">' .
            '<label for="jform_' . $name . '1">' .
            '<input type="radio" name="' . $name . '" id="jform_' . $name . '1" value="1"' . ($value ? ' checked="checked"' : '') . '>' .
            JText::_('COM_MJ__YES') .
            '</label>' .
            '<label for="jform_' . $name . '0">' .
            '<input type="radio" name="' . $name . '" id="jform_' . $name . '0" value="0"' . ($value ? '' : ' checked="checked"') . '>' .
            JText::_('COM_MJ__NO') .
            '</label>' .
            '</fieldset>';
        return $html;
    }

    /**
     * @param string $name
     * @param string $value
     * @return string
     */
    public static function gonoff($name, $value)
    {
        $name = self::id($name);

        if ($value === null) {
            $value = ''; // "global" value
        }

        $value = (string)$value;

        $html =
            '<fieldset class="radio btn-group btn-group-yesno">' .
            '<label for="jform_' . $name . '1">' .
            '<input type="radio" name="' . $name . '" id="jform_' . $name . '1" value="1"' . ($value !== '1' ? '' : ' checked="checked"') . '>' .
            JText::_('COM_MJ__YES') .
            '</label>' .
            '<label for="jform_' . $name . '">' .
            '<input type="radio" name="' . $name . '" id="jform_' . $name . '" value=""' . ($value !== '' ? '' : ' checked="checked"') . '>' .
            JText::_('COM_MJ__GLOBAL') .
            '</label>' .
            '<label for="jform_' . $name . '0">' .
            '<input type="radio" name="' . $name . '" id="jform_' . $name . '0" value="0"' . ($value !== '0' ? '' : ' checked="checked"') . '>' .
            JText::_('COM_MJ__NO') .
            '</label>' .
            '</fieldset>';
        return $html;
    }

    /**
     * @param string $name
     * @param int $value
     * @param int $min
     * @param int $max
     * @param string $unit
     * @return string
     */
    public static function slider($name, $value, $min = 0, $max = 100, $unit = '%')
    {
        $name = self::id($name);

        $html =
            '<span class="slider-container">' .
            '<span id="' . $name . '_slider" target="' . $name . '" class="slider">' .
            '<span id="' . $name . '_knob" class="knob"></span>' .
            '</span>' .
            '</span>' .
            '<span class="slider-input-container">' .
            '<span class="input-append">' .
            '<input type="text" class="slider form-control input-mini input-block-level" id="' . $name . '" name="' . $name . '" value="' . $value . '" size="2">' .
            '<span class="add-on">' . $unit . '</span>' .
            '</span>' .
            '</span>';
        return $html;
    }

    /**
     * @param string $name
     * @param array|string $value
     * @param bool $multiple
     * @param string $updateName
     * @return string
     */
    public static function menulisturl($name, $value, $multiple = false, $updateName = '')
    {
        $menuoptions = self::menuoptions();

        $html = '<select class="form-control input-large input-block-level" size="7"';
        if ($name) {
            $html .= ' name="' . self::id($name) . ($multiple ? '[]' : '') . '"';
        }
        if ($multiple) {
            $html .= ' multiple="multiple"';
        }
        if ($updateName) {
            $html .= ' onchange="document.getElementById(\'' . self::id($updateName) . '\').value=this.value"';
        }
        $html .= '>';

        $value = (array)$value;

        foreach ($menuoptions as $item) {
            if ($multiple && $item['value'] === '') {
                continue;
            }
            switch ($item['value']) {
                case '<OPTGROUP>':
                    $html .= '<optgroup label="' . $item['text'] . '">';
                    break;
                case '</OPTGROUP>':
                    $html .= '</optgroup>';
                    break;
                default:
                    $html .=
                        '<option value="' . $item['value'] . '"' .
                        (in_array((string)$item['value'], $value, true) ? ' selected' : '') .
                        ($item['disabled'] ? ' disabled' : '') .
                        '>' .
                        $item['text'] .
                        '</option>';
            }
        }

        $html .= '</select>';
        return $html;
    }

    /**
     * @param string $name
     * @param array|string $value
     * @param bool $multiple
     * @param string $updateName
     * @return string
     */
    public static function menulistid($name, $value, $multiple = false, $updateName = '')
    {
        $menuoptions = self::menuoptions();

        $html = '';
        if ($multiple) {
            $html .= '<input type="hidden" name="' . self::id($name) . '[]" value="">';
        }
        $html .= '<select class="form-control input-large input-block-level" size="7"';
        if ($name) {
            $html .= ' name="' . self::id($name) . ($multiple ? '[]' : '') . '"';
        }
        if ($multiple) {
            $html .= ' multiple="multiple"';
        }
        if ($updateName) {
            $html .= ' onchange="document.getElementById(\'' . self::id($updateName) . '\').value=this.value"';
        }
        $html .= '>';

        $value = (array)$value;

        foreach ($menuoptions as $item) {
            if ($multiple && $item['value'] === '') {
                continue;
            }
            switch ($item['value']) {
                case '<OPTGROUP>':
                    $html .= '<optgroup label="' . $item['text'] . '">';
                    break;
                case '</OPTGROUP>':
                    $html .= '</optgroup>';
                    break;
                default:
                    $html .=
                        '<option value="' . $item['id'] . '"' .
                        (in_array((string)$item['id'], $value, true) ? ' selected' : '') .
                        ($item['disabled'] ? ' disabled' : '') .
                        '>' .
                        $item['text'] .
                        '</option>';
            }
        }

        $html .= '</select>';
        return $html;
    }

    /**
     * @return array
     */
    private static function menuoptions()
    {
        static $menuoptions;
        if ($menuoptions !== null) {
            return $menuoptions;
        }

        $joomlaWrapper = MjJoomlaWrapper::getInstance();
        $db = $joomlaWrapper->getDbo();

        $isJoomla15 = (strncmp(JVERSION, '1.5.', 4) === 0);

        $query = new MjQueryBuilder($db);
        if (version_compare(JVERSION, '3.0', '>=')) { // 3.0+
            $query
                ->select('id', 'menutype', 'title', 'link', 'type', 'parent_id')
                ->from('#__menu')
                ->where($query->qn('published') . '=1')
                ->order('menutype', 'parent_id', 'lft')
                ->setQuery();
        } elseif (version_compare(JVERSION, '1.6', '>=')) { //1.6-2.5
            $query
                ->select('id', 'menutype', 'title', 'link', 'type', 'parent_id')
                ->from('#__menu')
                ->where($query->qn('published') . '=1')
                ->order('menutype', 'parent_id', 'ordering')
                ->setQuery();
        } else { //1.5
            $query
                ->select('id', 'menutype', $query->qn('name') . ' AS ' . $query->qn('title'),
                    'link', 'type', $query->qn('parent') . ' AS ' . $query->qn('parent_id'))
                ->from('#__menu')
                ->where($query->qn('published') . '=1')
                ->order('menutype', 'parent', 'ordering')
                ->setQuery();
        }
        /** @var array $mitems */
        $mitems = $db->loadObjectList();
        $children = array();
        foreach ($mitems as $v) {
            $pt = $v->parent_id;
            $list = !empty($children[$pt]) ? $children[$pt] : array();
            $list[] = $v;
            $children[$pt] = $list;
        }
        $list = array();
        $id = $isJoomla15 ? 0 : 1;
        if (!empty($children[$id])) {
            self::TreeRecurse($id, '', $list, $children);
        }

        $mitems = array();
        $mitems[] = array('value' => '', 'text' => '&nbsp;', 'id' => 0, 'disabled' => false);
        $lastMenuType = null;
        foreach ($list as $list_a) {
            if ($list_a->menutype !== $lastMenuType) {
                if ($lastMenuType) {
                    $mitems[] = array('value' => '</OPTGROUP>');
                }
                $mitems[] = array('value' => '<OPTGROUP>', 'text' => $list_a->menutype);
                $lastMenuType = $list_a->menutype;
            }
            if ($list_a->type === 'component') {
                $link = $list_a->link . '&Itemid=' . $list_a->id;
            } else {
                $link = '-';
            }
            $mitems[] = array('value' => $link, 'text' => $list_a->treename, 'id' => $list_a->id, 'disabled' => ($link === '-'));
        }
        if ($lastMenuType !== null) {
            $mitems[] = array('value' => '</OPTGROUP>');
        }

        $menuoptions = $mitems;
        return $mitems;
    }

    /**
     * @param int $id
     * @param string $indent
     * @param array $list
     * @param array $children
     * @param int $level
     */
    private static function TreeRecurse($id, $indent, &$list, &$children, $level = 0)
    {
        foreach ($children[$id] as $v) {
            $id = $v->id;
            $list[$id] = $v;
            $list[$id]->treename = $indent . $v->title;
            if (!empty($children[$id]) && $level <= 99) {
                self::TreeRecurse($id, $indent . '&nbsp;&nbsp;', $list, $children, $level + 1);
            }
        }
    }

    /**
     * @param string $name
     * @param string $value
     * @return string
     */
    public static function template($name, $value)
    {
        static $templates;
        if ($templates === null) {
            $isJoomla15 = (strncmp(JVERSION, '1.5.', 4) === 0);

            $templates = array();
            $templates[''] = JText::_('COM_MJ__DEFAULT_TEMPLATE_OPTION');

            if ($isJoomla15) {
                $templateBaseDir = JPATH_SITE . '/templates/';

                jimport('joomla.installer.installer');
                jimport('joomla.filesystem.file');
                jimport('joomla.filesystem.folder');
                $templateDirs = JFolder::folders($templateBaseDir);
                foreach ($templateDirs as $templateDir) {
                    $templateFile = $templateBaseDir . $templateDir . '/templateDetails.xml';
                    if (JFile::exists($templateFile)) {
                        $xml = JApplicationHelper::parseXMLInstallFile($templateFile);
                        if ($xml['type'] === 'template') {
                            $templates[$templateDir] = $templateDir;
                        }
                    }
                }
            } else {
                $joomlaWrapper = MjJoomlaWrapper::getInstance();
                $db = $joomlaWrapper->getDbo();
                $query = new MjQueryBuilder($db);
                $rows = $query
                    ->select('id', 'title')
                    ->from('#__template_styles')
                    ->where('client_id=0')
                    ->order('title')
                    ->setQuery()
                    ->loadObjectList();
                foreach ($rows as $row) {
                    $templates[$row->id] = $row->title;
                }
            }
        }

        return self::select($name, $value, $templates);
    }

    /**
     * @param string $name
     * @param string $value
     * @param array $items
     * @return string
     */
    public static function select($name, $value, $items)
    {
        $name = self::id($name);

        if ($value === null) {
            $value = ''; // "global" value
        }

        $value = (string)$value;

        $html = '<select name="' . $name . '" class="form-control">';
        foreach ($items as $key => $item) {
            $html .=
                '<option value="' . $key . '"' . ($value === (string)$key ? ' selected="selected"' : '') . '>' .
                $item .
                '</option>';
        }
        $html .= '</select>';
        return $html;
    }

    /**
     * @param string $name
     * @param string $value
     * @return string
     */
    public static function textarea($name, $value)
    {
        $name = self::id($name);
        $value = (string)$value;

        return
            '<textarea name="' . $name . '" rows="3" class="row-fluid">'
            . htmlspecialchars($value)
            . '</textarea>';
    }

    /**
     * @param string $name
     * @param string $value
     * @param array $attrs
     * @return string
     */
    public static function hidden($name, $value, $attrs = array())
    {
        $name = self::id($name);

        $attrs['name'] = $name;
        $attrs['id'] = $name;
        $attrs['value'] = htmlspecialchars($value);

        $html = '<input type="hidden"';
        foreach ($attrs as $name => $value) {
            $html .= ' ' . $name . '="' . $value . '"';
        }
        $html .= '>';

        return $html;
    }

    public static function prolabel($text_code)
    {
        return '<label class="mjpro control-label">' . JText::_($text_code) . '</label>';
    }

    public static function proonoff()
    {
        $html =
            '<fieldset class="radio btn-group btn-group-yesno">' .
            '<label class="btn active">' .
            '<input type="radio" value="1">' .
            JText::_('COM_MJ__YES') .
            '</label>' .
            '<label class="btn active">' .
            '<input type="radio" value="0">' .
            JText::_('COM_MJ__NO') .
            '</label>' .
            '</fieldset>';
        return $html;
    }

    public static function proslider($value, $min = 0, $max = 100, $unit = '%')
    {
        $name = mt_rand();
        $html =
            '<span class="slider-container">' .
            '<span id="' . $name . '_slider" target="' . $name . '" class="slider">' .
            '<span id="' . $name . '_knob" class="knob"></span>' .
            '</span>' .
            '</span>' .
            '<span class="slider-input-container">' .
            '<span class="input-append">' .
            '<input type="text" class="slider form-control input-mini input-block-level" id="' . $name . '" value="' . $value . '" size="2">' .
            '<span class="add-on">' . $unit . '</span>' .
            '</span>' .
            '</span>';
        return $html;
    }

}