<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die('Restricted access');

class MJ_Ressio_DeviceDetector extends Ressio_DeviceDetector_Base
{
    /** @var int */
    protected $screen_width;
    /** @var int */
    protected $screen_height;
    /** @var float */
    protected $screen_dpr;
    /** @var array */
    protected $imgformats;
    /** @var string */
    protected $category;

    /**
     * MJ_Ressio_DeviceDetector constructor.
     * @param MjDevice $mjDevice
     */
    public function __construct($mjDevice)
    {
        parent::__construct();
        $this->screen_width = $mjDevice->screenwidth;
        $this->screen_height = $mjDevice->screenheight;
        $this->screen_dpr = $mjDevice->pixelratio;
        $this->imgformats = $mjDevice->imageformats;
        $this->category = $mjDevice->markup;
    }
    /** @return int */
    public function screen_width()
    {
        return $this->screen_width;
    }

    /** @return int */
    public function screen_height()
    {
        return $this->screen_height;
    }

    /** @return float */
    public function screen_dpr()
    {
        return $this->screen_dpr;
    }

    /** @return array */
    public function browser_imgformats()
    {
        return $this->imgformats;
    }

    /** @return bool */
    public function browser_js()
    {
        // @todo get from amdd data
        return true;
    }

    /** @return string */
    public function category()
    {
        return $this->category;
    }

    /** @return bool */
    public function isDesktop()
    {
        return empty($this->category) || $this->category === 'desktop';
    }

    /** @return bool */
    public function isMobile()
    {
        return $this->category === 'mobile';
    }
}
