<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die('Restricted access');

require_once JPATH_COMPONENT . '/classes/mjcontroller.php';

class MjDefaultController extends MjController
{
    public function save($msg = '')
    {
        include_once JPATH_COMPONENT . '/models/settings.php';
        $mjSettings = new MjSettingsModel($this->joomlaWrapper);

        $bindData = array();
        foreach ($_POST as $key => $value) {
            if (strpos($key, 'mj_') === 0) {
                $param = substr($key, 3);
                $param = str_replace('-', '.', $param);
                $bindData[$param] = $value;
            }
        }

        if (!$mjSettings->bind($bindData)) {
            $msg = JText::_('COM_MJ__ERROR_IN_DATA');
        } elseif (!$mjSettings->save()) {
            $msg = JText::_('COM_MJ__ERROR_CANNOT_SAVE_DATA');
        } else {
            $msg = JText::_('COM_MJ__ERROR_DATA_HAVE_BEEN_SAVED_SUCCESSFULLY');
        }

        parent::save($msg);
    }
}