<?php
/*
 * RESSIO Responsive Server Side Optimizer
 * https://github.com/ressio/
 *
 * @copyright   Copyright (C) 2013-2018 Kuneri, Ltd. All rights reserved.
 * @license     GNU General Public License version 2
 */

defined('RESSIO_PATH') or die('RESS: Restricted access');

class Ressio_HtmlOptimizer_Dom_AttrArray implements ArrayAccess
{
    /** @var Ressio_HtmlOptimizer_Dom_Element $node */
    private $node;

    /**
     * @param Ressio_HtmlOptimizer_Dom_Element $node
     */
    public function __construct($node)
    {
        $this->node = $node;
    }

    /**
     * @param string $offset
     * @return bool
     */
    public function offsetExists($offset)
    {
        return $this->node->hasAttribute($offset);
    }

    /**
     * @param string $offset
     * @return string
     */
    public function offsetGet($offset)
    {
        return $this->node->getAttribute($offset);
    }

    /**
     * @param string $offset
     * @param string $value
     */
    public function offsetSet($offset, $value)
    {
        $this->node->setAttribute($offset, $value);
    }

    /**
     * @param string $offset
     */
    public function offsetUnset($offset)
    {
        $this->node->removeAttribute($offset);
    }
}
