<?php
/**
 * @version    $Id$
 * @package    JSN_PageBuilder
 * @author     JoomlaShine Team <support@joomlashine.com>
 * @copyright  Copyright (C) 2012 JoomlaShine.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.joomlashine.com
 * Technical Support:  Feedback - http://www.joomlashine.com/contact-us/get-support.html
 */

// No direct access to this file.
defined('_JEXEC') || die('Restricted access');

/**
 * Pricing Table Item shortcode element
 *
 * @package  JSN_PageBuilder
 * @since    1.0.0
 */
class JSNPBShortcodePricingTableItem extends IG_Pb_Child {

	/**
	 * Constructor
	 *
	 * @return type
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Include admin scripts
	 * 
	 * @return type
	 */
	public function backend_element_assets() {
		JSNPBShortcodePricingTable::addPRCellTemplate();
		$document = JFactory::getDocument();
		$document->addScript( JSNPB_ASSETS_URL . 'joomlashine/js/jsn-popover.js', 'text/javascript' );
		$document->addScript( JSNPB_ELEMENT_URL.'/pricingtable/assets/js/item.js', 'text/javascript' );
		$document->addStyleSheet( JSNPB_ELEMENT_URL.'/pricingtable/assets/css/pricingtable-item-setting.css', 'text/css' );
	}
	
	/**
	 * DEFINE configuration information of shortcode
	 *
	 * @return type
	 */
	public function element_config() {
		$this->config['shortcode'] = 'pb_pricingtable_item';
		$this->config['exception'] = array(
			//'require_js' => array( 'ig-popover.js', 'item_pricingtable.js' ),
			'item_text'        => JText::_( 'Option' ),
			'data-modal-title' => JText::_( 'Option' ),
		);
	}

	/**
	 * DEFINE setting options of shortcode
	 *
	 * @return type
	 */
	public function element_items() {
		$this->items = array(
			'NoTab' => array(
				array(
					'name'    => JText::_( 'Title' ),
					'id'      => 'prtbl_item_title',
					'type'    => 'text_field',
					'class'   => 'jsn-input-xxlarge-fluid',
					'role'    => 'title',
					'std'     => JText::_( 'Option PB_INDEX_TRICK' ),
					'tooltip' => JText::_( 'Title' )
				),
				array(
					'name'    => JText::_( 'Description' ),
					'id'      => 'prtbl_item_desc',
					'type'    => 'text_field',
					'class'   => 'jsn-input-xxlarge-fluid',
					'std'     => JText::_( '' ),
					'tooltip' => JText::_( 'Description Tooltip' )
				),
				array(
					'name'    => JText::_( 'Image' ),
					'id'      => 'prtbl_item_image',
					'type'    => 'select_media',
					'std'     => '',
					'class'   => 'jsn-input-large-fluid',
					'tooltip' => JText::_( 'Image File' )
				),
				array(
					'name'    => JText::_( 'Price' ),
					'id'      => 'prtbl_item_price',
					'type'    => 'text_field',
					'std'     => JText::_( '' ),
					'class'   => 'jsn-input-large-fluid pb_pb_price',
					'tooltip' => JText::_( 'Price' )
				),
				array(
					'name'    => JText::_( 'Button Text' ),
					'id'      => 'prtbl_item_button_text',
					'type'    => 'text_field',
					'class'   => 'jsn-input-large-fluid pb-pb-limit-length',
					'std'     => JText::_( '' ),
					'tooltip' => JText::_( 'Button Text' )
				),
				array(
					'name'       => JText::_( 'Button Link' ),
					'id'         => 'link_type',
					'type'       => 'select',
					'std'        => '',
					'options'    => JSNPagebuilderHelpersType::getLinkTypes(),
					'tooltip'    => JText::_( 'Button Link' ),
					'has_depend' => '1',
				),
				array(
					'name'       => JText::_( 'URL' ),
					'id'         => 'button_type_url',
					'type'       => 'text_field',
					'class'      => 'jsn-input-xxlarge-fluid',
					'std'        => 'http://',
					'tooltip'    => JText::_( 'URL' ),
					'dependency' => array( 'link_type', '=', 'url' )
				),
				/*array(
						'name'  => JText::_( 'Single Item' ),
						'id'    => 'single_item',
						'type'  => 'type_group',
						'std'   => '',
						'items' => JSNPagebuilderHelpersType::get_single_item_button_bar(
								'link_type',
								array(
										'type'         => 'items_list',
										'options_type' => 'select',
										'class'        => 'select2-select',
										'ul_wrap'      => false,
								)
						),
				),*/
				array(
					'name'       => JText::_( 'Open in' ),
					'id'         => 'open_in',
					'type'       => 'select',
					'std'        => JSNPagebuilderHelpersType::getFirstOption( JSNPagebuilderHelpersType::getOpenInOptions() ),
					'options'    => JSNPagebuilderHelpersType::getOpenInOptions(),
					'tooltip'    => JText::_( 'Open in' ),
					'dependency' => array( 'link_type', '!=', 'no_link' )
				),
				array(
					'id'              => 'prtbl_item_attributes',
					'type'            => 'text_field',
					'std'             => '',
					'input-type'      => 'hidden',
					'container_class' => 'hidden',
				),
				array(
					'name'    => JText::_( 'Featured' ),
					'id'      => 'prtbl_item_feature',
					'type'    => 'radio',
					'std'     => 'no',
					'options' => array( 'yes' => JText::_( 'Yes' ), 'no' => JText::_( 'No' ) ),
					'tooltip' => JText::_( 'Featured' ),
				),
			)
		);
	}

	/**
	 * DEFINE shortcode content
	 *
	 * @param type $atts
	 * @param type $content
	 *
	 * @return string
	 */
	public function element_shortcode( $atts = null, $content = null ) {
		$params['prtbl_item_title']       = isset( $atts['prtbl_item_title'] ) ? $atts['prtbl_item_title'] : '';
		$params['prtbl_item_desc']        = isset( $atts['prtbl_item_desc'] ) ? $atts['prtbl_item_desc'] : '';
		$params['prtbl_item_image']       = isset( $atts['prtbl_item_image'] ) ? $atts['prtbl_item_image'] : '';
		$params['prtbl_item_price']       = isset( $atts['prtbl_item_price'] ) ? $atts['prtbl_item_price'] : '';
		$params['prtbl_item_button_text'] = isset( $atts['prtbl_item_button_text'] ) ? $atts['prtbl_item_button_text'] : JText::_( 'Buy now' );
		$params['link_type']              = isset( $atts['link_type'] ) ? $atts['link_type'] : '';
		$params['button_type_url']        = isset( $atts['button_type_url'] ) ? $atts['button_type_url'] : '';
		$params['single_item']            = isset( $atts['single_item'] ) ? $atts['single_item'] : '';
		$params['open_in']                = isset( $atts['open_in'] ) ? $atts['open_in'] : '';
		$params['prtbl_item_attributes']  = isset( $atts['prtbl_item_attributes'] ) ? $atts['prtbl_item_attributes'] : '';
		$params['prtbl_item_feature']     = isset( $atts['prtbl_item_feature'] ) ? $atts['prtbl_item_feature'] : '';

		extract( $params );
		$html_element = $href = '';

		if ( $link_type == 'url' ) {
			$href = ( ! $button_type_url ) ? ' href="#"' : " href='{$button_type_url}'";
		}
		$target = '';
		if ( $open_in ) {
			switch ( $open_in ) {
				case 'current_browser':
					$target = '';
					break;
				case 'new_browser':
					$target = ' target="_blank"';
					break;
				case 'lightbox':
					$cls_button_fancy = ' pb-prtbl-button-fancy';
					break;
			}
		}
		$button_type      = " type='button'";
        $attr_image = '';
		$cls_button_fancy = ( ! isset( $cls_button_fancy ) ) ? '' : $cls_button_fancy;
        $this->config['params'] = JSNPagebuilderHelpersShortcode::generateShortcodeParams( $this->items );
        if ( $prtbl_item_image ) {
            $attr_image = '[prtbl_item_image]<div class="pb-prtbl-image"> <img src="' . $prtbl_item_image . '" /></div>[/prtbl_item_image]';
        }
        $attr_title             = '[prtbl_item_title]<div class="pb-prtbl-title">' .$attr_image .'<h3>'. $prtbl_item_title . '</h3></div>[/prtbl_item_title]';

        $attr_title     .= '<div class="pb-prtbl-meta">';
        if ( $prtbl_item_price ) {
            $attr_title .= '[prtbl_item_price]<div class="pb-prtbl-price">' . $prtbl_item_price . '</div>[/prtbl_item_price]';
        }
        $attr_title             .= '[prtbl_item_desc]<div class="pb-prtbl-desc">' . $prtbl_item_desc . '</div>[/prtbl_item_desc]';
        $attr_title     .= '</div>';


        $html_element .= '<div class="pb-prtbl-header">' . $attr_title . '</div>';
        if ( ! empty( $content ) ) {

            $html_element .= '[prtbl_item_attributes]__no_item__[/prtbl_item_attributes]';

        }
        $html_element .= "[prtbl_item_button]<div class='pb-prtbl-footer'><a class='btn btn-default {$cls_button_fancy}'{$href}{$target}{$button_type}>{$prtbl_item_button_text}</a></div>[/prtbl_item_button]";
        $featured     = ( $prtbl_item_feature == 'yes' ) ? ' pb-prtbl-cols-featured' : '';
        return "<div class='pb-prtbl-cols {$featured}'>" . $html_element . '</div>';
	}

	/**
	 * DEFINE html structure of shortcode in Page Builder area
	 *
	 * @param type $content
	 * @param type $shortcode_data: string stores params ( which is modified default value ) of shortcode
	 * @param type $el_title: Element Title used to identifying elements in Pagebuilder
	 * Ex:  param-tag=h6&param-text=Your+heading&param-font=custom&param-font-family=arial
	 * @return type
	 */
	public function element_in_pgbldr( $content = '', $shortcode_data = '', $el_title = '' ) {
		$html = parent::element_in_pgbldr( $content, $shortcode_data, $el_title );
		return $html;
	}

}
