<?php
/**
 * @version    $Id$
 * @package    JSN_PageBuilder
 * @author     JoomlaShine Team <support@joomlashine.com>
 * @copyright  Copyright (C) 2012 JoomlaShine.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.joomlashine.com
 * Technical Support:  Feedback - http://www.joomlashine.com/contact-us/get-support.html
 */

// No direct access to this file.
defined('_JEXEC') || die('Restricted access');

include_once (dirname(__FILE__) . '/pricingtable/item.php');
include_once (dirname(__FILE__) . '/pricingtablelabel/pricingtablelabel.php');

/**
 * Pricing Table shortcode element
 *
 * @package  JSN_PageBuilder
 * @since    1.0.0
 */
class JSNPBShortcodePricingTable extends IG_Pb_Element {

	/**
	 * Constructor
	 *
	 * @return type
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Add cell pricing table template
	 *
	 * @return type
	 */
	public static function addPRCellTemplate() {
		$document = JFactory::getDocument();
		$data = array(
				'element_wrapper' => 'li',
				'modal_title' => 'data-modal-title="PB_OPTIONS_ATTRIBUTES"',
				'element_type' => 'data-el-type="element"',
				'name' => 'Pricingtable Item',
				'shortcode' => 'pb_pricingtable_item_item',
				'shortcode_data' => 'PB_SHORTCODE_CONTENT',
				'content_class' => 'jsn-item-content',
				'content' => 'PB_CONTENT',
				'action_btn' => 'edit',
				'is_prtbl' => TRUE,
		);
		$prtbl_item_cell = addslashes( JSNPagebuilderHelpersFunctions::getElementItemHtml( $data ) );
		$prtbl_item_cell = preg_replace("/\s+/", " ", $prtbl_item_cell);
		$data = array(
				'element_wrapper' => 'li',
				'modal_title' => 'data-modal-title="PB_OPTIONS_ATTRIBUTES"',
				'element_type' => 'data-el-type="element"',
				'name' => 'Pricingtable Label',
				'shortcode' => 'pb_pricingtablelabel_item',
				'shortcode_data' => 'PB_SHORTCODE_CONTENT',
				'content_class' => 'jsn-item-content',
				'content' => 'PB_CONTENT',
				'exclude_gen_shortcode' => 'exclude_gen_shortcode',
				'has_preview' => FALSE,
		);
		$prtbl_item_cell_label = addslashes( JSNPagebuilderHelpersFunctions::getElementItemHtml( $data ) );
		$prtbl_item_cell_label = preg_replace("/\s+/", " ", $prtbl_item_cell_label);
		$script = '
			var JSNPbParams	= JSNPbParams || {};
			JSNPbParams.prtbl_item_cell = "' .$prtbl_item_cell. '";
			JSNPbParams.prtbl_item_cell_label = "' .$prtbl_item_cell_label. '";
			JSNPbParams.no_title = \'' .JText::_( '(Untitled)' ). '\';
		';
		$document->addScriptDeclaration( $script, 'text/javascript' );
	}
	
	/**
	 * Include admin scripts
	 * 
	 * @return type
	 */
	public function backend_element_assets() {
		$document = JFactory::getDocument();
		self::addPRCellTemplate();
		$document->addScript( JSNPB_ELEMENT_URL.'/pricingtable/assets/js/pricingtable-setting.js', 'text/javascript' );
		$document->addStyleSheet( JSNPB_ELEMENT_URL.'/pricingtable/assets/css/pricingtable-setting.css', 'text/css' );
	}
	
	/**
	 * DEFINE configuration information of shortcode
	 *
	 * @return type
	 */
	public function element_config() {
		$this->config['shortcode']        = 'pb_pricingtable';
		$this->config['name']             = JText::_( 'Pricing Table' );
		$this->config['cat']              = JText::_( 'Extra' );
		$this->config['icon']             = 'icon-pricing-table';
		$this->config['description']      = JText::_("Pricing table with flexible settings");
		$this->config['has_subshortcode'] = __CLASS__ . 'Item';
		$this->config['exception']        = array(
			'default_content'  => JText::_( 'Pricing Table' ),
			'data-modal-title' => JText::_( 'Pricing Table' )
		);
	}

	/**
	 * DEFINE setting options of shortcode
	 *
	 * @return type
	 */
	public function element_items() {
		$this->items = array(
			'content' => array(
				array(
					'name'    => JText::_( 'Element Title' ),
					'id'      => 'el_title',
					'type'    => 'text_field',
					'class'   => 'jsn-input-xxlarge-fluid',
					'std'     => JText::_( 'Pricing Table PB_INDEX_TRICK' ),
					'role'    => 'title',
					'tooltip' => JText::_( 'Set title for current element for identifying easily' )
				),
				array(
					'name'            => JText::_( 'Attributes' ),
					'id'              => 'prtbl_attr_label',
					'type'            => 'group',
					'style'           => 'height: 150px',
					'shortcode'       => $this->config['shortcode'],
					'sub_shortcode'   => 'pb_pricingtablelabel_item',
					'sub_item_type'   => $this->config['shortcode'] . 'labelItem',
					'sub_items'       => array(),
					'shortcode_name'  => $this->config['shortcode'] . 'labelItem',
					'use_id'          => '1',
					'empty_sub_items' => '1',
					'tooltip'         => JText::_( 'Attributes' )
				),
				array(
					'id' => 'prtbl_common_label_json',
					'type' => 'text_field',
					'std' => '--open_square--pb_pricingtablelabel_item item_prtbl_unique_id=--quote--UfhJBeOX--quote-- prtbl_item_item_title=--quote--Max Domains--quote-- item_item_desc_area=--quote--Max Domains--quote-- prtbl_item_item_type=--quote--text--quote-- --close_square----open_square--/pb_pricingtablelabel_item--close_square--__#__--open_square--pb_pricingtablelabel_item item_prtbl_unique_id=--quote--kbQlRgPJ--quote-- prtbl_item_item_title=--quote--Storage--quote-- item_item_desc_area=--quote--Storage--quote-- prtbl_item_item_type=--quote--text--quote-- --close_square----open_square--/pb_pricingtablelabel_item--close_square--__#__--open_square--pb_pricingtablelabel_item item_prtbl_unique_id=--quote--YyClXJUX--quote-- prtbl_item_item_title=--quote--SSL Support--quote-- item_item_desc_area=--quote--SSL Support--quote-- prtbl_item_item_type=--quote--checkbox--quote-- --close_square----open_square--/pb_pricingtablelabel_item--close_square--__#__',
					'input-type' => 'hidden',
					'container_class' => 'hidden',
				),
				array(
					'name'          => JText::_( 'Options' ),
					'id'            => 'prtbl_items',
					'type'          => 'group',
					'style'         => 'height: 150px',
					'no_title'      => JText::_( '(Untitled)' ),
					'shortcode'     => $this->config['shortcode'],
					'sub_item_type' => $this->config['has_subshortcode'],
					'sub_items'     => array(
						array( 'std' => '[pb_pricingtable_item prtbl_item_title="Free" prtbl_item_desc="Free" prtbl_item_price="$ 99 / month" prtbl_item_button_text="Buy now" link_type="no_link" prtbl_item_attributes="--open_square--pb_pricingtable_item_item item_prtbl_id=--quote--UfhJBeOX--quote-- prtbl_item_item_content=--quote--1--quote-- item_item_desc=--quote--1--quote-- --close_square----open_square--/pb_pricingtable_item_item--close_square--__#__--open_square--pb_pricingtable_item_item item_prtbl_id=--quote--kbQlRgPJ--quote-- prtbl_item_item_content=--quote--100 MB--quote-- item_item_desc=--quote--100 MB--quote-- --close_square----open_square--/pb_pricingtable_item_item--close_square--__#__pb_prtbl_checked checked_id=--quote--YyClXJUX--quote-- checked_value=--quote--yes--quote--__#__" prtbl_item_item_content="Option 1" prtbl_item_feature="no" ][pb_pricingtable_item_item item_prtbl_id="UfhJBeOX" prtbl_item_item_content="1" item_item_desc="1" ][/pb_pricingtable_item_item][pb_pricingtable_item_item item_prtbl_id="kbQlRgPJ" prtbl_item_item_content="100 MB" item_item_desc="100 MB" ][/pb_pricingtable_item_item][/pb_pricingtable_item]' ),
						array( 'std' => '[pb_pricingtable_item prtbl_item_title="Standard" prtbl_item_desc="Standard" prtbl_item_price="$ 99 / month" prtbl_item_button_text="Buy now" link_type="url" button_type_url="http://" open_in="current_browser" prtbl_item_attributes="--open_square--pb_pricingtable_item_item item_prtbl_id=--quote--UfhJBeOX--quote-- prtbl_item_item_content=--quote--5--quote-- item_item_desc=--quote--5--quote-- --close_square----open_square--/pb_pricingtable_item_item--close_square--__#__--open_square--pb_pricingtable_item_item item_prtbl_id=--quote--kbQlRgPJ--quote-- prtbl_item_item_content=--quote--500 MB--quote-- item_item_desc=--quote--500 MB--quote-- --close_square----open_square--/pb_pricingtable_item_item--close_square--__#__pb_prtbl_checked checked_id=--quote--YyClXJUX--quote-- checked_value=--quote--yes--quote--__#__" prtbl_item_item_content="Option 2" prtbl_item_feature="yes" ][pb_pricingtable_item_item item_prtbl_id="UfhJBeOX" prtbl_item_item_content="5" item_item_desc="5" ][/pb_pricingtable_item_item][pb_pricingtable_item_item item_prtbl_id="kbQlRgPJ" prtbl_item_item_content="500 MB" item_item_desc="500 MB" ][/pb_pricingtable_item_item][/pb_pricingtable_item]' ),
						array( 'std' => '[pb_pricingtable_item prtbl_item_title="Premium" prtbl_item_desc="Premium" prtbl_item_price="$ 99 / month" prtbl_item_button_text="Buy now" link_type="url" button_type_url="http://" open_in="current_browser" prtbl_item_attributes="--open_square--pb_pricingtable_item_item item_prtbl_id=--quote--UfhJBeOX--quote-- prtbl_item_item_content=--quote--20--quote-- item_item_desc=--quote--20--quote-- --close_square----open_square--/pb_pricingtable_item_item--close_square--__#__--open_square--pb_pricingtable_item_item item_prtbl_id=--quote--kbQlRgPJ--quote-- prtbl_item_item_content=--quote--2 TB--quote-- item_item_desc=--quote--2 TB--quote-- --close_square----open_square--/pb_pricingtable_item_item--close_square--__#__pb_prtbl_checked checked_id=--quote--YyClXJUX--quote-- checked_value=--quote--yes--quote--__#__" prtbl_item_item_content="Option 3" prtbl_item_feature="no" ][pb_pricingtable_item_item item_prtbl_id="UfhJBeOX" prtbl_item_item_content="20" item_item_desc="20" ][/pb_pricingtable_item_item][pb_pricingtable_item_item item_prtbl_id="kbQlRgPJ" prtbl_item_item_content="2 TB" item_item_desc="2 TB" ][/pb_pricingtable_item_item][/pb_pricingtable_item]' ),
					),
					'overwrite_shortcode_data' => false,
				),
			),
			'styling' => array(
				array(
					'type' => 'preview',
				),
				array(
					'name'            => JText::_( 'Elements' ),
					'id'              => 'prtbl_elements',
					'type'            => 'checkbox',
					'class'           => 'jsn-column-item checkbox',
					'container_class' => 'jsn-columns-container jsn-columns-count-two',
					'std'             => 'title__#__button__#__attributes',
					'options'         => array(
						'title'       => JText::_( 'Title' ),
						'description' => JText::_( 'Description' ),
						'image'       => JText::_( 'Image' ),
						'attributes'  => JText::_( 'Attributes' ),
						'price'       => JText::_( 'Price' ),
						'button'      => JText::_( 'Button' )
					),
					'tooltip'         => JText::_( 'Elements' )
				),
			)
		);
	}

	/**
	 * DEFINE shortcode content
	 *
	 * @param type $atts
	 * @param type $content
	 *
	 * @return string
	 */
	public function element_shortcode( $atts = null, $content = null ) {
		$document = JFactory::getDocument();
        JSNPagebuilderHelpersFunctions::loadFancyboxJS();
		$document->addScript( JSNPB_FRAMEWORK_ASSETS . '/3rd-party/jquery-tipsy/jquery.tipsy.js', 'text/javascript' );
		$document->addStyleSheet( JSNPB_FRAMEWORK_ASSETS . '/3rd-party/jquery-tipsy/tipsy.css', 'text/css' );
		$document->addStyleSheet( JSNPB_ELEMENT_URL.'/pricingtable/assets/css/pricingtable.css', 'text/css' );
		$document->addStyleSheet( JSNPB_ELEMENT_URL.'/pricingtable/assets/css/pricingtable-responsive.css', 'text/css' );
		$document->addScript( JSNPB_ELEMENT_URL.'/pricingtable/assets/js/pricingtable.js', 'text/javascript' );
		
		$html_element = '';
		$arr_params   = ( JSNPagebuilderHelpersShortcode::shortcodeAtts( $this->config['params'], $atts ) );
		extract( $arr_params );
		$arr_elements = explode( '__#__', $prtbl_elements );
		if ( ! $prtbl_elements OR $prtbl_elements == ' ' ) {
			return $html_element;
		}

		/* process label right table */
		$prtbl_common_label_json = str_replace( '--open_square--', '[', $prtbl_common_label_json );
		$prtbl_common_label_json = str_replace( '--close_square--', ']', $prtbl_common_label_json );
		$prtbl_common_label_json = str_replace( '--quote--', '"', $prtbl_common_label_json );
		$arr_labels              = explode( '__#__', $prtbl_common_label_json );
		$count_label             = 0;
        $prtbl_meta ='';
        $prtbl_title = '';
        if ( $prtbl_common_label_json ) {
            $prtbl_title .= '<div class="pb-prtbl-title">';
            if ( in_array( 'image', $arr_elements ) ) {
                $prtbl_title .= '<div class="pb-prtbl-image">&nbsp;</div>';
            }
            $prtbl_title .= '<h3>&nbsp;</h3></div>';
            if(in_array('price', $arr_elements) || in_array('description', $arr_elements)){
                $prtbl_meta .= '<div class="pb-prtbl-meta">';
                if(in_array('price', $arr_elements)){
                    $prtbl_meta .='<div class="pb-prtbl-price">&nbsp;</div>';
                }
                if(in_array('description', $arr_elements)){
                    $prtbl_meta .='<p class="pb-prtbl-desc">&nbsp;</p>';
                }
                $prtbl_meta .= '</div>';
            }
            $left_label = '<div class="pb-prtbl-header">' .$prtbl_title . $prtbl_meta . '</div>';

            $left_label .= '<ul class="pb-prtbl-features">';
            foreach ( $arr_labels as $i => $shortcode_label ) {
                if ( $shortcode_label ) {
                    $left_label .= JSNPagebuilderHelpersBuilder::generateShortCode($shortcode_label, false, 'frontend', true);
                    $count_label++;
                }
            }

            $left_label .= '</ul>';
            if ( in_array( 'button', $arr_elements ) ) {
                $left_label .= '<div class="pb-prtbl-footer"></div>';
            }
            /* process attributes pricing table */
            if ( in_array( 'attributes', $arr_elements ) ) {
                $html_element .= '<div class="pb-prtbl-cols first">' . $left_label . '</div>';
            }
        }

		/* process block pricing table items */
		$pattern      = '\\[(\\[?)(pb_pricingtable_item)(?![\\w-])([^\\]\\/]*(?:\\/(?!\\])[^\\]\\/]*)*?)(?:(\\/)\\]|\\](?:([^\\[]*+(?:\\[(?!\\/\\2\\])[^\\[]*+)*+)\\[\\/\\2\\])?)(\\]?)';
		preg_match_all( "/$pattern/s", $content, $matches );
		$attributes   = '';
		$column_count = count( $matches[0] ) + 1;
		if ( count( $matches[0] ) ) {
			foreach ( $matches[0] as $i => $shortcode_item ) {
				$_attributes = JSNPagebuilderHelpersBuilder::generateShortCode($shortcode_item, false, 'frontend', true);
				/* process title pricing table */
				if ( in_array( 'title', $arr_elements ) ) {
					$_attributes = str_replace( '[prtbl_item_title]', '', $_attributes );
					$_attributes = str_replace( '[/prtbl_item_title]', '', $_attributes );
				} else {
					$pattern     = '\\[(\\[?)(prtbl_item_title)(?![\\w-])([^\\]\\/]*(?:\\/(?!\\])[^\\]\\/]*)*?)(?:(\\/)\\]|\\](?:([^\\[]*+(?:\\[(?!\\/\\2\\])[^\\[]*+)*+)\\[\\/\\2\\])?)(\\]?)';
					$_attributes = preg_replace( "/$pattern/s", '', $_attributes );
				}
				/* process description pricing table */
				if ( in_array( 'description', $arr_elements ) ) {
					$_attributes = str_replace( '[prtbl_item_desc]', '', $_attributes );
					$_attributes = str_replace( '[/prtbl_item_desc]', '', $_attributes );
				} else {
					$pattern     = '\\[(\\[?)(prtbl_item_desc)(?![\\w-])([^\\]\\/]*(?:\\/(?!\\])[^\\]\\/]*)*?)(?:(\\/)\\]|\\](?:([^\\[]*+(?:\\[(?!\\/\\2\\])[^\\[]*+)*+)\\[\\/\\2\\])?)(\\]?)';
					$_attributes = preg_replace( "/$pattern/s", '', $_attributes );
				}
				/* process image pricing table */
				if ( in_array( 'image', $arr_elements ) ) {
					$_attributes = str_replace( '[prtbl_item_image]', '', $_attributes );
					$_attributes = str_replace( '[/prtbl_item_image]', '', $_attributes );
				} else {
					$pattern     = '\\[(\\[?)(prtbl_item_image)(?![\\w-])([^\\]\\/]*(?:\\/(?!\\])[^\\]\\/]*)*?)(?:(\\/)\\]|\\](?:([^\\[]*+(?:\\[(?!\\/\\2\\])[^\\[]*+)*+)\\[\\/\\2\\])?)(\\]?)';
					$_attributes = preg_replace( "/$pattern/s", '', $_attributes );
				}
				/* process button pricing table */
				if ( in_array( 'button', $arr_elements ) ) {
					$_attributes = str_replace( '[prtbl_item_button]', '', $_attributes );
					$_attributes = str_replace( '[/prtbl_item_button]', '', $_attributes );
				} else {
					$pattern = '\\[(\\[?)(prtbl_item_button)(?![\\w-])([^\\]\\/]*(?:\\/(?!\\])[^\\]\\/]*)*?)(?:(\\/)\\]|\\](?:([^\\[]*+(?:\\[(?!\\/\\2\\])[^\\[]*+)*+)\\[\\/\\2\\])?)(\\]?)';
					$_attributes = preg_replace( "/$pattern/s", '', $_attributes );
				}
				/* process button pricing table */
				if ( in_array( 'price', $arr_elements ) ) {
					$_attributes = str_replace( '[prtbl_item_price]', '', $_attributes );
					$_attributes = str_replace( '[/prtbl_item_price]', '', $_attributes );
				} else {
					$pattern     = '\\[(\\[?)(prtbl_item_price)(?![\\w-])([^\\]\\/]*(?:\\/(?!\\])[^\\]\\/]*)*?)(?:(\\/)\\]|\\](?:([^\\[]*+(?:\\[(?!\\/\\2\\])[^\\[]*+)*+)\\[\\/\\2\\])?)(\\]?)';
					$_attributes = preg_replace( "/$pattern/s", '', $_attributes );
				}

				/* process attributes pricing table */
				if ( in_array( 'attributes', $arr_elements ) ) {
					$_attributes = str_replace( '[prtbl_item_attributes]', '', $_attributes );
					$_attributes = str_replace( '[/prtbl_item_attributes]', '', $_attributes );
				} else {
					$pattern     = '\\[(\\[?)(prtbl_item_attributes)(?![\\w-])([^\\]\\/]*(?:\\/(?!\\])[^\\]\\/]*)*?)(?:(\\/)\\]|\\](?:([^\\[]*+(?:\\[(?!\\/\\2\\])[^\\[]*+)*+)\\[\\/\\2\\])?)(\\]?)';
					$_attributes = preg_replace( "/$pattern/s", '', $_attributes );
				}
				if ( strpos( $_attributes, '__no_item__' ) !== false ) {
					$html_cell = '<ul class="pb-prtbl-features">';
					/* process sub item attributes */
					if ( strpos( $shortcode_item, 'prtbl_item_attributes="' ) !== false ) {
						$prtbl_item_attributes = substr( $shortcode_item, strpos( $shortcode_item, 'prtbl_item_attributes="' ) + 23 );
						$prtbl_item_attributes = substr( $prtbl_item_attributes, 0, strpos( $prtbl_item_attributes, '"' ) );
						$prtbl_item_attributes = str_replace( '--open_square--', '[', $prtbl_item_attributes );
						$prtbl_item_attributes = str_replace( '--close_square--', ']', $prtbl_item_attributes );
						$prtbl_item_attributes = str_replace( '--quote--', '"', $prtbl_item_attributes );
						$arr_attrs             = explode( '__#__', $prtbl_item_attributes );
						if ( $prtbl_item_attributes ) {
							$count = 0;
							foreach ( $arr_attrs as $i => $shortcode_attr ) {
								if ( $shortcode_attr ) {
									if ( strpos( $shortcode_attr, 'pb_prtbl_checked' ) !== false ) {
										preg_match_all( '/checked_value="([^"]*)"/i', $shortcode_attr, $checked );
										if ( $checked[1][0] == 'no' ) {
											$html_cell .= '<li></li>';
											$count++;
										} else {
											$html_cell .= '<li><i class="icon-checkmark"></i></li>';
											$count++;
										}
									} else {
										$html_cell .= JSNPagebuilderHelpersBuilder::generateShortCode($shortcode_attr, false, 'frontend', true);
										$count++;
									}
								}
							}
							if ( $count_label - $count > 0 ) {
								for ( $i = 0; $i < ($count_label - $count); $i++ ) {
									$html_cell .= '<li></li>';
								}
							}
						} else {
							foreach ( $arr_labels as $i => $shortcode ) {
								if ( $shortcode ) {
									$html_cell .= '<li></li>';
								}
							}
						}
					} else {
						foreach ( $arr_labels as $i => $shortcode ) {
							if ( $shortcode ) {
								$html_cell .= '<li></li>';
							}
						}
					}
					$_attributes = str_replace( '__no_item__', $html_cell . '</ul>', $_attributes );
				}

				$attributes .= $_attributes;
			}
		}
		$html_element .= $attributes;


		return $this->element_wrapper( $html_element, $arr_params, "table-$column_count-col" );
	}

	/**
	 * Get params & structure of shortcode
	 * OVERWRIGE parent function
	 * 
	 * @return type
	 */
	public function shortcode_data() {
		parent::shortcode_data();
	}

}
