<?php
/**
 * @version    $Id$
 * @package    JSN_PageBuilder
 * @author     JoomlaShine Team <support@joomlashine.com>
 * @copyright  Copyright (C) 2012 JoomlaShine.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.joomlashine.com
 * Technical Support:  Feedback - http://www.joomlashine.com/contact-us/get-support.html
 */

// No direct access to this file.
defined('_JEXEC') || die('Restricted access');

/**
 * Pricing Table Sub Item shortcode element
 *
 * @package  JSN_PageBuilder
 * @since    1.0.0
 */
class JSNPBShortcodePricingtableItemItem extends IG_Pb_Child {
	
	/**
	 * Constructor
	 *
	 * @return type
	 */
	public function __construct() {
		parent::__construct();
	}

    public function backend_element_assets() {
        JSNPBShortcodePricingTable::addPRCellTemplate();
        $document = JFactory::getDocument();
        $document->addScript( JSNPB_ELEMENT_URL.'/pricingtable/assets/js/item_pricingtablelabel.js', 'text/javascript' );
    }
	
	/**
	 * DEFINE configuration information of shortcode
	 * 
	 * @return type
	 */
	public function element_config() {
		$this->config['shortcode'] = 'pb_pricingtable_item_item';
		$this->config['exception'] = array(
			'action_btn' => 'edit',
		);
	}
	
	/**
	 * DEFINE setting options of shortcode
	 * 
	 * @return type
	 */
	public function element_items() {
		$this->items = array(
			'NoTab' => array(
				array(
					'id'   => 'item_prtbl_id',
					'type' => 'hidden',
					'std'  => '',
				),
				array(
					'name'    => JText::_( 'Content' ),
					'id'      => 'prtbl_item_item_content',
					'type'    => 'text_field',
					'role'    => 'title',
					'class'   => 'jsn-input-xxlarge-fluid pb-pb-limit-length',
					'std'     => '',
					'tooltip' => JText::_( 'Content' ),
				),
				array(
					'name'          => JText::_( 'Description' ),
					'id'            => 'item_item_desc',
					'type'          => 'text_area',
					'class'         => 'jsn-input-xxlarge-fluid',
					'std'           => '',
					'tooltip'       => JText::_( 'Description' ),
					'exclude_quote' => '1',
				),
			)
		);
	}
	
	/**
	 * DEFINE shortcode content
	 *
	 * @param type $atts
	 * @param type $content
	 *
	 * @return string
	 */
	public function element_shortcode( $atts = null, $content = null ) {
		extract( JSNPagebuilderHelpersShortcode::shortcodeAtts( $this->config['params'], $atts ) );
		$item_item_desc          = ( $item_item_desc ) ? $item_item_desc : '';
		$prtbl_item_item_content = ( $prtbl_item_item_content ) ? $prtbl_item_item_content : '';
		$html_element            = '<li>
				<label data-title="' . $item_item_desc . '" original-title="' . $item_item_desc . '" class="pb-prtbl-tipsy">' . $prtbl_item_item_content . '</label>
			</li>';
		return $html_element;
	}
	
}
