<?php
/**
 * @version    $Id$
 * @package    JSN_PageBuilder
 * @author     JoomlaShine Team <support@joomlashine.com>
 * @copyright  Copyright (C) 2012 JoomlaShine.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.joomlashine.com
 * Technical Support:  Feedback - http://www.joomlashine.com/contact-us/get-support.html
 */

// No direct access to this file.
defined('_JEXEC') || die('Restricted access');

/**
 * Pricing Table Label Item shortcode element
 *
 * @package  JSN_PageBuilder
 * @since    1.0.0
 */
class JSNPBShortcodePricingtablelabelItem extends IG_Pb_Child {

	/**
	 * Constructor
	 * 
	 * @return type
	 */
	public function __construct() {
		parent::__construct();
	}

    public function backend_element_assets() {
        JSNPBShortcodePricingTable::addPRCellTemplate();
        $document = JFactory::getDocument();
        $document->addScript( JSNPB_ELEMENT_URL.'/pricingtable/assets/js/item_pricingtablelabel.js', 'text/javascript' );
    }

	/**
	 * DEFINE configuration information of shortcode
	 * 
	 * @return type
	 */
	public function element_config() {
		$this->config['shortcode'] = 'pb_pricingtablelabel_item';
		$this->config['exception'] = array(
			'item_text'                 => JText::_( 'Attribute' ),
			'data-modal-title'          => JText::_( 'Attribute' ),
			'exclude_gen_shortcode'     => '1'
		);
	}

	/**
	 * DEFINE setting options of shortcode
	 * 
	 * @return type
	 */
	public function element_items() {
		$this->items = array(
			'NoTab' => array(
				array(
					'id'              => 'item_prtbl_unique_id',
					'type'            => 'text_field',
					'std'             => '__default_id__',
					'input-type'      => 'hidden',
					'container_class' => 'hidden',
				),
				array(
					'name'    => JText::_( 'Title' ),
					'id'      => 'prtbl_item_item_title',
					'type'    => 'text_field',
					'class'   => 'jsn-input-xxlarge-fluid',
					'role'    => 'title',
					'std'     => JText::_( 'Attribute PB_INDEX_TRICK' ),
					'tooltip' => JText::_( 'Title' )
				),
				array(
					'name'          => JText::_( 'Description' ),
					'id'            => 'item_item_desc_area',
					'type'          => 'text_area',
					'class'         => 'jsn-input-xxlarge-fluid',
					'std'           => '',
					'tooltip'       => JText::_( 'Description' ),
					'exclude_quote' => '1',
				),
				array(
					'name'    => JText::_( 'Type' ),
					'id'      => 'prtbl_item_item_type',
					'type'    => 'select',
					'std'     => '',
					'options' => JSNPagebuilderHelpersType::getSubItemPricingType(),
					'tooltip' => JText::_( 'Type' )
				),
			)
		);
	}

	/**
	 * DEFINE shortcode content
	 *
	 * @param type $atts
	 * @param type $content
	 * 
	 * @return string
	 */
	public function element_shortcode( $atts = null, $content = null ) {
		extract( JSNPagebuilderHelpersShortcode::shortcodeAtts( $this->config['params'], $atts ) );
		$html_element = '<li>
			<label data-title="' . $item_item_desc_area . '" original-title="' . $item_item_desc_area . '" class="pb-prtbl-tipsy">' . $prtbl_item_item_title . '</label>
		</li>';
		return $html_element;
	}

	/**
	 * DEFINE html structure of shortcode in Page Builder area
	 *
	 * @param type $content
	 * @param type $shortcode_data: string stores params ( which is modified default value ) of shortcode
	 * @param type $el_title: Element Title used to identifying elements in Pagebuilder
	 * Ex:  param-tag=h6&param-text=Your+heading&param-font=custom&param-font-family=arial
	 * @return type
	 */
	public function element_in_pgbldr( $content = '', $shortcode_data = '', $el_title = '' ) {
		$html = parent::element_in_pgbldr( $content, $shortcode_data, $el_title );
		return $html;
	}

}
