<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

require_once JPATH_COMPONENT.'/controller.php';

/**
 * Documents list controller class.
 */
class DigitalMarketXControllerCart extends DigitalMarketXController
{
	public function toogleItemInCart()
	{
		$itemId = JRequest::getInt('id');
		$model = $this->getModel('cart');
		if($model->isInCart($itemId))
		{
			$model->removeFromCart($itemId);
		}
		else
		{
			$model->addToCart($itemId);
		}
		$isInCart = $model->isInCart($itemId) ? 1 : 0;
		$result = array();
		$result[0] = $itemId;
		$result[1] = $isInCart;
		$r = JRequest::getInt('r', 0);
		if($r)
		{
			$app = JFactory::getApplication();
			$return = JRequest::getVar('return', '');
			if($return)
				$return = base64_decode($return);
			else
				$return = JRoute::_("index.php?option=com_digitalmarketx&view=details&id=" .
						(int)$itemId);
			$app->redirect($return, 
				$isInCart ? JText::_("COM_DIGITALMARKERX_ADDEDTOCART") : 
					JText::_("COM_DIGITALMARKERX_REMOVEDFROMCART"));
			exit;
		}
		else
		{
			echo json_encode($result);
			exit;
		}
	}
	
	public function getItemsInCart()
	{
		$model = $this->getModel('cart');
		$items = $model->getCartItems();
		echo json_encode($items);
		exit;
	}
	
	public function removeItemFromCart()
	{
		$itemId = JRequest::getInt('id');
		$model = $this->getModel('cart');
		$model->removeFromCart($itemId);
		$app = JFactory::getApplication();
		$app->redirect($this->route("index.php?option=com_digitalmarketx&view=cart"));
	}
	
	public function checkout()
	{
		$cart_id = JRequest::getInt('id');
		$model = $this->getModel('cart');
		$app = JFactory::getApplication();
		if($model->chechOut($cart_id))
		{
			$app->redirect($this->route("index.php?option=com_digitalmarketx&view=paycart&id=" . (int)$cart_id));
		}
		else
		{
			$app->redirect($this->route("index.php?option=com_digitalmarketx&view=cart"));
		}
	}
}