<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

require_once JPATH_COMPONENT.'/controller.php';

/**
 * Documents list controller class.
 */
class DigitalMarketXControllerComment extends DigitalMarketXController
{
	public function submit()
	{
		$model = $this->getModel('comment');
		$docId = JRequest::getInt('document_id');
		if($model->canSubmitComment($model->getDocumentCategory($docId), $docId))
		{
			$title = JRequest::getVar('title');
			$text = JRequest::getVar('comment_text');
			$rating = JRequest::getInt('comment_rating', 0);
			$thumbs = JRequest::getInt('comment_thumbs', 0);
			if($thumbs == 0)
			{
				$thumbs = $rating;
			}
			if($rating == 0)
			{
				if($thumbs > 0)
					$rating = $thumbs;
				else
					$rating = 1;
			}
			$app = JFactory::getApplication();
			$url = $this->route("index.php?option=com_digitalmarketx&view=details&id=" . (int)$docId);
			if($model->submitComment($docId, $title, $text, $rating, $thumbs, $state))
			{
				if($state == 1)
					$app->redirect($url, JText::_("COM_DIGITALMARKETX_COMMENT_SUBMITTED_AND_PUBLISHED"));
				else
					$app->redirect($url, JText::_("COM_DIGITALMARKETX_COMMENT_SUBMITTED"));
			}
			else
			{
				$app->redirect($url, JText::_("COM_DIGITALMARKETX_COMMENT_NOT_SUBMITTED", "error"));
			}
			exit;
		}
		else
		{
			echo JText::_("COM_DIGITALMARKETX_COMMENT_NOT_ALLOWED");
		}
		
	}
	
}