<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

require_once JPATH_COMPONENT.'/controller.php';

/**
 * Documents list controller class.
 */
class DigitalMarketXControllerCommentReply extends DigitalMarketXController
{
	public function submit()
	{
		$model = $this->getModel('commentreply');
		$vote_id = JRequest::getInt('vote_id');
		$document_id = $model->getDocumentForVote($vote_id);
		if($model->canSubmitComment($model->getDocumentCategory($document_id), $document_id))
		{
			$text = JRequest::getVar('comment_text');
			$app = JFactory::getApplication();
			$url = $this->route("index.php?option=com_digitalmarketx&view=details&id=" . (int)$document_id);
			if($model->submitCommentReply($vote_id, $text, $state))
			{
				if($state == 1)
					$app->redirect($url, JText::_("COM_DIGITALMARKETX_REPLY_SUBMITTED_AND_PUBLISHED"));
				else
					$app->redirect($url, JText::_("COM_DIGITALMARKETX_REPLY_SUBMITTED"));
			}
			else
			{
				$app->redirect($url, JText::_("COM_DIGITALMARKETX_REPLY_NOT_SUBMITTED", "error"));
			}
			exit;
		}
		else
		{
			echo JText::_("COM_DIGITALMARKETX_COMMENT_NOT_ALLOWED");
		}
		
	}
	
}