<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

require_once JPATH_COMPONENT.'/controller.php';

/**
 * Documents list controller class.
 */
class DigitalMarketXControllerDocument extends DigitalMarketXController
{
	public function download()
	{
		$model = $this->getModel('document');
		$docId = JRequest::getInt('id');
		if(!$model->canDownload($docId))
		{
			$user = JFactory::getUser();
			if(!$user->id)
			{
				$app = JFactory::getApplication();
				$return = "index.php?option=com_digitalmarketx&view=details&id=" . (int)$docId;
				$url = "index.php?option=com_users&view=login&return=" . base64_encode($return);
				$Itemid = JRequest::getInt("Itemid");
				if($Itemid)
					$url .= "&Itemid=" . $Itemid;
				$app->redirect($url);
				exit;
			}
			else
			{
				echo JText::_("COM_DIGITALMARKETX_YOUR_USER_GROUP_IS_NOT_ALLOWED_TO_DOWNLOAD");
			}
		}
		else if(($downloadId = $model->idDownloadable($docId)) !== false)
		{
			$model->increaseDownloadCount($downloadId, $docId);
			$filename = JPATH_ROOT . '/' . $model->getFileName(JRequest::getInt('id'));
			ob_end_clean();
			header("Cache-Control: public, must-revalidate");
			header('Cache-Control: pre-check=0, post-check=0, max-age=0');
			header("Pragma: no-cache");
			header("Expires: 0"); 
			header("Content-Description: File Transfer");
			header("Expires: Sat, 30 Dec 1990 07:07:07 GMT");
			header("Content-Type: application/octet-stream ");
			header("Content-Length: ". filesize($filename));
			header("Accept-Ranges: bytes"); 
			header('Content-Disposition: attachment; filename="' . $this->_getFileNameWithoutPath($filename) . '"');
			header("Content-Transfer-Encoding: binary\n");
			@readfile($filename);
			exit;
		}
		else
		{
			echo JText::_("COM_DIGITALMARKETX_DOWNLOAD_EXPIRED");
		}
		
	}
	
	public function downloadDemo()
	{
		$model = $this->getModel('document');
		$docId = JRequest::getInt('id');
		$filename = JPATH_ROOT . '/' . $model->getDemoFileName($docId);
		ob_end_clean();
		header("Cache-Control: public, must-revalidate");
		header('Cache-Control: pre-check=0, post-check=0, max-age=0');
		header("Pragma: no-cache");
		header("Expires: 0"); 
		header("Content-Description: File Transfer");
		header("Expires: Sat, 30 Dec 1990 07:07:07 GMT");
		header("Content-Type: application/octet-stream ");
		header("Content-Length: ". filesize($filename));
		header("Accept-Ranges: bytes"); 
		header('Content-Disposition: attachment; filename="' . $this->_getFileNameWithoutPath($filename) . '"');
		header("Content-Transfer-Encoding: binary\n");
		@readfile($filename);
		exit;
	}
	
	public function upload()
	{
		$title = JRequest::getVar('title');
		$metatags = JRequest::getVar('keywords');
		$category = JRequest::getInt('category', 0);
		$price = JRequest::getFloat('price');
		$currency = JRequest::getVar('currency');
		$users = JRequest::getVar('destusers_userids', 'no');
		$user = JFactory::getUser();
		if($user->authorise('digitalmarketx.htmledit', 'com_digitalmarketx'))
			$description = JRequest::getVar( 'description', '', 'post','string', JREQUEST_ALLOWRAW );
		else
			$description = JRequest::getVar('description');
		if($user->authorise('digitalmarketx.htmledit', 'com_digitalmarketx'))
			$demo_text = JRequest::getVar( 'demo_text', '', 'post','string', JREQUEST_ALLOWRAW );
		else
			$demo_text = JRequest::getVar('demo_text');
		$published = JRequest::getInt('published', 0);
		$app = JFactory::getApplication();
		$model = $this->getModel('document');
		if($model)
		{
			$documentId = $model->upload($title, $metatags, $category, $price, $currency, $description, $demo_text,
				$_FILES['file'], $_FILES['thumbnail'], $_FILES['demo_file'], $published, $users);
			if($documentId === false)
			{
				foreach($model->getErrors() as $error)
				{
					$app->enqueueMessage($error, "error");
				}
				$app->redirect($this->route("index.php?option=com_digitalmarketx&view=upload"));
				exit;
			}
			else
			{
				require_once(JPATH_ADMINISTRATOR . DS . "components" . DS . "com_digitalmarketx" . DS . "helpers" . DS .  "digitalmarketx.php");
				DigitalMarketXHelper::notifyUpload($documentId, $title, $users);
			}
		}
		foreach($model->getErrors() as $error)
		{
			$app->enqueueMessage($error, "error");
		}
		$current_state = DigitalMarketXHelper::getDocumentState($documentId);
		if($current_state)
		{
			if($users)
				$msg = JText::_("COM_DIGITALMARKETX_FILE_UPLOADED_AND_PUBLISHED_FOR_USERS");
			else
				$msg = JText::_("COM_DIGITALMARKETX_FILE_UPLOADED_AND_PUBLISHED");
		}
		else
			$msg = JText::_("COM_DIGITALMARKETX_FILE_UPLOADED_NOT_PUBLISHED");
		$app->redirect($this->route("index.php?option=com_digitalmarketx&view=category&id=" . (int)$category), 
			$msg);
		exit;
	}
	
	public function save()
	{
		$documentId = JRequest::getInt('docid');
		$title = JRequest::getVar('title');
		$metatags = JRequest::getVar('keywords');
		$category = JRequest::getInt('category', 0);
		$price = JRequest::getFloat('price');
		$currency = JRequest::getVar('currency');
		$users = JRequest::getVar('destusers_userids', 'no');
		$user = JFactory::getUser();
		if($user->authorise('digitalmarketx.htmledit', 'com_digitalmarketx'))
			$description = JRequest::getVar( 'description', '', 'post','string', JREQUEST_ALLOWRAW );
		else
			$description = JRequest::getVar('description');
		if($user->authorise('digitalmarketx.htmledit', 'com_digitalmarketx'))
			$demo_text = JRequest::getVar( 'demo_text', '', 'post','string', JREQUEST_ALLOWRAW );
		else
			$demo_text = JRequest::getVar('demo_text');
		$published = JRequest::getInt('published', 0);
		$app = JFactory::getApplication();
		$model = $this->getModel('document');
		if($model)
		{
			require_once(JPATH_ADMINISTRATOR . DS . "components" . DS . "com_digitalmarketx" . DS . "helpers" . DS .  "digitalmarketx.php");
			$previous_state = DigitalMarketXHelper::getDocumentState($documentId);
			if(!$model->upload($title, $metatags, $category, $price, $currency, $description, $demo_text,
				$_FILES['file'], $_FILES['thumbnail'], $_FILES['demo_file'], $published, $users, $documentId))
			{
				foreach($model->getErrors() as $error)
				{
					$app->enqueueMessage($error, "error");
				}
				$app->redirect($this->route("index.php?option=com_digitalmarketx&view=edit&id=" . (int)$documentId));
				exit;
			}
			$current_state = DigitalMarketXHelper::getDocumentState($documentId);
			if($current_state != $previous_state)
			{
				DigitalMarketXHelper::notifyStateChange($documentId, $title, $current_state, $users);
			}
		}
		foreach($model->getErrors() as $error)
		{
			$app->enqueueMessage($error, "error");
		}
		$app->redirect($this->route("index.php?option=com_digitalmarketx&view=category&id=" . (int)$category), 
			JText::_("COM_DIGITALMARKET_FILE_SAVED"));
		exit;
	}
	
	
	
	private function _isAllowedExtension($filename, $allowed = null)
	{
		$ext = "";
		$dotpos = strrpos($filename, ".");
		if($dotpos !== false)
		{
			$ext = substr($filename, $dotpos + 1);
			$ext = trim(strtolower($ext));
		}
		$params = JComponentHelper::getParams('com_digitalmarketx');
		if($allowed == null)
			$allowed = $params->get("alloweduploadfiletypes", "pdf ppt gz tar tgz zip bmp gif jpeg jpg jpe png tiff tif txt mpeg mpg mpe qt mov avi flv doc");
		$allowed_ext = explode(" ", $allowed);
		foreach($allowed_ext as $e)
		{
			if($ext == trim(strtolower($e)))
				return true;
		}
		return false;
	}
	
	private function _getFileNameWithoutPath($filePath)
	{
		$pos = strrpos($filePath, "/");
		if($pos !== false)
		{
			return substr($filePath, $pos + 1);
		}
		else
		{
			return $filePath;
		}
	}
	
}