<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

require_once JPATH_COMPONENT.'/controller.php';

/**
 * Documents list controller class.
 */
class DigitalMarketXControllerPaypal extends DigitalMarketXController
{
	public function simulatepay()
	{
		$amount = JRequest::getFloat('amount');
		$fee = $amount / 10.0;
		$notify_url = JRequest::getVar('notify_url');
		$req = "receiver_email=" . urlencode(JRequest::getVar('business'));
		$req .= "&business=" . urlencode(JRequest::getVar('business'));
		$req .= "&payer_email=" . urlencode("paypalsimulator@paypal.com");
		$req .= "&txn_id=" . urlencode(rand());
		$req .= "&test_ipn=1";
		$req .= "&custom=" . urlencode(JRequest::getVar('custom'));
		$req .= "&item_number=" . urlencode(JRequest::getVar('item_number'));
		$req .= "&mc_gross=" . urlencode($amount);
		$req .= "&mc_currency=" . urlencode(JRequest::getVar('currency_code'));
		$req .= "&payment_status=COMPLETED";
		$req .= "&mc_fee=" . urlencode($fee);
		$req .= "&tax=0.00";
		
		$ch = curl_init();
		curl_setopt($ch,CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch,CURLOPT_URL, $notify_url);
		curl_setopt($ch,CURLOPT_POST, 1);
		curl_setopt($ch,CURLOPT_POSTFIELDS,$req);
		curl_exec($ch);
		curl_close($ch);
		$mainframe = JFactory::getApplication();
		$mainframe->redirect("index.php?option=com_digitalmarketx&view=paypalsim&return=" . 
			urlencode(JRequest::getVar('return')));
	}
	
	public function confirmpay()
	{
		$model = $this->getModel('pay');
		if($model)
		{
			$model->handleResponse();
		}
	}
	
	public function confirmdebtpay()
	{
		$model = $this->getModel('paydebt');
		if($model)
		{
			$model->handleResponse();
		}
	}
	
	public function confirmpaycart()
	{
		$model = $this->getModel('paycart');
		if($model)
		{
			$model->handleResponse();
		}
	}
	
	function debug($text)
	{
		/*$db = JFactory::getDBO();
		$text = $db->escape($text);
		$query = "INSERT INTO debug(text, time) VALUES('$text', NOW())";
		$db->setQuery( $query );
		$db->query();*/
	}
	
	public function sendLink()
	{
		$access = JRequest::getVar('access');
		$m = JRequest::getVar('m', '');
		$regexp = "/^\s*\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*\s*$/";
		if(preg_match($regexp, $m))
		{
			list($downloadId, $hash, $rand) = explode(":", $access);
			$db = JFactory::getDBO();
			$downloadId = (int)$downloadId;
			$rand = $db->escape($rand);
			$query = "SELECT * FROM #__digitalmarketx_download_links 
				WHERE download_id = $downloadId AND random_value = '$rand' AND paid <> 0 AND
				(expiration_date > NOW() OR expiration_date IS NULL) AND 
				(link_max_downloads = 0 OR download_hits < link_max_downloads)";
			$db->setQuery( $query );
			$downloadLink = $db->loadObject();
			if($downloadLink)
			{
				if($hash == sha1($downloadLink->secret_word . $downloadLink->random_value))
				{
					$mail = JFactory::getMailer();
					$mail->setSubject($downloadLink->subject);
					$mail->setBody($downloadLink->emailbody);
					$mail->ClearAddresses();
					$mail->addRecipient($m);
					$mail->IsHTML(true);
					$joomla_config = new JConfig();
					$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
					$mail->send();
					echo "<<1>>";
					exit();
				}
			}
		}
		echo "<<0>>";
		exit();
	}
}