<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

require_once JPATH_COMPONENT.'/controller.php';

/**
 * Documents list controller class.
 */
class DigitalMarketXControllerProfile extends DigitalMarketXController
{
	public function save()
	{
		$model = $this->getModel('profile');
		if($model)
		{
			$app = JFactory::getApplication();
			$userid = (int)JFactory::getUser()->id;
			$paypal = JRequest::getVar('paypalaccount');
			if($model->saveProfile($userid, $paypal))
				$app->redirect($this->route("index.php?option=com_digitalmarketx&view=profile"));
			else
				$app->redirect($this->route("index.php?option=com_digitalmarketx&view=profile"), 
					$model->getError(), "error");
			exit;
		}
	}
	
	public function claim()
	{
		$model = $this->getModel('profile');
		if($model)
		{
			$app = JFactory::getApplication();
			$amount = JRequest::getFloat('money');
			$moneyid = JRequest::getInt('moneyid');
			$currency = $model->getCurrency($moneyid);
			if($model->claimMoney($moneyid, $amount))
				$app->redirect($this->route("index.php?option=com_digitalmarketx&view=profile"), JText::sprintf("COM_DIGITALMARKETX_MONEY_CLAIMED", $amount, $currency));
			else
				$app->redirect($this->route("index.php?option=com_digitalmarketx&view=profile"), 
					$model->getError(), "error");
			exit;
		}
	}
}