<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

require_once JPATH_COMPONENT.'/controller.php';

/**
 * Documents list controller class.
 */
class DigitalMarketXControllerReport extends DigitalMarketXController
{
	public function submit()
	{
		$model = $this->getModel('report');
		$docId = JRequest::getInt('document_id');
		$title = JRequest::getVar('title');
		$text = JRequest::getVar('comment_text');
		$app = JFactory::getApplication();
		$url = $this->route("index.php?option=com_digitalmarketx&view=details&id=" . (int)$docId);
		$user_id = JFactory::getUser()->id;
		if($user_id && $model->submitReport($docId, $title, $text))
		{
			$app->redirect($url, JText::_("COM_DIGITALMARKETX_REPORT_SENT"));
		}
		else
		{
			$app->redirect($url, JText::_("COM_DIGITALMARKETX_REPORT_NOT_SENT", "error"));
		}
		exit;
		
	}
	
}