<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

defined('_JEXEC') or die;

abstract class DigitalMarketXHelper
{
	public static function getTimeDifference($date, $null_text = "")
	{
		if(method_exists($date, "diff"))
		{
			$now = new JDate();
			$diff = $now->diff($date);
			if($diff->invert)
			{
				$s1 = "COM_DIGITALMARKETX_TIME_AGO";
				$s2 = "COM_DIGITALMARKETX_TIME_AGO1";
			}
			else
			{
				$s1 = "COM_DIGITALMARKETX_TIME_LEFT";
				$s2 = "COM_DIGITALMARKETX_TIME_LEFT1";
			}
			if($diff->y > 2000)
			{
				if($null_text == "")
					$result = JText::_("COM_DIGITALMARKETX_NEVER");
				else
					$result = $null_text;
			}
			else if($diff->y > 0)
			{
				$unit1 = JText::_("COM_DIGITALMARKETX_YEARS");
				$unit2 = JText::_("COM_DIGITALMARKETX_MONTHS");
				if($diff->y == 1)
					$unit1 = JText::_("COM_DIGITALMARKETX_YEAR");
				if($diff->m == 1)
					$unit2 = JText::_("COM_DIGITALMARKETX_MONTH");
				if($diff->m > 0)
				{
					$result = JText::sprintf($s1, $diff->y, $unit1, $diff->m, $unit2);
				}
				else
					$result = JText::sprintf($s2, $diff->y, $unit1);
			}
			else if($diff->m > 0)
			{
				$unit1 = JText::_("COM_DIGITALMARKETX_MONTHS");
				$unit2 = JText::_("COM_DIGITALMARKETX_DAYS");
				if($diff->m == 1)
					$unit1 = JText::_("COM_DIGITALMARKETX_MONTH");
				if($diff->d == 1)
					$unit2 = JText::_("COM_DIGITALMARKETX_DAY");
				if($diff->d > 0)
					$result = JText::sprintf($s1, $diff->m, $unit1, $diff->d, $unit2);
				else
					$result = JText::sprintf($s2, $diff->m, $unit1);
			}
			else if($diff->d > 0)
			{
				$unit1 = JText::_("COM_DIGITALMARKETX_DAYS");
				$unit2 = JText::_("COM_DIGITALMARKETX_HOURS");
				if($diff->d == 1)
					$unit1 = JText::_("COM_DIGITALMARKETX_DAY");
				if($diff->h == 1)
					$unit2 = JText::_("COM_DIGITALMARKETX_HOUR");
				if($diff->h > 0)
					$result = JText::sprintf($s1, $diff->d, $unit1, $diff->h, $unit2);
				else
					$result = JText::sprintf($s2, $diff->d, $unit1);
			}
			else if($diff->h > 0)
			{
				$unit1 = JText::_("COM_DIGITALMARKETX_HOURS");
				$unit2 = JText::_("COM_DIGITALMARKETX_MINS");
				if($diff->h == 1)
					$unit1 = JText::_("COM_DIGITALMARKETX_HOUR");
				if($diff->i == 1)
					$unit2 = JText::_("COM_DIGITALMARKETX_MIN");
				if($diff->i > 0)
					$result = JText::sprintf($s1, $diff->h, $unit1, $diff->i, $unit2);
				else
					$result = JText::sprintf($s2, $diff->h, $unit1);
			}
			else
			{
				if($diff->i == 1)
					$result = JText::sprintf($s2, $diff->i, JText::_("COM_DIGITALMARKETX_MIN"));
				else
					$result = JText::sprintf($s2, $diff->i, JText::_("COM_DIGITALMARKETX_MINS"));
			}
			return $result;
		}
		else
		{
			$format = JText::_("COM_DIGITALMARKET_DATE_TIME_FORMAT");
			return $date->format($format);
		}
	}
	
	static public function renderStyle()
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, style FROM #__digitalmarketx_templates WHERE defaultTemplate = 1";
		$db->setQuery( $query );
		$defaultTemplate = $db->loadObject();
		DigitalMarketXHelper::includeDefaultStyle();
		if($defaultTemplate)
		{
			require_once "docrender.php";
			DocumentRenderer::renderStyle($defaultTemplate->style);
			return;
		}
	}
	
	static private function useAjax()
	{
		$user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? 
			$_SERVER['HTTP_USER_AGENT'] : '';
		return strpos($user_agent, 'iPhone') === false;
	}
	
	static public function renderDocumentDetails($document)
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, details_layout FROM #__digitalmarketx_templates WHERE defaultTemplate = 1";
		$db->setQuery( $query );
		$defaultTemplate = $db->loadObject();
		$useAjax = self::useAjax();
		if($defaultTemplate)
		{
			require_once "docrender.php";
			echo DocumentRenderer::renderDocumentTemplate($document, $defaultTemplate->details_layout, false, $useAjax);
			return;
		}
		require "docdetails.php";
	}
	
	static public function renderDocumentPreview($document)
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, category_layout FROM #__digitalmarketx_templates WHERE defaultTemplate = 1";
		$db->setQuery( $query );
		$defaultTemplate = $db->loadObject();
		$useAjax = self::useAjax();
		if($defaultTemplate)
		{
			require_once "docrender.php";
			echo DocumentRenderer::renderDocumentTemplate($document, $defaultTemplate->category_layout, true, $useAjax);
			return;
		}
		require "doclist.php";
	}
	
	static public function renderVote($vote)
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, vote_layout FROM #__digitalmarketx_templates WHERE defaultTemplate = 1";
		$db->setQuery( $query );
		$defaultTemplate = $db->loadObject();
		if($defaultTemplate)
		{
			require_once "docrender.php";
			echo DocumentRenderer::renderVoteTemplate($vote, $defaultTemplate->vote_layout);
			return;
		}
		require "vote.php";
	}
	
	static public function includeDefaultStyle()
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$style = $params->get('buttons_style', 2);
		VersionLayer::stylesheet('common.css', 'components/com_digitalmarketx/assets/');
		VersionLayer::stylesheet('category.css', 'components/com_digitalmarketx/assets/');
		if($style == 0)
			VersionLayer::stylesheet('green.css', 'components/com_digitalmarketx/assets/');
		else if($style == 1)
			VersionLayer::stylesheet('orange.css', 'components/com_digitalmarketx/assets/');
		else
			VersionLayer::stylesheet('trans.css', 'components/com_digitalmarketx/assets/');
	}
	
	static public function getParentCategories($category)
	{
		$db = JFactory::getDBO();
		$categories = array();
		while($category)
		{
			$query = "SELECT id, title, parent_id FROM #__categories WHERE id = " . (int)$category;
			$db->setQuery( $query );
			$cat = $db->loadObject();
			$cat->url = JRoute::_("index.php?option=com_digitalmarketx&view=category&id=" . (int)$cat->id);
			if($cat->parent_id)
				array_unshift($categories, $cat);
			$category = $cat->parent_id;
		}
		return $categories;
	}
	
	static public function getDocumentParentCategories($doc_id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, title, category FROM #__digitalmarketx_documents WHERE id = " . (int)$doc_id;
		$db->setQuery( $query );
		$doc = $db->loadObject();
		if($doc != null)
		{
			$doc->url = JRoute::_("index.php?option=com_digitalmarketx&view=details&id=" . (int)$doc_id);
			$result = self::getParentCategories($doc->category);
			$result []= $doc;
			return $result;
		}
		else
		{
			return null;
		}
	}
	
	static public function buildPathWay($categories)
	{
		$app = JFactory::getApplication();
		$pathway = $app->getPathway();
		foreach($categories as $cat)
		{
			if($cat->url)
			{
				$pathway->addItem($cat->title, $cat->url);
			}
			else
				$pathway->addItem($cat->title);
		}
	}
}

