<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// no direct access
defined('_JEXEC') or die;

$user = JFactory::getUser();

if($document)
{
	if($document->visible)
	{
		if($document->thumbnail)
		{
			JHTML::_('behavior.modal');
		}
		$downloadUrl = JRoute::_("index.php?option=com_digitalmarketx&task=document.download&id=" . (int)$document->id);
		$demoUrl = JRoute::_("index.php?option=com_digitalmarketx&task=document.downloaddemo&id=" . (int)$document->id);
		$demoTextUrl = JRoute::_("index.php?option=com_digitalmarketx&view=demo&id=" . (int)$document->id . "&tmpl=component");
		$payUrl = JRoute::_("index.php?option=com_digitalmarketx&view=pay&id=" . (int)$document->id);
		$editUrl = JRoute::_("index.php?option=com_digitalmarketx&view=edit&id=" . (int)$document->id);
		$detailsUrl = JRoute::_("index.php?option=com_digitalmarketx&view=details&id=" . (int)$document->id);
?>
<div class="document">
<div class="document-title">
<div class="document-rating">
<?php
for($i = 1; $i <= 5; $i++)
{
$img = "nullstart";
if($i <= $document->rating)
	$img = "fullstar";
else if((float)$i - 0.5 <= $document->rating)
	$img = "halfstar";
?>
<div class="commentstar <?php  echo $img;?>"></div>
<?php
}
?>
</div>
<?php 
if($document->canEdit)
{
?>
<a class="documentedit" href="<?php echo $editUrl;?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_EDIT"));?></a>
<?php
}
?>
<?php
echo htmlspecialchars($document->title);
echo "&nbsp;(" . htmlspecialchars($document->filename) . ")" ;
?>
</div>
<div class="document-info">
<?php
if($document->thumbnail)
{
$url = JUri::root() . $document->thumbnail;
?>
<div class="document-thumbnail">
<a href="<?php echo $url;?>" class="button_link modal" rel="{handler: 'image', size: {x: 380, y: 270}, overlayOpacity: 0}">
<img src="<?php echo JUri::root() . $document->small_thumbnail;?>" width="150" height="150"/>
</a>
</div>
<?php
}
?>
<?php
if($document->price > 0.0001)
{
?>
<span class="document-price-lable"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_PRICE")) . "&nbsp;:";?></span>
<span class="document-price-text"><?php echo htmlspecialchars($document->price) . "&nbsp;" . htmlspecialchars($document->currency);?></span>
<br/>
<?php
}
?>
<span class="document-price-lable"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SIZE")) . "&nbsp;:";?></span>
<span class="document-price-text"><?php echo htmlspecialchars($document->size) . "&nbsp;" . htmlspecialchars($document->unit);?></span>
<br/>
<span class="document-price-lable"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_AUTHOR")) . "&nbsp;:";?></span>
<span class="document-price-text"><?php echo htmlspecialchars($document->owner_name);?></span>
<br/>
<span class="document-price-lable"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_RATING")) . "&nbsp;:";?></span>
<span class="document-price-text"><?php echo htmlspecialchars($document->rating);?></span>
<br/>
<span class="document-price-lable"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_RATING_COUNT")) . "&nbsp;:";?></span>
<span class="document-price-text"><?php echo htmlspecialchars($document->rating_count);?></span>
<br/>
<?php
if(isset($document->downloadLink) && $document->downloadLink != null && $document->downloadLink->valid)
{
?>
<span class="document-price-lable"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOWNLOAD_EXPIRES")) . "&nbsp;:";?></span>
<span class="document-price-text"><?php 
if($document->downloadLink->expiration_date)
{
	$date = new JDate($document->downloadLink->expiration_date);
	echo htmlspecialchars(DigitalMarketXHelper::getTimeDifference($date));
}
else
{
	echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOWNLOAD_NEVER_EXPIRES"));
}
?></span>
<br/>
<span class="document-price-lable"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOWNLOAD_COUNT_LEFT")) . "&nbsp;:";?></span>
<span class="document-price-text"><?php 
if($document->downloadLink->link_max_downloads > 0)
{
	echo htmlspecialchars($document->downloadLink->link_max_downloads - 
		$document->downloadLink->download_hits);
}
else
{
	echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOWNLOAD_UNLIMITED"));
}
?></span>
<br/>
<?php
}
?>
<?php
if($document->state == 0)
{
?>
<span class="documentnotpublished"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_FILE_UNPUBLISHED"));?></span>
<?php
}
?>
</div>
<div style="clear: both;"></div>
<div class="document-description">
<?php
echo $document->description;
?>
</div>
<div class="button-box" >
<?php
	if($document->paid)
	{
	?>
	<a href="<?php echo $downloadUrl?>" class="button_link">
	<div class="downloadbutton">
	<div>
	<?php
	echo htmlspecialchars( JText::_("COM_DIGITALMARKETX_DOWNLOAD") );
	?>
	</div>
	</div>
	</a>
	<?php
	}
	else
	{
	if(JFactory::getUser()->id && $document->canDownload)
	{
		if($useAjax)
			$url = "#";
		else
		{
			$protocol = $_SERVER['SERVER_PROTOCOL'];
			if(strtolower(substr($protocol, 0, 5)) == 'https')
				$return = "https://";
			else
				$return = "http://";
			$return .= $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
			$url = JRoute::_("index.php?option=com_digitalmarketx&task=cart.toogleItemInCart&id=" . 
				(int)$document->id . "&r=1&return=" . base64_encode($return));
			
		}
	?>
	<a href="<?php echo $url;?>" <?php if($useAjax){?> onclick="return addToCart('<?php echo (int)$document->id;?>');" <?php } ?> class="button_link">
	<div class="cartbutton" id="cartbutton_<?php echo (int)$document->id;?>">
	<div id="incartbutton_<?php echo (int)$document->id;?>">
	<?php
	if($document->isItemInCar)
		echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_REMOVEFROMCART"));
	else
		echo htmlspecialchars( JText::_("COM_DIGITALMARKETX_ADDTOCART") );
	?>
	</div>
	</div>
	</a>
	<?php
	}
	if(!$document->isItemInCar)
	{
		$display = "inline";
	}
	else
	{
		$display = "none";
	}
	?>
	<a href="<?php echo $payUrl?>" class="button_link">
	<div class="paybutton" id="paybutton_<?php echo (int)$document->id;?>" style="display: <?php echo $display;?>">
	<div>
	<?php
	echo htmlspecialchars( JText::_("COM_DIGITALMARKETX_PAY") );
	?>
	</div>
	</div>
	</a>
	<?php
	}
	if($document->demo_file)
	{
	?>
	<a href="<?php echo $demoUrl?>" class="button_link">
	<div class="downloadbutton">
	<div>
	<?php
	echo htmlspecialchars( JText::_("COM_DIGITALMARKET_DOWNLOAD_DEMO") );
	?>
	</div>
	</div>
	</a>
	<?php
	}
?>
</div>
	<?php
	if($document->canReport)
	{
	//JHTML::_('behavior.modal');
	?>
	<div class="report-link">
	<a href="<?php echo JRoute::_("index.php?option=com_digitalmarketx&view=report&id=" . (int)$document->id);?>">
	<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_REPORT"));?>
	</a>
	</div>
	<div style="clear: both;"></div>
	<?php
	}
	?>
</div>
<?php
	}
}
?>