<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// no direct access
defined('_JEXEC') or die;

class DocumentRenderer
{
	public static function renderLink($document, $isList = false)
	{
		$payUrl = JRoute::_("index.php?option=com_digitalmarketx&view=pay&id=" . (int)$document->id);
		$editUrl = JRoute::_("index.php?option=com_digitalmarketx&view=edit&id=" . (int)$document->id);
		$detailsUrl = JRoute::_("index.php?option=com_digitalmarketx&view=details&id=" . (int)$document->id);
		$editUrl = JRoute::_("index.php?option=com_digitalmarketx&view=edit&id=" . (int)$document->id);
		$downloadUrl = JRoute::_("index.php?option=com_digitalmarketx&task=document.download&id=" . (int)$document->id);
		$html = "";
		if($document->canEdit)
		{
			$html .= "<a class=\"documentedit\" href=\"" . $editUrl . "\">" . 
				htmlspecialchars(JText::_("COM_DIGITALMARKET_EDIT")) . "</a>";
		}
		if($isList)
		{
			$html .= "<a href=\"" . $detailsUrl . "\">" . htmlspecialchars($document->title) . 
				"&nbsp;(" . htmlspecialchars($document->filename) . ")</a>";
		}
		else
		{
			if($document->paid)
				$url = $downloadUrl;
			else
				$url = $payUrl;
			$html .= "<a href=\"" . $url . "\">" . htmlspecialchars($document->title) . 
				"&nbsp;(" . htmlspecialchars($document->filename) . ")</a>";
		}
		return $html;
	}
	
	public static function renderStars($rating)
	{
		$html = "";
		for($i = 1; $i <= 5; $i++)
		{
			$class = "nullstart";
			if($i <= $rating)
				$class = "fullstar";
			else if((float)$i - 0.5 <= $rating)
				$class = "halfstar";
			$html .= "<div class=\"commentstar " . $class . "\"></div>";
		}
		
		return $html;
	}
	
	public static function renderThumbnail($document)
	{
		$url = JUri::root() . $document->thumbnail;
		$html = "<div class=\"document-thumbnail\">";
		$html .= "<a href=\"" . $url . "\" class=\"button_link modal\" ";
		$html .= "rel=\"{handler: 'image', size: {x: 380, y: 270}, overlayOpacity: 0}\" >";
		$html .= "<img src=\"" . JUri::root() . $document->small_thumbnail . "\" width=\"150\" height=\"150\"/>";
		$html .= "</a>";
		$html .= "</div>";
		return $html;
	}
	
	public static function renderButtons($document, $useAjax = true)
	{
		$html = "<div class=\"button-box\" >";
		if($document->paid)
		{
			$downloadUrl = JRoute::_("index.php?option=com_digitalmarketx&task=document.download&id=" . (int)$document->id);
			$html .= "<a href=\"" . $downloadUrl . "\" class=\"button_link\">";
			$html .= "<div class=\"downloadbutton\">";
			$html .= "<div>" . htmlspecialchars( JText::_("COM_DIGITALMARKETX_DOWNLOAD") ) . "</div>";
			$html .= "</div></a>";
		}
		else
		{
			$payUrl = JRoute::_("index.php?option=com_digitalmarketx&view=pay&id=" . (int)$document->id);
			if(JFactory::getUser()->id && $document->canDownload)
			{
				if($useAjax)
					$url = "#";
				else
				{
					$protocol = $_SERVER['SERVER_PROTOCOL'];
					if(strtolower(substr($protocol, 0, 5)) == 'https')
						$return = "https://";
					else
						$return = "http://";
					$return .= $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
					$url = JRoute::_("index.php?option=com_digitalmarketx&task=cart.toogleItemInCart&id=" . 
						(int)$document->id . "&r=1&return=" . base64_encode($return));
				}
				$html .= "<a href=\"" . $url . "\" class=\"button_link\" ";
				if($useAjax)
					$html .= "onclick=\"return addToCart('" . (int)$document->id . "');\"";
				$html .= ">";
				$html .= "<div class=\"cartbutton\" id=\"cartbutton_" . (int)$document->id . "\">";
				$html .= "<div id=\"incartbutton_" . (int)$document->id . "\">";
				if($document->isItemInCar)
					$html .= htmlspecialchars( JText::_("COM_DIGITALMARKETX_REMOVEFROMCART") );
				else
					$html .= htmlspecialchars( JText::_("COM_DIGITALMARKETX_ADDTOCART") );
				$html .= "</div></div></a>";
			}
			$html .= "<a href=\"" . $payUrl . "\" class=\"button_link\">";
			$html .= "<div class=\"paybutton\" id=\"paybutton_" . (int)$document->id . "\" style=\"display: " . 
				($document->isItemInCar ? "none" : "inline") . "\">";
			$html .= "<div>";
			$html .= htmlspecialchars( JText::_("COM_DIGITALMARKETX_PAY") );
			$html .= "</div></div></a>";
		}
		if($document->demo_file)
		{
			$demoUrl = JRoute::_("index.php?option=com_digitalmarketx&task=document.downloaddemo&id=" . (int)$document->id);
			$html .= "<a href=\"" . $demoUrl . "\" class=\"button_link\">";
			$html .= "<div class=\"downloadbutton\">";
			$html .= "<div>" . htmlspecialchars( JText::_("COM_DIGITALMARKET_DOWNLOAD_DEMO") ) . "</div>";
			$html .= "</div></a>";
		}
		$html .= "</div>";
		return $html;
	}
	
	public static function renderPrice($document)
	{
		$html = "";
		if($document->price > 0)
		{
			$html = htmlspecialchars($document->price) . "&nbsp;" . htmlspecialchars($document->currency);
		}
		return $html;
	}
	
	public static function renderSize($document)
	{
		return htmlspecialchars($document->size) . "&nbsp;" . htmlspecialchars($document->unit);
	}
	
	public static function handleConditionals($document, $template)
	{
		if($document->price > 0)
		{
			$template = str_replace("{if_not_free}", "", $template);
			$template = str_replace("{/if_not_free}", "", $template);
			$template = preg_replace('/\{if_free\}.*\{\/if_free\}/Us', "", $template);
		}
		else
		{
			$template = str_replace("{if_free}", "", $template);
			$template = str_replace("{/if_free}", "", $template);
			$template = preg_replace('/\{if_not_free\}.*\{\/if_not_free\}/Us', "", $template);
		}
		if($document->paid)
		{
			$template = str_replace("{if_paid}", "", $template);
			$template = str_replace("{/if_paid}", "", $template);
			$template = preg_replace('/\{if_not_paid\}.*\{\/if_not_paid\}/Us', "", $template);
		}
		else
		{
			$template = str_replace("{if_not_paid}", "", $template);
			$template = str_replace("{/if_not_paid}", "", $template);
			$template = preg_replace('/\{if_paid\}.*\{\/if_paid\}/Us', "", $template);
		}
		if($document->thumbnail)
		{
			$template = str_replace("{if_has_thumbnail}", "", $template);
			$template = str_replace("{/if_has_thumbnail}", "", $template);
			$template = preg_replace('/\{if_hasnt_thumbnail\}.*\{\/if_hasnt_thumbnail\}/Us', "", $template);
		}
		else
		{
			$template = str_replace("{if_hasnt_thumbnail}", "", $template);
			$template = str_replace("{/if_hasnt_thumbnail}", "", $template);
			$template = preg_replace('/\{if_has_thumbnail\}.*\{\/if_has_thumbnail\}/Us', "", $template);
		}
		if(JFactory::getUser()->id)
		{
			$template = str_replace("{if_user}", "", $template);
			$template = str_replace("{/if_user}", "", $template);
			$template = preg_replace('/\{if_guest\}.*\{\/if_guest\}/Us', "", $template);
		}
		else
		{
			$template = str_replace("{if_guest}", "", $template);
			$template = str_replace("{/if_guest}", "", $template);
			$template = preg_replace('/\{if_user\}.*\{\/if_user\}/Us', "", $template);
		}
		if($document->demo_file)
		{
			$template = str_replace("{if_has_demo}", "", $template);
			$template = str_replace("{/if_has_demo}", "", $template);
			$template = preg_replace('/\{if_hasnt_demo\}.*\{\/if_hasnt_demo\}/Us', "", $template);
		}
		else
		{
			$template = str_replace("{if_hasnt_demo}", "", $template);
			$template = str_replace("{/if_hasnt_demo}", "", $template);
			$template = preg_replace('/\{if_has_demo\}.*\{\/if_has_demo\}/Us', "", $template);
		}
		if($document->canEdit)
		{
			$template = str_replace("{if_can_edit}", "", $template);
			$template = str_replace("{/if_can_edit}", "", $template);
			$template = preg_replace('/\{if_cant_edit\}.*\{\/if_cant_edit\}/Us', "", $template);
		}
		else
		{
			$template = str_replace("{if_cant_edit}", "", $template);
			$template = str_replace("{/if_cant_edit}", "", $template);
			$template = preg_replace('/\{if_can_edit\}.*\{\/if_can_edit\}/Us', "", $template);
		}
		if($document->canDownload)
		{
			$template = str_replace("{if_can_download}", "", $template);
			$template = str_replace("{/if_can_download}", "", $template);
			$template = preg_replace('/\{if_cant_download\}.*\{\/if_cant_download\}/Us', "", $template);
		}
		else
		{
			$template = str_replace("{if_cant_download}", "", $template);
			$template = str_replace("{/if_cant_download}", "", $template);
			$template = preg_replace('/\{if_can_download\}.*\{\/if_can_download\}/Us', "", $template);
		}
		if($document->state == 1)
		{
			$template = str_replace("{if_published}", "", $template);
			$template = str_replace("{/if_published}", "", $template);
			$template = preg_replace('/\{if_unpublished\}.*\{\/if_unpublished\}/Us', "", $template);
		}
		else
		{
			$template = str_replace("{if_unpublished}", "", $template);
			$template = str_replace("{/if_unpublished}", "", $template);
			$template = preg_replace('/\{if_published\}.*\{\/if_published\}/Us', "", $template);
		}
		if(isset($document->downloadLink) && $document->downloadLink != null && $document->downloadLink->valid)
		{
			$template = str_replace("{if_has_download_link}", "", $template);
			$template = str_replace("{/if_has_download_link}", "", $template);
			$template = preg_replace('/\{if_hasnt_download_link\}.*\{\/if_hasnt_download_link\}/Us', "", $template);
		}
		else
		{
			$template = str_replace("{if_hasnt_download_link}", "", $template);
			$template = str_replace("{/if_hasnt_download_link}", "", $template);
			$template = preg_replace('/\{if_has_download_link\}.*\{\/if_has_download_link\}/Us', "", $template);
		}
		if($document->created_user_id == JFactory::getUser()->id)
		{
			$template = str_replace("{if_owner}", "", $template);
			$template = str_replace("{/if_owner}", "", $template);
			$template = preg_replace('/\{if_not_owner\}.*\{\/if_not_owner\}/Us', "", $template);
		}
		else
		{
			$template = str_replace("{if_not_owner}", "", $template);
			$template = str_replace("{/if_not_owner}", "", $template);
			$template = preg_replace('/\{if_owner\}.*\{\/if_owner\}/Us', "", $template);
		}
		if($document->canReport)
		{
			$template = str_replace("{if_can_report}", "", $template);
			$template = str_replace("{/if_can_report}", "", $template);
			$template = preg_replace('/\{if_cant_report\}.*\{\/if_cant_report\}/Us', "", $template);
		}
		else
		{
			$template = str_replace("{if_cant_report}", "", $template);
			$template = str_replace("{/if_cant_report}", "", $template);
			$template = preg_replace('/\{if_can_report\}.*\{\/if_can_report\}/Us', "", $template);
		}
		return $template;
	}
	
	public static function handleVoteConditionals($vote, $template)
	{
		if($vote->reply)
		{
			$template = str_replace("{if_has_reply}", "", $template);
			$template = str_replace("{/if_has_reply}", "", $template);
			$template = preg_replace('/\{if_hasnt_reply\}.*\{\/if_hasnt_reply\}/Us', "", $template);
		}
		else
		{
			$template = str_replace("{if_hasnt_reply}", "", $template);
			$template = str_replace("{/if_hasnt_reply}", "", $template);
			$template = preg_replace('/\{if_has_reply\}.*\{\/if_has_reply\}/Us', "", $template);
		}
		return $template;
	}
	
	static public function replaceLanguageText($matches)
	{
		return JText::_($matches[1]);
	}
	
	static public function renderDocumentTemplate($document, $template, $isList = false, $useAjax = true)
	{	
		$template = DocumentRenderer::handleConditionals($document, $template);
		$template = preg_replace_callback("/\{text\:([^\}]+)\}/", array("DocumentRenderer", "replaceLanguageText"),
			$template);
		if(strpos($template, "{document_id}") !== false)
		{
			$template = str_replace("{document_id}", (int)$document->id, $template);
		}
		if(strpos($template, "{link}") !== false)
		{
			$html = DocumentRenderer::renderLink($document, $isList);
			$template = str_replace("{link}", $html, $template);
		}
		if(strpos($template, "{thumbnail}") !== false)
		{
			if($document->thumbnail)
			{
				JHTML::_('behavior.modal');
				$html = DocumentRenderer::renderThumbnail($document);
				$template = str_replace("{thumbnail}", $html, $template);
			}
			else
				$template = str_replace("{thumbnail}", "", $template);
		}
		if(strpos($template, "{stars}") !== false)
		{
			$html = DocumentRenderer::renderStars($document->rating);
			$template = str_replace("{stars}", $html, $template);
		}
		if(strpos($template, "{buttons}") !== false)
		{
			$html = DocumentRenderer::renderButtons($document, $useAjax);
			$template = str_replace("{buttons}", $html, $template);
		}
		if(strpos($template, "{price}") !== false)
		{
			$html = DocumentRenderer::renderPrice($document);
			$template = str_replace("{price}", $html, $template);
		}
		if(strpos($template, "{size}") !== false)
		{
			$html = DocumentRenderer::renderSize($document);
			$template = str_replace("{size}", $html, $template);
		}
		if(strpos($template, "{author}") !== false)
		{
			$template = str_replace("{author}", $document->owner_name, $template);
		}
		if(strpos($template, "{rating}") !== false)
		{
			$template = str_replace("{rating}", $document->rating, $template);
		}
		if(strpos($template, "{votes_count}") !== false)
		{
			$template = str_replace("{votes_count}", $document->rating_count, $template);
		}
		if(strpos($template, "{description}") !== false)
		{
			$template = str_replace("{description}", $document->description, $template);
		}
		if(strpos($template, "{edit_link}") !== false)
		{
			$editUrl = JRoute::_("index.php?option=com_digitalmarketx&view=edit&id=" . (int)$document->id);
			$template = str_replace("{edit_link}", $editUrl, $template);
		}
		if(strpos($template, "{title}") !== false)
		{
			$template = str_replace("{title}", $document->title, $template);
		}
		if(strpos($template, "{filename}") !== false)
		{
			$template = str_replace("{filename}", $document->filename, $template);
		}
		if(strpos($template, "{pay_link}") !== false)
		{
			$payUrl = JRoute::_("index.php?option=com_digitalmarketx&view=pay&id=" . (int)$document->id);
			$template = str_replace("{pay_link}", $payUrl, $template);
		}
		if(strpos($template, "{details_link}") !== false)
		{
			$detailsUrl = JRoute::_("index.php?option=com_digitalmarketx&view=details&id=" . (int)$document->id);
			$template = str_replace("{details_link}", $detailsUrl, $template);
		}
		if(strpos($template, "{download_link}") !== false)
		{
			$downloadUrl = JRoute::_("index.php?option=com_digitalmarketx&task=document.download&id=" . (int)$document->id);
			$template = str_replace("{download_link}", $downloadUrl, $template);
		}
		if(strpos($template, "{downloaddemo_link}") !== false)
		{
			$downloadUrl = JRoute::_("index.php?option=com_digitalmarketx&task=document.downloaddemo&id=" . (int)$document->id);
			$template = str_replace("{downloaddemo_link}", $downloadUrl, $template);
		}
		if(strpos($template, "{report_link}") !== false)
		{
			$reportUrl = JRoute::_("index.php?option=com_digitalmarketx&view=report&id=" . (int)$document->id);
			$template = str_replace("{report_link}", $reportUrl, $template);
		}
		if(strpos($template, "{thumbnail_pic}") !== false)
		{
			$template = str_replace("{thumbnail_pic}", JUri::root() . $document->thumbnail, $template);
		}
		if(strpos($template, "{thumbnail_small}") !== false)
		{
			$template = str_replace("{thumbnail_small}", JUri::root() . $document->small_thumbnail, $template);
		}
		if(strpos($template, "{downloads_left}") !== false)
		{
			if(isset($document->downloadLink) && $document->downloadLink != null && $document->downloadLink->valid)
			{
				$template = str_replace("{downloads_left}", 
					$document->downloadLink->link_max_downloads - 
					$document->downloadLink->download_hits, 
					$template);
			}
			else
			{
				$template = str_replace("{downloads_left}", "", $template);
			}
		}
		if(strpos($template, "{expiration}") !== false)
		{
			if(isset($document->downloadLink) && $document->downloadLink != null && $document->downloadLink->valid)
			{
				if($document->downloadLink->expiration_date)
				{
					$date = new JDate($document->downloadLink->expiration_date);
					$datediff = htmlspecialchars(DigitalMarketXHelper::getTimeDifference($date));
					$template = str_replace("{expiration}", $datediff, $template);
				}
				else
				{
					$template = str_replace("{expiration}", 
						htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOWNLOAD_NEVER_EXPIRES")), $template);
				}
			}
			else
			{
				$template = str_replace("{expiration}", "", $template);
			}
		}
		return $template;
	}
	
	static public function renderReplyLink($vote)
	{
		$url = JRoute::_("index.php?option=com_digitalmarketx&view=commentreply&vote=" . 
			(int)$vote->id);
		return "<a href=\"$url\">" . JText::_("COM_DIGITALMARKETX_REPLY") . "</a>";
	}
	
	static public function renderVoteTemplate($vote, $template)
	{	
		$template = DocumentRenderer::handleConditionals($vote->document, $template);
		$template = DocumentRenderer::handleVoteConditionals($vote, $template);
		$template = preg_replace_callback("/\{text\:([^\}]+)\}/", 
			array("DocumentRenderer", "replaceLanguageText"),
			$template);
		if(strpos($template, "{comment_stars}") !== false)
		{
			$html = DocumentRenderer::renderStars($vote->stars);
			$template = str_replace("{comment_stars}", $html, $template);
		}
		if(strpos($template, "{comment_id}") !== false)
		{
			$template = str_replace("{comment_id}", (int)$vote->id, $template);
		}
		if(strpos($template, "{comment_subject}") !== false)
		{
			$template = str_replace("{comment_subject}", $vote->comment_subject, $template);
		}
		if(strpos($template, "{comment_user_id}") !== false)
		{
			$template = str_replace("{comment_user_id}", (int)$vote->user_id, $template);
		}
		if(strpos($template, "{comment_user_name}") !== false)
		{
			$template = str_replace("{comment_user_name}", $vote->user_name, $template);
		}
		if(strpos($template, "{comment_text}") !== false)
		{
			$template = str_replace("{comment_text}", 
				preg_replace("/\\n/", "<br/>", htmlspecialchars($vote->comment_text)), $template);
		}
		if(strpos($template, "{comment_date}") !== false)
		{
			$params = JComponentHelper::getParams('com_digitalmarketx');
			$format = $params->get('date_format', 'l, F d, Y h:i:s a');
			if($format == '')
				$format = 'l, F d, Y h:i:s a';
			$date = new JDate($vote->date_voted);
			$template = str_replace("{comment_date}", $date->format($format), $template);
		}
		if(strpos($template, "{comment_reply_text}") !== false)
		{
			if($vote->reply)
				$html = preg_replace("/\\n/", "<br/>", htmlspecialchars($vote->reply));
			else
				$html = "";
			$template = str_replace("{comment_reply_text}", $html, $template);
		}
		if(strpos($template, "{comment_reply_link}") !== false)
		{
			if($vote->document->created_user_id == JFactory::getUser()->id)
				$html = DocumentRenderer::renderReplyLink($vote);
			else
				$html = "";
			$template = str_replace("{comment_reply_link}", $html, $template);
		}
		if(strpos($template, "{comment_reply_url}") !== false)
		{
			$url = JRoute::_("index.php?option=com_digitalmarketx&view=commentreply&vote=" . 
					(int)$vote->id);
			$template = str_replace("{comment_reply_url}", $url, $template);
		}
		return $template;
	}
	
	static public function renderStyle($style)
	{
		VersionLayer::stylesheet('common.css', 'components/com_digitalmarketx/assets/');
		$root = JUri::root();
		$style = preg_replace("/url\(/", "url(" . $root, $style);
		$document = JFactory::getDocument();
		$document->addStyleDeclaration($style);
	}
}