<?php

/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
defined('_JEXEC') or die;

/**
 * Methods supporting a list of DigitalMarketX records.
 */
class DigitalMarketXModelCart extends JModelLegacy {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        parent::__construct($config);
    }

    public function addToCart($itemId)
	{
		if(!$this->canDownload($itemId))
		{
			return false;
		}
		$db = JFactory::getDBO();
		$cart_id = (int)$this->getCartId();
		$itemId = (int)$itemId;
		$query = "SELECT price, currency FROM #__digitalmarketx_documents WHERE id = " . (int)$itemId;
		$db->setQuery( $query );
		$doc = $db->loadObject();
		if($doc)
		{
			$price = (float)$doc->price;
			$currency = $db->escape($doc->currency);
			$query = "INSERT INTO #__digitalmarketx_shopping_cart_item(shoppingcart_id, item_id, `count`, price, currency)
				VALUES($cart_id, $itemId, 1, $price, '$currency')";
			$db->setQuery( $query );
			$result = $db->query();
			return $result;
		}
		else
			return false;
	}
	
	public function canDownload($id)
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$restrict_download = $params->get('restrict_download', 0);
		if($restrict_download == 0)
			return true;
		$db = JFactory::getDBO();
		$db->setQuery("SELECT category FROM #__digitalmarketx_documents WHERE id = " . (int)$id);
		$category = (int)$db->loadResult();
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.download', 'com_digitalmarketx') &&
			$user->authorise('digitalmarketx.download', 'com_digitalmarketx.category.'.(int)$category);
	}
	
	public function removeFromCart($itemId)
	{
		$db = JFactory::getDBO();
		$cart_id = (int)$this->getCartId();
		$itemId = (int)$itemId;
		$query = "DELETE FROM #__digitalmarketx_shopping_cart_item
			WHERE shoppingcart_id = $cart_id AND item_id = $itemId";
		$db->setQuery( $query );
		return $db->query();
	}
	
	public function isInCart($itemId)
	{
		$db = JFactory::getDBO();
		$cart_id = (int)$this->getCartId();
		$itemId = (int)$itemId;
		$query = "SELECT count FROM #__digitalmarketx_shopping_cart_item
			WHERE shoppingcart_id = $cart_id AND item_id = $itemId";
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	public function getCartItems()
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$max_title_length = (int)$params->get('max_title_length', 20);
		$db = JFactory::getDBO();
		$cart_id = (int)$this->getCartId();
		$query = $db->getQuery( true );
		$query->select('docs.id, docs.title, docs.price, docs.currency');
		$query->from('#__digitalmarketx_shopping_cart_item AS items');
		$query->join('LEFT', '#__digitalmarketx_documents AS docs ON items.item_id = docs.id');
		$query->where('items.shoppingcart_id = ' . $cart_id);
		$query->order('docs.currency');
		$db->setQuery( $query );
		$items = $db->loadObjectList();
		$main_currency = '';
		$sum = 0;
		foreach($items as $item)
		{
			if($max_title_length > 0 && strlen($item->title) > $max_title_length)
			{
				$item->title = substr($item->title, 0, $max_title_length) . "..";
			}
			$item->original_price = $item->price;
			$item->original_currency = $item->currency;
			if($main_currency == '')
			{
				$main_currency = $item->currency;
			}
			else if($item->currency != $main_currency)
			{
				$item->price = $this->convert($item->price, $item->currency, $main_currency);
				if($item->price <= 0)
				{
					$app = JFactory::getApplication();
					$app->enqueueMessage(JText::_("COM_DIGITALMARKETX_CONVERSION_NOT_AVAILABLE"));
					return null;
				}
				$item->currency = $main_currency;
			}
		}
		return $items;
	}
	
	public function chechOut($cart_id)
	{
		$cart_id = (int)$cart_id;
		$db = JFactory::getDBO();
		$query = $db->getQuery( true );
		$query->select('docs.id, docs.title, docs.price, docs.currency');
		$query->from('#__digitalmarketx_shopping_cart_item AS items');
		$query->join('LEFT', '#__digitalmarketx_documents AS docs ON items.item_id = docs.id');
		$query->where('items.shoppingcart_id = ' . $cart_id);
		$query->order('docs.currency');
		$db->setQuery( $query );
		$items = $db->loadObjectList();
		$main_currency = '';
		$sum = 0;
		foreach($items as $item)
		{
			$item->original_price = $item->price;
			$item->original_currency = $item->currency;
			if($main_currency == '')
			{
				$main_currency = $item->currency;
			}
			else if($item->currency != $main_currency)
			{
				$item->price = $this->convert($item->price, $item->currency, $main_currency);
				if($item->price <= 0)
					return false;
				$item->currency = $main_currency;
			}
			$sum += $item->price;
		}
		$sum = (float)$sum;
		$main_currency = $db->escape($main_currency);
		$query = "UPDATE #__digitalmarketx_shopping_carts SET in_process = 1, total = $sum, currency = '$main_currency' " .
			"WHERE shoppingcart_id = $cart_id";
		$db->setQuery( $query );
		return $db->query();
	}
	
	private function convert($amount, $source_currency, $dest_currency)
	{
		$rate = 1.0;
		$db = JFactory::getDBO();
		$esc_source_currency = $db->escape($source_currency);
		$esc_dest_currency = $db->escape($dest_currency);
		$query = "SELECT `rate` FROM #__digitalmarketx_currency_exchanges 
			WHERE source_currency = '$esc_source_currency' AND dest_currency = '$esc_dest_currency' AND
				DATE_ADD(update_time, INTERVAL 1 DAY) > NOW()";
		$db->setQuery( $query );
		$rate = (float)$db->loadResult();
		if($rate)
		{
			return round($amount * $rate, 2);
		}
		else
		{
			//Get currency conversion from google service
			$request_string = "1".$source_currency."=?".$dest_currency;
			$google_url = "http://www.google.com/ig/calculator?hl=en&q=".$request_string;
			$result = file_get_contents($google_url);
			if(preg_match('/\{lhs\:\s*\"[^\"]+\",\s*rhs\:\s*\"(\d+\.\d+)[^\"]*\",\s*error\:\s*\"\"\,\s*icc\:\s*\w*}/', 
				$result, $matches))
			{
				$rate = (float)$matches[1];
				if($rate > 0)
				{
					$converted = $rate * $amount;
					$converted = round($converted, 2);
					//Save currency rate
					$query = "INSERT INTO 
						#__digitalmarketx_currency_exchanges(source_currency, dest_currency, rate, update_time)
						VALUES('$esc_source_currency', '$esc_dest_currency', $rate, NOW())";
					$db->setQuery( $query );
					$db->query();
					//Return converted amount
					return $converted;
				}
			}
			return -1;
		}
	}
	
	public function getCartId()
	{
		$user_id = (int)JFactory::getUser()->id;
		if(!$user_id)
			return 0;
		$db = JFactory::getDBO();
		$query = "SELECT shoppingcart_id FROM #__digitalmarketx_shopping_carts WHERE 
			paid = 0 AND in_process = 0 AND user_id = $user_id";
		$db->setQuery( $query, 0, 1 );
		$cart_id = (int)$db->loadResult();
		if($cart_id == 0)
		{
			$query = "INSERT INTO #__digitalmarketx_shopping_carts(user_id, time_created)
				VALUES($user_id, NOW())";
			$db->setQuery( $query );
			$db->query();
			$cart_id = $db->insertId();
		}
		return $cart_id;
	}
	
	public function getPaymentConfig()
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$config = new stdclass();
		$config->paypalaccount = $params->get('paypalaccount', '');
		$config->testmode = $params->get('testmode', 1);
		$config->use_simulator = $params->get('use_simulator', 1);
		return $config;
	}
}
