<?php

/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
defined('_JEXEC') or die;

/**
 * Methods supporting a list of DigitalMarketX records.
 */
class DigitalMarketXModelComment extends JModelLegacy {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        parent::__construct($config);
    }
	
	public function canSubmitComment($category, $doc_id)
	{
		$user = JFactory::getUser();
		if($user->id == $this->getOwner($doc_id))
			return false;
		if($this->userHasComments($user->id, $doc_id))
			return false;
		return 
			$user->authorise('digitalmarketx.comment', 'com_digitalmarketx.category.'.(int)$category);
	}
	
	public function requireDownloadBeforeComment()
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		return $params->get('download_before_comment', 0);
	}
	
	public function isDocumentDownloaded($doc_id)
	{
		$doc_id = (int)$doc_id;
		$session = JFactory::getSession();
		$downloads = $session->get('files_downloaded', array());
		if(array_search($doc_id, $downloads) !== false)
		{
			return true;
		}
		$user_id = (int)JFactory::getUser()->id;
		if($user_id)
		{
			$db = JFactory::getDBO();
			$query = "SELECT download_count FROM #__digitalmarketx_documents_stats
				WHERE doc_id = $doc_id AND user_id = $user_id";
			$db->setQuery( $query );
			$download_count = (int)$db->loadResult();
			return $download_count > 0;
		}
		return false;
	}
	
	public function canPublishComment($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.publish_comments', 'com_digitalmarketx.category.'.(int)$category);
	}

	public function getDocumentCategory($id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT category FROM #__digitalmarketx_documents WHERE id = " . (int)$id;
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	private function userHasComments($user_id, $doc_id)
	{
		$user_id = (int)$user_id;
		$doc_id = (int)$doc_id;
		$db = JFactory::getDBO();
		$query = "SELECT COUNT(*) FROM #__digitalmarketx_votes WHERE state = 1 AND document_id = $doc_id AND user_id = $user_id";
		$db->setQuery( $query );
		return $db->loadResult() > 0;
	}
	
	private function getOwner($id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT created_user_id FROM #__digitalmarketx_documents WHERE id = " . (int)$id;
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	public function submitComment($doc_id, $title, $text, $stars, $thumbs = 0, &$state)
	{
		$db = JFactory::getDBO();
		$title = $db->escape($title);
		$text= $db->escape($text);
		$stars = (int)$stars;
		$doc_id = (int)$doc_id;
		$user_id = (int)JFactory::getUser()->id;
		$thumbs_up = $thumbs > 0 ? $thumbs : 0;
		$thumbs_down = $thumbs < 0 ? -$thumbs : 0;
		$category = $this->getDocumentCategory($doc_id);
		if(!$this->canSubmitComment($category, $doc_id))
			return false;
		$state = $this->canPublishComment($category) ? 1 : 0;
		$query = "INSERT INTO #__digitalmarketx_votes(comment_subject, comment_text, stars, date_voted, document_id, user_id, thumbs_up, thumbs_down, state)
			VALUES('$title', '$text', $stars, NOW(), $doc_id, $user_id, $thumbs_up, $thumbs_down, $state)";
		$db->setQuery( $query );
		$result = $db->query();
		if($result)
		{
			require_once(JPATH_ADMINISTRATOR . DS . "components" . DS . "com_digitalmarketx" . DS . "helpers" . DS . "digitalmarketx.php");
			if($state == 1)
			{
				DigitalMarketXHelper::recalculateDocumentRating($doc_id);
			}
			$query = "SELECT id, title FROM #__digitalmarketx_documents WHERE id = " . (int)$doc_id;
			$db->setQuery( $query );
			$document = $db->loadObject();
			if($document)
			{
				DigitalMarketXHelper::notifyCommentSubmitted($doc_id, $document->title);
			}
		}
		return $result;
	}
}
