<?php

/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
defined('_JEXEC') or die;

/**
 * Methods supporting a list of DigitalMarketX records.
 */
class DigitalMarketXModelCommentReply extends JModelLegacy {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        parent::__construct($config);
    }
	
	public function canSubmitComment($category, $doc_id)
	{
		$user = JFactory::getUser();
		if($user->id != $this->getOwner($doc_id))
			return false;
		return 
			$user->authorise('digitalmarketx.comment', 'com_digitalmarketx.category.'.(int)$category);
	}
	
	public function getDocumentForVote($vote_id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT document_id FROM #__digitalmarketx_votes WHERE id = " . (int)$vote_id;
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	public function canPublishComment($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.publish_comments', 'com_digitalmarketx.category.'.(int)$category);
	}

	public function getDocumentCategory($id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT category FROM #__digitalmarketx_documents WHERE id = " . (int)$id;
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	private function getOwner($id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT created_user_id FROM #__digitalmarketx_documents WHERE id = " . (int)$id;
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	public function submitCommentReply($vote_id, $text, &$state)
	{
		$db = JFactory::getDBO();
		$text= $db->escape($text);
		$vote_id = (int)$vote_id;
		$doc_id = (int)$this->getDocumentForVote($vote_id);
		$user_id = (int)JFactory::getUser()->id;
		$category = $this->getDocumentCategory($doc_id);
		if(!$this->canSubmitComment($category, $doc_id))
			return false;
		//$state = $this->canPublishComment($category) ? 1 : 0;
		$state = 1;
		$query = "INSERT INTO #__digitalmarketx_votes_replies(comment_text, vote_id, user_id, state)
			VALUES('$text', $vote_id, $user_id, $state)";
		$db->setQuery( $query );
		$result = $db->query();
		return $result;
	}
}
