<?php

/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
defined('_JEXEC') or die;

define("FILE_NOT_UPLOADED", -1);
define("EXTENSION_NOT_ALLOWED", -2);
define("FILE_TOO_BIG", -3);

/**
 * Methods supporting a list of DigitalMarketX records.
 */
class DigitalMarketXModelDocument extends JModelLegacy {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        parent::__construct($config);
    }

    public function getFileName($id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, attachment FROM #__digitalmarketx_documents WHERE id = " . (int)$id;
		$db->setQuery( $query );
		$doc = $db->loadObject();
		if($doc)
			return $doc->attachment;
		return "";
	}
	
	public function getDemoFileName($id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, demo_file FROM #__digitalmarketx_documents WHERE id = " . (int)$id;
		$db->setQuery( $query );
		$doc = $db->loadObject();
		if($doc)
			return $doc->demo_file;
		return "";
	}
	
	public function getDocumentUsers($docId)
	{
		$db = JFactory::getDBO();
		$query = "SELECT #__digitalmarketx_documents_users.user_id, #__users.name FROM #__digitalmarketx_documents_users 
			LEFT JOIN #__users ON #__digitalmarketx_documents_users.user_id = #__users.id
			WHERE #__digitalmarketx_documents_users.doc_id = " . (int)$docId;
		$db->setQuery( $query );
		return $db->loadObjectList();
	}
	
	public function idDownloadable($id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, created_user_id, price, category FROM #__digitalmarketx_documents WHERE id = " . (int)$id;
		$db->setQuery( $query );
		$doc = $db->loadObject();
		if($this->canDownloadFree($doc->category))
			return true;
		if(!$this->hasUserAccess($doc))
			return false;
		if($doc && $doc->price < 0.000001)
			return true;
		$user = JFactory::getUser();
		if($user->id)
		{
			if($doc->created_user_id == $user->id)
				return true;
		}
		$query = "SELECT download_id, item_id, user_id
			FROM #__digitalmarketx_download_links
			WHERE 
				(paid <> 0 AND expiration_date >= NOW() AND (download_hits = 0 OR download_hits <= link_max_downloads))
				AND item_id = " . (int)$id;
		$db->setQuery( $query );
		$downloadLinks = $db->loadObjectList();
		if($downloadLinks)
		{
			$session = JFactory::getSession();
			$activeDownloads = $session->get("digitalmarketxactivedownloads", null);
			foreach($downloadLinks as $downloadLink)
			{
				if($downloadLink->user_id)
				{
					$user = JFactory::getUser();
					if($user->id == $downloadLink->user_id)
						return $downloadLink->download_id;
				}
				if($activeDownloads && count($activeDownloads) > 0)
				{
					if(array_search($downloadLink->download_id, $activeDownloads) !== false)
						return $downloadLink->download_id;
				}
			}
		}
		return false;
	}
	
	public function canAssignUser($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.assignusers', 'com_digitalmarketx.category.'.(int)$category);
	}
	
	private function hasUserAccess($document)
	{
		$user = JFactory::getUser();
		if($user->id == $document->created_user_id)
			return true;
		$db = JFactory::getDBO();
		$query = "SELECT #__digitalmarketx_documents_users.user_id FROM #__digitalmarketx_documents_users 
			WHERE #__digitalmarketx_documents_users.doc_id = " . (int)$document->id;
		$db->setQuery( $query );
		$users = $db->loadColumn();
		if(count($users) == 0)
			return true;
		return array_search($user->id, $users) !== false;
	}
	
	public function canDownloadFree($category)
	{
		if($category == 0)
			return true;
		$user = JFactory::getUser();
		return $user->authorise('digitalmarketx.freedownload', 'com_digitalmarketx.category.'.(int) $category);
	}
	
	
	public function canDownload($id)
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$restrict_download = $params->get('restrict_download', 0);
		if($restrict_download == 0)
			return true;
		$db = JFactory::getDBO();
		$db->setQuery("SELECT category FROM #__digitalmarketx_documents WHERE id = " . (int)$id);
		$category = (int)$db->loadResult();
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.download', 'com_digitalmarketx') &&
			$user->authorise('digitalmarketx.download', 'com_digitalmarketx.category.'.(int)$category);
	}
	
	public function increaseDownloadCount($download_id, $docId = 0)
	{
		$db = JFactory::getDBO();
		if($download_id !== true)
		{
			$query = "UPDATE #__digitalmarketx_download_links SET download_hits = download_hits + 1 WHERE download_id = " . (int)$download_id;
			$db->setQuery($query);
			$db->query();
		}
		if($docId)
		{
			$docId = (int)$docId;
			$user_id = (int)JFactory::getUser()->id;
			//Increase per user download count
			$query = "INSERT INTO #__digitalmarketx_documents_stats
				(doc_id, user_id, download_count)
				VALUES($docId, $user_id, 1)
				ON DUPLICATE KEY UPDATE download_count = download_count + 1";
			$db->setQuery( $query );
			$db->query();
			//Increase global download count
			$query = "UPDATE #__digitalmarketx_documents 
				SET download_count = download_count + 1
				WHERE id = $docId";
			$db->setQuery( $query );
			$db->query();
			if(!$user_id)
			{
				$session = JFactory::getSession();
				$downloads = $session->get('files_downloaded', array());
				$downloads []= $docId;
				$session->set('files_downloaded', $downloads);
			}
		}
	}
	
	private function _isAllowedExtension($filename, $allowed = null)
	{
		$ext = "";
		$dotpos = strrpos($filename, ".");
		if($dotpos !== false)
		{
			$ext = substr($filename, $dotpos + 1);
			$ext = trim(strtolower($ext));
		}
		$params = JComponentHelper::getParams('com_digitalmarketx');
		if($allowed == null)
			$allowed = $params->get("alloweduploadfiletypes", "pdf ppt gz tar tgz zip bmp gif jpeg jpg jpe png tiff tif txt mpeg mpg mpe qt mov avi flv doc docx");
		$allowed_ext = explode(" ", $allowed);
		foreach($allowed_ext as $e)
		{
			if($ext == trim(strtolower($e)))
				return true;
		}
		return false;
	}
	
	public function upload($title, $metatags, $category, $price, $currency, $description, $demo_text, 
		$file, $thumbnail, $demo, &$published, &$users,
		$documentId = null)
	{
		$category = (int)$category;
		$price = (float)$price;
		if(trim($title) == '')
		{
			$this->setError(JText::_('COM_DIGITALMARKETX_TYPE_TITLE'));
			return false;
		}
		if($category == 0)
		{
			$this->setError(JText::_('COM_DIGITALMARKETX_SELECT_CATEGORY'));
			return false;
		}
		$user = JFactory::getUser();
		if($documentId == null)
		{
			if(!$user->authorise('digitalmarketx.upload', 'com_digitalmarketx.category.'.(int) $category))
			{
				$this->setError(JText::_('COM_DIGITALMARKETX_UPLOAD_NOT_ALLOWED'));
				return false;
			}
		}
		if($documentId)
		{
			if(!$this->_canEdit($documentId))
			{
				$this->setError(JText::_('COM_DIGITALMARKET_EDIT_NOT_ALLOWED'));
				return false;
			}
		}
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$defaultPrice = (float)$params->get('defaultprice', 10);
		$defaultCurrency = $params->get('defaultcurrency', 'USD');
		if(!$user->authorise('digitalmarketx.changeprice', 'com_digitalmarketx') && 
			!$user->authorise('digitalmarketx.changeprice', 'com_digitalmarketx.category.'.(int) $category))
		{
			$price = $defaultPrice;
			$currency = $defaultCurrency;
		}
		else
		if(!$user->authorise('digitalmarketx.changecurrency', 'com_digitalmarketx.category.'.(int) $category))
		{
			$currency = $defaultCurrency;
		}
		$minprice = (float)$params->get('minprice', 0.01);
		$maxprice = (float)$params->get('maxprice', 1000000.00);
		if($price < $minprice || $price > $maxprice)
		{
			$this->setError(JText::sprintf('COM_DIGITALMARKET_PRICE_OUTOFRANGE', $minprice, $maxprice));
			return false;
		}
		if($documentId == null && (!$user->authorise('core.edit.state', 'com_digitalmarketx.category.'.(int) $category)))
		{
			$published = 0;
		}
		$published = $published ? 1 : 0;
		$fileFullName = false;
		$fileThumbFullName = false;
		$demoFullName = false;
		if($user->authorise('digitalmarketx.upload', 'com_digitalmarketx.category.'.(int) $category))
		{
			$error = 0;
			if(($fileFullName = $this->uploadFile($file, "digitalmarketxdocs", null, $error)) === false && $documentId == null)
			{
				if($error == FILE_NOT_UPLOADED)
					$this->setError(JText::_("COM_DIGITALMARKETX_NO_FILE_UPLOADED"));
				else if($error == EXTENSION_NOT_ALLOWED)
					$this->setError(JText::_("COM_DIGITALMARKETX_EXTENSION_NOT_ALLOWED"));
				else if($error == FILE_TOO_BIG)
					$this->setError(JText::_("COM_DIGITALMARKETX_THE_UPLOADED_FILE_EXCEEDS_MAX_ALLOWED"));
				return false;
			}
			$params = JComponentHelper::getParams('com_digitalmarketx');
			$allowedExtensions = $params->get('alloweduploadimagetypes', "bmp gif jpeg jpg jpe png");
			if(($fileThumbFullName = $this->uploadImage($thumbnail, "digitalmarketxthumb", $allowedExtensions, $error)) === false)
			{
				if($error == EXTENSION_NOT_ALLOWED)
					$this->setError(JText::_("COM_DIGITALMARKETX_THUMBNAIL_EXTENSION_NOT_ALLOWED"));
			}
			$demoFullName = $this->uploadFile($demo, "digitalmarketxdocs", null, $error);
			if($demoFullName === false)
			{
				if($error == EXTENSION_NOT_ALLOWED)
					$this->setError(JText::_("COM_DIGITALMARKETX_EXTENSION_NOT_ALLOWED"));
				else if($error == FILE_TOO_BIG)
					$this->setError(JText::_("COM_DIGITALMARKETX_THE_UPLOADED_FILE_EXCEEDS_MAX_ALLOWED"));
			}
		}
		$db = JFactory::getDBO();
		$title = $db->escape($title);
		$metatags = $db->escape($metatags);
		$currency = $db->escape($currency);
		if($fileFullName !== false)
			$fileFullName = $db->escape($fileFullName);
		else
			$fileFullName = '';
		if($fileThumbFullName !== false)
			$fileThumbFullName = $db->escape($fileThumbFullName);
		else
			$fileThumbFullName = '';
		if($demoFullName !== false)
			$demoFullName = $db->escape($demoFullName);
		else
			$demoFullName = '';
		$description = $db->escape($description);
		$demo_text = $db->escape($demo_text);
		if($user->id)
			$user_id = (int)$user->id;
		else
			$user_id = 'NULL';
		if($documentId == null)
		{
			$date = new JDate();
			$date = $date->toSql();
			$date = $db->escape($date);
			$query = "INSERT INTO #__digitalmarketx_documents(title, metatags, price, currency, category, description, demo_text, attachment, thumbnail, demo_file, state, created_user_id, created_time) 
				VALUES('$title', '$metatags', $price, '$currency', $category, '$description', '$demo_text', '$fileFullName', '$fileThumbFullName', '$demoFullName', $published, $user_id, '$date')";
		}
		else
		{
			$saveFileState = "";
			$saveThumbnail = "";
			$saveDemo = "";
			$savePublished = "";
			$savePrice = "";
			$saveCurrency = "";
			$saveCategory = "";
			if($fileFullName)
				$saveFileState = ", attachment = '$fileFullName'";
			if($fileThumbFullName)
				$saveThumbnail = ", thumbnail = '$fileThumbFullName'";
			if($demoFullName)
				$saveDemo = ", demo_file = '$demoFullName'";
			if(
				$user->authorise('digitalmarketx.upload', 'com_digitalmarketx.category.' . (int)$category))
			{
				$saveCategory = ", category = $category";
			}
			if($user->authorise('core.edit.state', 'com_digitalmarketx.category.'.(int) $category))
			{
				$savePublished = ", state = $published";
			}
			if($user->authorise('digitalmarketx.changeprice', 'com_digitalmarketx.category.'.(int) $category))
			{
				$savePrice = ", price = $price";
				if($user->authorise('digitalmarketx.changecurrency', 'com_digitalmarketx.category.'.(int) $category))
				{
					$saveCurrency = ", currency = '$currency'";
				}
			}
			$query = "UPDATE #__digitalmarketx_documents 
				SET title='$title', metatags ='$metatags' $savePrice $saveCurrency $saveCategory ,
				description = '$description', demo_text = '$demo_text' $saveFileState $saveThumbnail $savePublished $saveDemo
				WHERE id = " . (int)$documentId;
		}
		$db->setQuery($query);	
		if( $db->query() )
		{
			if($documentId == null)
				$documentId = $db->insertId();
			if($this->canAssignUser($category))
				$this->_saveDocumentUsers($documentId, $users);
			else
				$users = "";
			return $documentId;
		}
		else
		{
			$this->setError(JText::_('COM_DIGITALMARKET_ERROR_UPLOADING_FILE'));
			return false;
		}
	}
	
	private function createImageThumb($image)
	{
		if(function_exists("getimagesize"))
		{
			$img = null;
			$size = getimagesize($image);
			switch($size[2])
			{
			case 1: //gif
				$img = imagecreatefromgif($image);
				break;
			case 2: //jpg
				$img = imagecreatefromjpeg($image);
				break;
			case 3: //png
				$img = imagecreatefrompng($image);
				break;
			case 6: //bmp
				$img = imagecreatefromwbmp($image);
				break;
			default: 
				return false;
			}
			$nw = $width = (int)$size[0];
			$nh = $height = (int)$size[1];
			$startx = 0;
			$starty = 0;
			if($width > $height)
			{
				$nw = 150;
				$nh = ($height * $nw) / $width;
				$starty = (150 - $nh) / 2;
			}
			else
			{
				$nh = 150;
				$nw = ($nh * $width) / $height;
				$startx = (150 - $nw) / 2;
			}
			$dest = imagecreatetruecolor(150, 150);
			$background = imagecolorallocate($dest, 255, 13, 252);
			imagecolortransparent ($dest, $background);
			imagefilledrectangle($dest, 0, 0, 149, 149, $background);
			imagecopyresized($dest, $img, $startx, $starty, 0, 0, $nw, $nh, $width, $height);
			imagepng($dest, $image . "_small.jpg");
			imagedestroy($img);
			imagedestroy($dest);
		}
	}
	
	private function randomizeFileName($filename)
	{
		$ext = "";
		$dotpos = strrpos($filename, ".");
		if($dotpos !== false)
		{
			$ext = substr($filename, $dotpos + 1);
			$filename = substr($filename, 0, $dotpos);
		}
		for($i = 0; $i < 10; $i++)
			$filename .= rand(0, 9);
		return $filename . "." . $ext;
	}
	
	private function uploadImage($file, $dest_folder, $allowedExtensions, &$error)
	{
		jimport('joomla.filesystem.file');
		$error = 0;
		if (is_uploaded_file($file['tmp_name']))
		{
			$fileName = JFile::makeSafe($file['name']);
			$fileName = $this->randomizeFileName($fileName);
			if($this->_isAllowedExtension($fileName, $allowedExtensions))
			{
				if(!JFile::upload($file['tmp_name'], 
						JPATH_ROOT . "/" . $dest_folder . "/" . $fileName))
				{
					$error = FILE_NOT_UPLOADED;
					return false ;
				}
				$fileFullName = $dest_folder . "/" . $fileName;
				$this->createImageThumb(JPATH_ROOT . "/" . $fileFullName);
			}
			else
			{
				$error = EXTENSION_NOT_ALLOWED;
				return false;
			}
		}
		else
		{
			$error = FILE_NOT_UPLOADED;
			return false;
		}
		return $fileFullName;
	}
	
	private function getFolderForUser($dest_folder)
	{
		jimport('joomla.filesystem.file');
		jimport('joomla.filesystem.folder');
		$user_id = (int)JFactory::getUser()->id;
		$folder = JPATH_ROOT . "/" . $dest_folder . "/" . $user_id;
		if(!JFolder::exists($folder))
		{
			JFolder::create($folder);
		}
		if(!JFile::exists($folder . "/index.html"))
		{
			JFile::copy(JPATH_ADMINISTRATOR . "/components/com_digitalmarketx/index.html",  $folder . "/index.html");
		}
		if(!JFile::exists($folder . "/.htaccess"))
		{
			JFile::copy(JPATH_ADMINISTRATOR . "/components/com_digitalmarketx/htaccess.txt",  $folder . "/.htaccess");
		}
		if(JFolder::exists($folder))
		{
			return $dest_folder . "/" . $user_id;
		}
		else
			return $dest_folder;
	}
	
	private function _hasValidSize($file)
	{
		$size_in_bytes = filesize($file);
		if($size_in_bytes === false)
			return false;
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$max_size = (int)$params->get('upload_max_size', 1024);
		return $max_size == 0 || $size_in_bytes <= $max_size * 1024;
	}
	
	private function uploadFile($file, $dest_folder, $allowedExtensions, &$error)
	{
		jimport('joomla.filesystem.file');
		$error = 0;
		if (is_uploaded_file($file['tmp_name']))
		{
			if(!$this->_hasValidSize($file['tmp_name']))
			{
				$error = FILE_TOO_BIG;
				return false ;
			}
			$fileName = JFile::makeSafe($file['name']);
			$dest_folder = $this->getFolderForUser($dest_folder);
			if($this->_isAllowedExtension($fileName, $allowedExtensions))
			{
				if(!JFile::upload($file['tmp_name'], 
						JPATH_ROOT . "/" . $dest_folder . "/" . $fileName))
				{
					$error = FILE_NOT_UPLOADED;
					return false ;
				}
				$fileFullName = $dest_folder . "/" . $fileName;
			}
			else
			{
				$error = EXTENSION_NOT_ALLOWED;
				return false;
			}
		}
		else
		{
			$error = FILE_NOT_UPLOADED;
			return false;
		}
		return $fileFullName;
	}
	
	private function _saveDocumentUsers($docId, $users)
	{
		$docId = (int)$docId;
		$db = JFactory::getDBO();
		$query = "DELETE FROM #__digitalmarketx_documents_users WHERE doc_id = " . $docId;
		$db->setQuery( $query );
		$db->query();
		$users = explode(",", $users);
		foreach($users as $user)
		{
			$user = (int)$user;
			if($user)
			{
				$query = "INSERT INTO #__digitalmarketx_documents_users(doc_id, user_id) VALUES($docId, $user)";
				$db->setQuery( $query );
				$db->query();
			}
		}
	}
	
	private function _allowAdd($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.upload', 'com_digitalmarketx') &&
			$user->authorise('digitalmarketx.upload', 'com_digitalmarketx.category.'.(int) $category);
	}
	
	private function _canEdit($documentId)
	{
		$db = JFactory::getDBO();
		$query = "SELECT created_user_id, category FROM #__digitalmarketx_documents WHERE id = " . (int)$documentId;
		$db->setQuery( $query );
		$doc = $db->loadObject();
		if(!$doc)
			return false;
		$category = $doc->category;
		$user = JFactory::getUser();
		if($user->authorise('core.edit', 'com_digitalmarketx') ||
			$user->authorise('core.edit', 'com_digitalmarketx.category.'.(int) $category))
			return true;
		return ($user->authorise('core.edit.own', 'com_digitalmarketx.category.' . $category) ) &&
			$user->id &&
			$doc->created_user_id == $user->id;
	}
}
