<?php

/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
defined('_JEXEC') or die;

/**
 * Methods supporting a list of DigitalMarketX records.
 */
class DigitalMarketXModelPay extends JModelLegacy {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        parent::__construct($config);
    }

	public function getPaymentConfig()
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$config = new stdclass();
		$config->paypalaccount = $params->get('paypalaccount', '');
		$config->testmode = $params->get('testmode', 1);
		$config->use_simulator = $params->get('use_simulator', 1);
		return $config;
	}
	
	public function getDocument($id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, title, price, currency, attachment, category FROM #__digitalmarketx_documents WHERE id = " . (int)$id;
		$db->setQuery( $query, 0, 1 );
		$doc = $db->loadObject();
		return $doc;
	}
	
	public function canDownload($category)
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$restrict_download = $params->get('restrict_download', 0);
		if($restrict_download == 0)
			return true;
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.download', 'com_digitalmarketx.category.'.(int) $category);
	}
	
	function createDownloadLink($docId)
	{
		$docId = (int)$docId;
		$db = JFactory::getDBO();
		
		$query = "SELECT price, currency FROM #__digitalmarketx_documents WHERE id = $docId";
		$db->setQuery( $query );
		$docPrice = $db->loadObject();
		
		//Delete expired and not paid download links 
		$db->setQuery("DELETE FROM #__digitalmarketx_download_links WHERE expiration_date < NOW() || (paid = 0 AND TO_DAYS(NOW()) - TO_DAYS(creation_date) > 1)");
		$db->query();
		
		$secret_word = $this->getRandom($docId . $docId);
		$random_value = $this->getRandom($docId);
		
		$e_secret_word = $db->escape($secret_word);
		$e_random_value = $db->escape($random_value);
		$e_price = (float)($docPrice ? $docPrice->price : 0.0);
		$e_currency = $docPrice ? $db->escape( $docPrice->currency ) : '';
		
		$query = "INSERT INTO #__digitalmarketx_download_links
			(item_id, paid, creation_date, secret_word, random_value, price, currency)
			VALUES($docId, 0, NOW(), '$e_secret_word', '$e_random_value', $e_price, '$e_currency')";
		$db->setQuery($query);
		$db->query();
		$download_id = (int)$db->insertid();
		$downloadLink = new stdClass();
		if($downloadLink)
		{
			$downloadLink->downloadId = $download_id;
			$downloadLink->secret_word = $secret_word;
			$downloadLink->random_value = $random_value;
			$downloadLink->accessCode = $download_id . ":" . sha1($secret_word . $random_value) . 
				":" . $random_value;
		}
		return $downloadLink;
	}
	
	function getRandom($seed)
	{
		$config = JFactory::getConfig();
		$secret = "";
		if($config)
		{
			$version = new JVersion();
			if($version->RELEASE < "3.0")
				$secret .= $config->getValue( 'config.secret' ) . $config->getValue( 'config.password' );
			else
				$secret .= $config->get( 'config.secret' ) . $config->get( 'config.password' );
		}
		$rand = $seed;
		for($i = 0; $i < 100; $i++)
		{
			$rand .= microtime() . $secret;
			$rand = sha1($rand);
		}
		return $rand;
	}
	
	function debug($text)
	{
		/*$db = JFactory::getDBO();
		$text = $db->escape($text);
		$query = "INSERT INTO debug(debug_text, time) VALUES('$text', NOW())";
		$db->setQuery( $query );
		$db->query();*/
	}
	
	function handleResponse()
	{
		$paymentConfig = $this->getPaymentConfig();
		$receiver_email = JRequest::getVar('receiver_email');
		$business = JRequest::getVar('business');
		if(trim(strtoupper($paymentConfig->paypalaccount)) != trim(strtoupper($receiver_email)) && 
			trim(strtoupper($paymentConfig->paypalaccount)) != trim(strtoupper($business)))
		{
			return;
		}
		$req = 'cmd=_notify-validate';
		$text = "";
		foreach ($_POST as $key => $value)
		{
			$save_value = JRequest::getVar($key);
			$text .= "(" . $key . " = " . $save_value . ")\r\n";
			$req .= "&" . $key . "=" . urlencode($save_value);
		}
		$payer_email = JRequest::getVar('payer_email');
		$db = JFactory::getDBO();
		$txn_id = JRequest::getVar('txn_id');
		$paid = false;
		if(!$this->_isTransactionPayed($txn_id))
		{
			$validate_response = $this->_validatePayment($req, JRequest::getInt('test_ipn', 0), $paymentConfig);
			$paid = (strcmp ($validate_response, "VERIFIED") == 0) ? 1 : 0;
			$this->debug("validate_response " . $validate_response);
		}
		else
		{
			$this->debug("trans not paid");
			return;
		}
		$txn_id = $db->escape($txn_id);
		$notify_email = "";
		$text = $db->escape($text);
		$validate_response = $db->escape($validate_response);
		$custom = JRequest::getVar('custom');
		list($download_id, $user_id) = explode("-", $custom);
		$download_id = (int)$download_id;
		$user_id = (int)$user_id;
		$document_id = JRequest::getInt('item_number');
		$document_id_from_download_id = $this->_getDocumentFromDownloadLink($download_id);
		$status = '';
		if($document_id != $document_id_from_download_id)
		{
			$paid = false;
			$status = 'Invalid download id received;';
		}
		$paid_price = 0;
		$currency_code = '';
		if($paid)
		{
			$paid_price = JRequest::getFloat('mc_gross');
			$currency_code = JRequest::getVar('mc_currency');
			$paid = $this->_validatePrice($document_id, $download_id, $paid_price, $currency_code) ? 1 : 0;
			if($paid)
			{
				$status = trim(strtoupper(JRequest::getVar('payment_status')));
				$paid = ($status == 'COMPLETED') ? 1 : 0;
			}
		}
		$status = $db->escape($status);
		$amount = JRequest::getFloat('mc_gross');
		$fee = JRequest::getFloat('mc_fee', 0);
		$tax = JRequest::getFloat('tax');
		$mc_currency = $db->escape(JRequest::getVar('mc_currency'));
		$esc_receiver_email = $db->escape($receiver_email);
		$esc_user_email = $db->escape($payer_email);
		if($user_id)
		{
			$user = $user_id;
			$userObj = JFactory::getUser($user_id);
			$user_name = $userObj->name;
		}
		else
		{
			$user = "NULL";
			$user_name = "Guest";
		}
		$query = "INSERT INTO 
			#__digitalmarketx_payments(user_id, user_email, item_id, paid, payment_date, txn_id, response, validate_response, status, amount, tax, fee, currency, receiver_email)
			VALUES($user, '$esc_user_email', $document_id, $paid, NOW(), '$txn_id', '$text', '$validate_response', '$status', '$amount', '$tax', '$fee', '$mc_currency', '$esc_receiver_email')";
		$db->setQuery( $query );
		$query_result = $db->query();
		$payment_id = $db->insertid();
		if($paid)
		{	
			$this->debug("payment " . $payment_id);
			$accesscode = $this->_setDownloadLinkPayed($download_id, $payer_email, $user_id);
			$docname = $this->_getDocumentName( $document_id ); 
			$this->_updateUserBalance( $document_id, $fee, $user_id); 
			$url = $this->_getUrlForDocument( $document_id, $accesscode );
			$this->_notifyPayment($payment_id, $payer_email, $url, $download_id, $docname, $user_name, $document_id);
		}
	}
	
	function _saveSaleStat($document_id, $buyer_id, $amount, $currency)
	{
		$document_id = (int)$document_id;
		$buyer_id = (int)$buyer_id;
		$amount = (float)$amount;
		$date = new JDate();
		$date = $date->toSql();
		$db = JFactory::getDBO();
		$date = $db->escape($date);
		$currency = $db->escape($currency);
		$query = "INSERT INTO #__digitalmarketx_documents_sales
			(doc_id, buyer_id, amount, purchase_time, currency)
			VALUES($document_id, $buyer_id, $amount, '$date', '$currency')";
		$db->setQuery( $query );
		$db->query();
	}
	
	function _updateUserBalance($document_id, $fee, $buyer_id = 0)
	{
		$this->debug("_updateUserBalance");
		$db = JFactory::getDBO();
		$db->setQuery("SELECT price, currency, created_user_id FROM #__digitalmarketx_documents WHERE id = " . (int)$document_id);
		$document = $db->loadObject();
		if($document->created_user_id)
		{
			$params = JComponentHelper::getParams('com_digitalmarketx');
			$managerpercent = (float)$params->get('managerpercent', 10.0);
			$price = (float)$document->price - $fee;
			$amount = (float)($price * (100.0 - $managerpercent)) / 100.0;
			$currency = $db->escape($document->currency);
			$db->setQuery("SELECT money_id FROM #__digitalmarketx_users_money WHERE currency = '$currency' AND userid = " . (int)$document->created_user_id);
			$money_id = (int)$db->loadResult();
			if($money_id)
			{
				$query = "UPDATE #__digitalmarketx_users_money SET balance = balance + $amount WHERE money_id = $money_id";
			}
			else
			{
				$query = "INSERT INTO #__digitalmarketx_users_money(userid, balance, currency) VALUES(" .  
					(int)$document->created_user_id . ", $amount, '$currency')";
			}
			$this->debug($query);
			$db->setQuery( $query );
			$db->query();
			$this->_saveSaleStat($document_id, $buyer_id, $amount, $document->currency);
		}
	}
	
	function _notifyPayment($payment_id, $payer_email, $downloadlink, $download_id, $docname, $user_name, $document_id)
	{
		$emailConfig = $this->_getEmailConfig();
		if(!$emailConfig)
			return;
		$email = $emailConfig->notification_email;
		$text = $emailConfig->notificationbody;
		$subject = $emailConfig->notification_subject;
		$guest_subject = $emailConfig->client_notification_subject;
		$guest_text = $emailConfig->client_notificationbody;
		$owner_subject = $emailConfig->owner_notification_subject;
		$owner_text = $emailConfig->owner_notificationbody;
		if(strstr($guest_text, "{download_link}") === false)
			$guest_text .= "{download_link}";
		$payment = $this->_getPaymentData($payment_id);
		$downloadObject = $this->_getDownloadLinkObject($download_id);
		if(!$downloadObject)
			return;
		$text = $this->_doEmailReplacements($text, $payment, $payer_email, $downloadlink, $downloadObject, $docname, $user_name);
		$subject = $this->_doEmailReplacements($subject, $payment, $payer_email, $downloadlink, $downloadObject, $docname, $user_name);
		$guest_subject = $this->_doEmailReplacements($guest_subject, $payment, $payer_email, $downloadlink, $downloadObject, $docname, $user_name);
		$guest_text = $this->_doEmailReplacements($guest_text, $payment, $payer_email, $downloadlink, $downloadObject, $docname, $user_name);
		$owner_subject = $this->_doEmailReplacements($owner_subject, $payment, $payer_email, $downloadlink, $downloadObject, $docname, $user_name);
		$owner_text = $this->_doEmailReplacements($owner_text, $payment, $payer_email, $downloadlink, $downloadObject, $docname, $user_name);
		$this->_updateDownloadLink($download_id, $guest_subject, $guest_text, $downloadlink);
		if($email)
		{
			$mail = JFactory::getMailer();
			$mail->setSubject($subject);
			$mail->setBody($text);
			$emails = explode(';', $email);
			$mail->clearAddresses();
			foreach($emails as $addr)
			{
				$mail->addRecipient($addr);
			}
			$mail->IsHTML(true);
			$joomla_config = new JConfig();
			$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
			$this->debug("sending email to $email");
			$mail->Send();
		}
			
		if($payer_email && $guest_text)
		{
			$mail = JFactory::getMailer();
			$mail->clearAddresses();
			$mail->setSubject($guest_subject);
			$mail->setBody($guest_text);
			$mail->addRecipient($payer_email);
			if($notify_email)
				$mail->addRecipient($notify_email);
			$mail->IsHTML(true);
			$joomla_config = new JConfig();
			$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
			$this->debug("sending email to $payer_email");
			$mail->Send();
		}
		$db = JFactory::getDBO();
		$db->setQuery("SELECT created_user_id FROM #__digitalmarketx_documents WHERE id = " . (int)$document_id);
		$created_user_id = $db->loadResult();
		if($created_user_id)
		{
			$owner = JFactory::getUser();
			if($owner)
			{
				$mail = JFactory::getMailer();
				$mail->clearAddresses();
				$mail->setSubject($owner_subject);
				$mail->setBody($owner_text);
				$mail->addRecipient($owner->email);
				$mail->IsHTML(true);
				$joomla_config = new JConfig();
				$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
				$this->debug("sending email to {$owner->email}");
				$mail->Send();
			}
		}
	}
	
	function _updateDownloadLink($download_id, $subject, $text, $download_link)
	{
		$download_id = (int)$download_id;
		$db = JFactory::getDBO();
		$subject = $db->escape($subject);
		$text = $db->escape($text);
		$download_link = $db->escape($download_link);
		$query = "UPDATE #__digitalmarketx_download_links 
			SET subject = '$subject', emailbody = '$text', download_link = '$download_link'
			WHERE download_id = " . $download_id;
		$this->debug("Executing update download link query $query");
		$db->setQuery($query);
		$db->query();
	}
	
	function _getDownloadLinkObject($download_id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT * FROM #__digitalmarketx_download_links WHERE download_id = " . (int)$download_id;
		$db->setQuery( $query );
		return $db->loadObject();
	}
	
	function _getPaymentData($payment_id)
	{
		$db = JFactory::getDBO();
		$query = 'SELECT 
			#__digitalmarketx_payments.amount, 
			#__digitalmarketx_payments.fee, 
			#__digitalmarketx_payments.tax, 
			#__digitalmarketx_payments.currency,
			#__digitalmarketx_payments.txn_id
			FROM #__digitalmarketx_payments 
			WHERE #__digitalmarketx_payments.payment_id = ' . (int)$payment_id;
		$db->setQuery($query);
		$result = $db->loadObject();
		return $result;
	}
	
	function _getUrlForDocument($document_id, $accesscode)
	{
		$url = "index.php?option=com_digitalmarketx&view=details&id=" . (int)$document_id;
		$url .= "&digitalmarketxaccesscode=" . urlencode($accesscode);
		return JUri::root() . $url;
	}
	
	function _getDocumentName($document_id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, title FROM #__digitalmarketx_documents WHERE id = " . (int)$document_id;
		$db->setQuery($query);
		$doc = $db->loadObject();
		if($doc)
			return $doc->title;
		else
			return "";
	}
	
	function _setDownloadLinkPayed($download_id, $payer_email, $user_id)
	{
		$download_id = (int)$download_id;
		$db = JFactory::getDBO();
		
		$params = JComponentHelper::getParams('com_digitalmarketx');
		
		$days = (int)$params->get('download_link_days', 100);
		$max_downloads = (int)$params->get('download_link_download_count', 10000);
		
		$payer_email = $db->escape($payer_email);
		
		if($download_id)
		{
			if($user_id)
				$user_id = (int)$user_id;
			else
				$user_id = "NULL";
			$now = new JDate();
			$now = $now->toSql();
			$now = $db->escape($now);
			$query = "UPDATE #__digitalmarketx_download_links 
				SET expiration_date = DATE_ADD('$now', INTERVAL $days DAY),
				payer_email = '$payer_email',
				user_id = $user_id,
				link_max_downloads = $max_downloads,
				paid = 1
				WHERE download_id = " . $download_id;
			$this->debug("execute query $query");
			$db->setQuery($query);
			$db->query();
			$query = "SELECT secret_word, random_value, item_id FROM #__digitalmarketx_download_links 
				WHERE download_id = " . $download_id;
			$this->debug("execute query $query");
			$db->setQuery($query);
			$downloadLink = $db->loadObject();
			if($downloadLink)
			{
				$hash = sha1($downloadLink->secret_word . $downloadLink->random_value);
				$accesscode .= $download_id . ":" . $hash . ":" . $downloadLink->random_value;
				$this->debug("accesscode $accesscode");
				return $accesscode;
			}
		}
		return "";
	}
	
	function _validatePrice($document_id, $download_id, $paid_price, $currency_code)
	{
		$db = JFactory::getDBO();
		$db->setQuery("SELECT price, currency FROM #__digitalmarketx_download_links WHERE download_id = " . (int)$download_id);
		$downloadlink = $db->loadObject();
		$price = 0;
		if($downloadlink == null || $downloadlink->price <= 0)
		{
			$db->setQuery("SELECT price, currency FROM #__digitalmarketx_documents WHERE id = " . (int)$document_id);
			$document = $db->loadObject();
			if($document)
			{
				$price = $document->price;
				$currency = $document->currency;
			}
		}
		else
		{
			$price = $downloadlink->price;
			$currency = $downloadlink->currency;
		}
		return ($price >= 0.0 && (float)$paid_price - $price >= 0.00 && trim(strtoupper($currency)) == trim(strtoupper($currency_code)));
	}
	
	function _isTransactionPayed($txn_id)
	{
		$db = JFactory::getDBO();
		$txn_id = $db->escape($txn_id);
		$query = "SELECT payment_id FROM #__digitalmarketx_payments WHERE txn_id = '$txn_id' AND paid = 1";
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	function _validatePayment($req, $test, $paymentConfig)
	{
		if ($test) 
		{
			$root = JURI::root();
			if($paymentConfig->use_simulator)
				return "VERIFIED";
			else
				$paypal = "https://www.sandbox.paypal.com/cgi-bin/webscr'";
		}
		else 
		{
			$paypal = "https://www.paypal.com/cgi-bin/webscr'";
		}
	
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_URL, $paypal);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $req);

		ob_start();
		curl_exec($ch);
		$res = ob_get_contents();
		curl_close($ch);
		ob_end_clean();
		
		return $res;
	}
	
	function _getDocumentFromDownloadLink($download_id)
	{
		$download_id = (int)$download_id;
		$db = JFactory::getDBO();
		$query = "SELECT item_id FROM #__digitalmarketx_download_links WHERE download_id = " . $download_id;
		$db->setQuery( $query );
		return (int)$db->loadResult();
	}
	
	function _doEmailReplacements($text, $payment, $payer_email = "", 
		$downloadlink = "", $downloadObject = null, $doc_name = "",
		$username = "")
	{
		if($payment)
		{
			$text = preg_replace("/{amount}/", $payment->amount, $text);
			$text = preg_replace("/{fee}/", $payment->fee, $text);
			$text = preg_replace("/{tax}/", $payment->tax, $text);
			$text = preg_replace("/{currency}/", $payment->currency, $text);
			$text = preg_replace("/{transaction}/", $payment->txn_id, $text);
			$text = preg_replace("/{payer_email}/", $payer_email, $text);
			$text = preg_replace("/{download_link}/", $downloadlink, $text);
		}
		$text = preg_replace("/{document}/", $doc_name, $text);
		if($downloadObject)
		{
			$max_downloads = $downloadObject->link_max_downloads;
			$expiration_date = $downloadObject->expiration_date;
		}
		if($max_downloads == 0)
			$text = preg_replace("/{max_downloads}/", JText::_("COM_DIGITALMARKETX_UNLIMITED_DOWNLOADS"), $text);
		else if($max_downloads > 0)
			$text = preg_replace("/{max_downloads}/", $max_downloads, $text);
		else
			$text = preg_replace("/{max_downloads}/", "", $text);
		$text = preg_replace("/{expiration_date}/", $expiration_date, $text);
		$text = preg_replace("/{user}/", $username, $text);
		return $text;
	}
	
	function _getEmailConfig()
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$config = new stdclass();
		$config->notification_email = $params->get('notification_email');
		$config->notification_subject = $params->get('notification_subject');
		$config->notificationbody = $params->get('notificationbody');
		$config->client_notification_subject = $params->get('client_notification_subject');
		$config->client_notificationbody = $params->get('client_notificationbody');
		$config->owner_notification_subject = $params->get('file_bought_subject');
		$config->owner_notificationbody = $params->get('file_bought_body');
		return $config;
	}
	
}
