<?php

/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
defined('_JEXEC') or die;

/**
 * Methods supporting a list of DigitalMarketX records.
 */
class DigitalMarketXModelPayCart extends JModelLegacy {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        parent::__construct($config);
    }

	public function getPaymentConfig()
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$config = new stdclass();
		$config->paypalaccount = $params->get('paypalaccount', '');
		$config->testmode = $params->get('testmode', 1);
		$config->use_simulator = $params->get('use_simulator', 1);
		return $config;
	}
	
	function debug($text)
	{
		/*$db = JFactory::getDBO();
		$text = $db->escape($text);
		$query = "INSERT INTO debug(text, time) VALUES('$text', NOW())";
		$db->setQuery( $query );
		$db->query();*/
	}
	
	function getCart($cart_id = 0)
	{
		if($cart_id == 0)
			$cart_id = JRequest::getInt('id');
		$db = JFactory::getDBO();
		$query = "SELECT * FROM #__digitalmarketx_shopping_carts WHERE shoppingcart_id = " . (int)$cart_id;
		$db->setQuery( $query );
		return $db->loadObject();
	}
	
	function handleResponse()
	{
		$this->debug("handle response");
		$paymentConfig = $this->getPaymentConfig();
		$receiver_email = JRequest::getVar('receiver_email');
		$business = JRequest::getVar('business');
		if(trim(strtoupper($paymentConfig->paypalaccount)) != trim(strtoupper($receiver_email)) && 
			trim(strtoupper($paymentConfig->paypalaccount)) != trim(strtoupper($business)))
		{
			$this->debug("paypal account not set up");
			return;
		}
		$req = 'cmd=_notify-validate';
		$text = "";
		foreach ($_POST as $key => $value)
		{
			$save_value = JRequest::getVar($key);
			$text .= "(" . $key . " = " . $save_value . ")\r\n";
			$req .= "&" . $key . "=" . urlencode($save_value);
		}
		$payer_email = JRequest::getVar('payer_email');
		$db = JFactory::getDBO();
		$txn_id = JRequest::getVar('txn_id');
		$paid = false;
		if(!$this->_isTransactionPayed($txn_id))
		{
			$validate_response = $this->_validatePayment($req, JRequest::getInt('test_ipn', 0), $paymentConfig);
			$paid = (strcmp ($validate_response, "VERIFIED") == 0) ? 1 : 0;
			$this->debug("validate_response " . $validate_response);
		}
		else
		{
			$this->debug("trans not paid");
			return;
		}
		$etxn_id = $db->escape($txn_id);
		$notify_email = "";
		$text = $db->escape($text);
		$validate_response = $db->escape($validate_response);
		$cart_id = JRequest::getInt('item_number');
		$status = '';
		$paid_price = 0;
		if($paid)
		{
			$paid_price = JRequest::getFloat('mc_gross');
			$currency_code = JRequest::getVar('mc_currency');
			$paid = $this->_validatePrice($cart_id, $paid_price, $currency_code) ? 1 : 0;
			if($paid)
			{
				$status = trim(strtoupper(JRequest::getVar('payment_status')));
				$paid = ($status == 'COMPLETED') ? 1 : 0;
			}
		}
		$cart = $this->getCart($cart_id);
		$user_id = 0;
		if($cart)
			$user_id = (int)$cart->user_id;
		$status = $db->escape($status);
		$amount = JRequest::getFloat('mc_gross');
		$fee = JRequest::getFloat('mc_fee', 0);
		$tax = JRequest::getFloat('tax');
		$fee_percent = ($fee / $amount) * 100.0;
		$mc_currency = $db->escape(JRequest::getVar('mc_currency'));
		$esc_receiver_email = $db->escape($receiver_email);
		$esc_user_email = $db->escape($payer_email);
		if($user_id)
		{
			$user = $user_id;
			$userObj = JFactory::getUser($user_id);
			$user_name = $userObj->name;
		}
		else
		{
			$user = "NULL";
			$user_name = "Guest";
		}
		$query = "INSERT INTO 
			#__digitalmarketx_payments(user_id, user_email, item_id, paid, payment_date, txn_id, response, validate_response, status, amount, tax, fee, currency, receiver_email)
			VALUES($user, '$esc_user_email', $cart_id, $paid, NOW(), '$etxn_id', '$text', '$validate_response', '$status', '$amount', '$tax', '$fee', '$mc_currency', '$esc_receiver_email')";
		$db->setQuery( $query );
		$query_result = $db->query();
		$payment_id = $db->insertid();
		if($paid)
		{	
			$this->debug("payment " . $payment_id);
			$accesscode = $this->_setCartPaid($cart_id, $payer_email, $user_id, $fee_percent);
			$this->_notifyAdmin($amount, $fee, $tax, $txn_id, $payer_email,
				$currency_code, $user_id);
			$this->_notifySellers($cart_id);
			$this->_notifyBuyer($cart_id, $user_id);
		}
	}
	
	private function _notifyAdmin($amount, $fee, $tax, 
		$transaction, $payer_email, 
		$currency, $user_id)
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$notification_email = $params->get('notification_email', '');
		$notification_subject = $params->get('notification_subject');
		$notificationbody = $params->get('notificationbody');
		if($notification_email)
		{
			$user_name = JFactory::getUser($user_id)->name;
			$subject = $this->_doAdminEmailReplacements(
				$notification_subject, $amount, $fee, $tax, 
				$transaction, $payer_email, $currency, $user_name);
			$text = $this->_doAdminEmailReplacements(
				$notificationbody, $amount, $fee, $tax, 
				$transaction, $payer_email, $currency, $user_name);
				
			$mail = JFactory::getMailer();
			$mail->setSubject($subject);
			$mail->setBody($text);
			$emails = explode(';', $notification_email);
			$mail->clearAddresses();
			foreach($emails as $addr)
			{
				$mail->addRecipient($addr);
			}
			$mail->IsHTML(true);
			$joomla_config = new JConfig();
			$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
			$this->debug("sending email $subject to $notification_email");
			$mail->send();
		}
	}
	
	private function _notifySellers($cart_id)
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$subject = $params->get('file_bought_subject');
		$body = $params->get('file_bought_body');
		$cart_id = (int)$cart_id;
		$db = JFactory::getDBO();
		$query = $db->getQuery( true );
		$query->select('cart_items.item_id, cart_items.price, cart_items.currency');
		$query->select('docs.title, docs.created_user_id');
		$query->from('#__digitalmarketx_shopping_cart_item AS cart_items');
		$query->join('LEFT', '#__digitalmarketx_documents AS docs ON cart_items.item_id = docs.id');
		$query->where('cart_items.shoppingcart_id = ' . $cart_id);
		$db->setQuery( $query );
		$items = $db->loadObjectList();
		foreach($items as $item)
		{
			if($item->created_user_id)
			{
				$email = JFactory::getUser($item->created_user_id)->email;
				$subject = $this->_doSellerEmailReplacements($subject, 
					$item->price, $item->currency, $item->title);
				$body = $this->_doSellerEmailReplacements($body, 
					$item->price, $item->currency, $item->title);
				$mail = JFactory::getMailer();
				$mail->setSubject($subject);
				$mail->setBody($text);
				$mail->addRecipient($email);
				$mail->IsHTML(true);
				$joomla_config = new JConfig();
				$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
				$this->debug("sending email $subject to $email");
				$mail->send();
			}
		}
	}
	
	private function _notifyBuyer($cart_id, $user_id)
	{
		$email = JFactory::getUser($user_id)->email;
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$subject = $params->get('cart_paid_subject');
		$text = $params->get('cart_paid_body');
		$url = JUri::root() . "index.php?option=com_digitalmarketx&view=purchaseditems";
		$subject = $this->_doBuyerEmailReplacements($subject, $url);
		$text = $this->_doBuyerEmailReplacements($text, $url);
		$mail = JFactory::getMailer();
		$mail->setSubject($subject);
		$mail->setBody($text);
		$mail->addRecipient($email);
		$mail->IsHTML(true);
		$joomla_config = new JConfig();
		$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
		$this->debug("sending email $subject to $email");
		$mail->send();
	}
	
	private function _doBuyerEmailReplacements($text, $url)
	{
		$text = preg_replace("/{items_url}/", $url, $text);
		return $text;
	}
	
	private function _doSellerEmailReplacements($text, $amount, $currency, $document)
	{
		$text = preg_replace("/{price}/", $amount, $text);
		$text = preg_replace("/{currency}/", $currency, $text);
		$text = preg_replace("/{document}/", $document, $text);
		return $text;
	}
	
	private function _doAdminEmailReplacements($text, $amount, $fee, $tax, 
		$transaction, $payer_email, 
		$currency, $user_name)
	{
		$text = preg_replace("/{amount}/", $amount, $text);
		$text = preg_replace("/{fee}/", $fee, $text);
		$text = preg_replace("/{tax}/", $tax, $text);
		$text = preg_replace("/{currency}/", $currency, $text);
		$text = preg_replace("/{transaction}/", $transaction, $text);
		$text = preg_replace("/{payer_email}/", $payer_email, $text);
		$text = preg_replace("/{user}/", $user_name, $text);
		return $text;
	}
	
	private function _setCartPaid($cart_id, $payer_email, $user_id, $fee_percent)
	{
		$cart_id = (int)$cart_id;
		$db = JFactory::getDBO();
		//start transaction
		/*$db->setQuery("START TRANSACTION");
		$db->query();*/
		//set cart as paid
		$query = $db->getQuery( true );
		$query->update('#__digitalmarketx_shopping_carts');
		$query->set(array('paid=1', 'time_checkedout=NOW()'));
		$query->where('shoppingcart_id=' . $cart_id);
		$this->debug( "query : " . $query);
		$db->setQuery( $query );
		$db->query();
		$query->clear();
		//Get random values for download links
		$secret_word = $this->getRandom($cart_id . $cart_id);
		$random_value = $this->getRandom($cart_id);
		$hash = sha1($secret_word . $random_value);
		$e_secret_word = $db->escape($secret_word);
		$e_random_value = $db->escape($random_value);
		$payer_email = $db->escape($payer_email);
		//get items of cart to create download links
		$query->select('item_id, price, currency');
		$query->from('#__digitalmarketx_shopping_cart_item');
		$query->where('shoppingcart_id = ' . $cart_id);
		$db->setQuery( $query );
		$items = $db->loadObjectList();
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$days = (int)$params->get('download_link_days', 100);
		$max_downloads = (int)$params->get('download_link_download_count', 10000);
		$now = new JDate();
		$now = $now->toSql();
		$now = $db->escape($now);
		foreach($items as $item)
		{
			$price = (float)$item->price;
			$currency = $db->escape($item->currency);
			$query->clear();
			$query->insert('#__digitalmarketx_download_links', 'download_id');
			$query->columns('item_id, secret_word, random_value, download_link, user_ip');
			$query->columns('payer_email, expiration_date, creation_date, link_max_downloads');
			$query->columns('price, currency, user_id, paid');
			$query->values((int)$item->item_id . ", '$e_secret_word', '$e_random_value', 
				'', '', '$payer_email', 
				DATE_ADD('$now', INTERVAL $days DAY), '$now', $max_downloads, $price,
				'$currency', $user_id, 1");
			$this->debug( "query : " . $query);
			$db->setQuery( $query );
			$db->query();
			$download_link_id = (int)$db->insertId();
			$accesscode = $download_link_id . ":" . $hash . ":" . $random_value;
			$url = $this->_getUrlForDocument($item->item_id, $accesscode);
			$url = $db->escape($url);
			$query->clear();
			$query->update('#__digitalmarketx_download_links');
			$query->set("download_link='$url'");
			$query->where('download_id=' . (int)$download_link_id);
			$this->debug( "query : " . $query);
			$db->setQuery( $query );
			$db->query();
			$this->_updateUserBalance($item->item_id, $fee_percent, $user_id);
		}
		$query->clear();
		/*$db->setQuery("COMMIT TRANSACTION");
		$db->query();*/
		$accesscode = $cart_id . ":" . $hash . ":" . $random_value;
		return $accesscode;
	}
	
	function _saveSaleStat($document_id, $buyer_id, $amount, $currency)
	{
		$document_id = (int)$document_id;
		$buyer_id = (int)$buyer_id;
		$amount = (float)$amount;
		$date = new JDate();
		$date = $date->toSql();
		$db = JFactory::getDBO();
		$date = $db->escape($date);
		$currency = $db->escape($currency);
		$query = "INSERT INTO #__digitalmarketx_documents_sales
			(doc_id, buyer_id, amount, purchase_time, currency)
			VALUES($document_id, $buyer_id, $amount, '$date', '$currency')";
		$db->setQuery( $query );
		$db->query();
	}
	
	function _updateUserBalance($document_id, $fee_percent, $buyer_id = 0)
	{
		$db = JFactory::getDBO();
		$db->setQuery("SELECT price, currency, created_user_id FROM #__digitalmarketx_documents WHERE id = " . (int)$document_id);
		$document = $db->loadObject();
		if($document->created_user_id)
		{
			$params = JComponentHelper::getParams('com_digitalmarketx');
			$managerpercent = (float)$params->get('managerpercent', 10.0);
			$price = (float)$document->price;
			$fee_to_apply = (float)($price * $fee_percent) / 100.0;
			$price = $price - $fee_to_apply;
			$amount = (float)($price * (100.0 - $managerpercent)) / 100.0;
			$currency = $db->escape($document->currency);
			$db->setQuery("SELECT money_id FROM #__digitalmarketx_users_money WHERE currency = '$currency' AND userid = " . (int)$document->created_user_id);
			$money_id = (int)$db->loadResult();
			if($money_id)
			{
				$query = "UPDATE #__digitalmarketx_users_money SET balance = balance + $amount WHERE money_id = $money_id";
			}
			else
			{
				$query = "INSERT INTO #__digitalmarketx_users_money(userid, balance, currency) VALUES(" .  
					(int)$document->created_user_id . ", $amount, '$currency')";
			}
			$db->setQuery( $query );
			$db->query();
			$this->_saveSaleStat($document_id, $buyer_id, $amount, $document->currency);
		}
	}
	
	function _getUrlForDocument($document_id, $accesscode)
	{
		$url = "index.php?option=com_digitalmarketx&view=details&id=" . (int)$document_id;
		$url .= "&digitalmarketxaccesscode=" . urlencode($accesscode);
		return JUri::root() . $url;
	}
	
	function _getPaymentData($payment_id)
	{
		$db = JFactory::getDBO();
		$query = 'SELECT 
			#__digitalmarketx_payments.amount, 
			#__digitalmarketx_payments.fee, 
			#__digitalmarketx_payments.tax, 
			#__digitalmarketx_payments.currency,
			#__digitalmarketx_payments.txn_id
			FROM #__digitalmarketx_payments 
			WHERE #__digitalmarketx_payments.payment_id = ' . (int)$payment_id;
		$db->setQuery($query);
		$result = $db->loadObject();
		return $result;
	}
	
	
	function _validatePrice($cart_id, $paid_price, $currency_code)
	{
		$db = JFactory::getDBO();
		$db->setQuery("SELECT total, currency FROM #__digitalmarketx_shopping_carts WHERE shoppingcart_id = " . (int)$cart_id);
		$cart = $db->loadObject();
		if($cart)
		{
			$price = $cart->total;
			$currency = $cart->currency;
			return ($price >= 0.0 && (float)$paid_price - $price >= 0.00 && trim(strtoupper($currency)) == trim(strtoupper($currency_code)));
		}
		else
			return false;
	}
	
	function _isTransactionPayed($txn_id)
	{
		$db = JFactory::getDBO();
		$txn_id = $db->escape($txn_id);
		$query = "SELECT payment_id FROM #__digitalmarketx_payments WHERE txn_id = '$txn_id' AND paid = 1";
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	function _validatePayment($req, $test, $paymentConfig)
	{
		if ($test) 
		{
			$root = JURI::root();
			if($paymentConfig->use_simulator)
				return "VERIFIED";
			else
				$paypal = "https://www.sandbox.paypal.com/cgi-bin/webscr'";
		}
		else 
		{
			$paypal = "https://www.paypal.com/cgi-bin/webscr'";
		}
	
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_URL, $paypal);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $req);

		ob_start();
		curl_exec($ch);
		$res = ob_get_contents();
		curl_close($ch);
		ob_end_clean();
		
		return $res;
	}
	
	function _getDocumentFromDownloadLink($download_id)
	{
		$download_id = (int)$download_id;
		$db = JFactory::getDBO();
		$query = "SELECT item_id FROM #__digitalmarketx_download_links WHERE download_id = " . $download_id;
		$db->setQuery( $query );
		return (int)$db->loadResult();
	}
	
	function _doEmailReplacements($text, $payment, $payer_email = "", 
		$downloadlink = "", $downloadObject = null, $doc_name = "",
		$username = "")
	{
		if($payment)
		{
			$text = preg_replace("/{amount}/", $payment->amount, $text);
			$text = preg_replace("/{fee}/", $payment->fee, $text);
			$text = preg_replace("/{tax}/", $payment->tax, $text);
			$text = preg_replace("/{currency}/", $payment->currency, $text);
			$text = preg_replace("/{transaction}/", $payment->txn_id, $text);
			$text = preg_replace("/{payer_email}/", $payer_email, $text);
			$text = preg_replace("/{download_link}/", $downloadlink, $text);
		}
		$text = preg_replace("/{document}/", $doc_name, $text);
		if($downloadObject)
		{
			$max_downloads = $downloadObject->link_max_downloads;
			$expiration_date = $downloadObject->expiration_date;
		}
		if($max_downloads == 0)
			$text = preg_replace("/{max_downloads}/", JText::_("COM_DIGITALMARKETX_UNLIMITED_DOWNLOADS"), $text);
		else if($max_downloads > 0)
			$text = preg_replace("/{max_downloads}/", $max_downloads, $text);
		else
			$text = preg_replace("/{max_downloads}/", "", $text);
		$text = preg_replace("/{expiration_date}/", $expiration_date, $text);
		$text = preg_replace("/{user}/", $username, $text);
		return $text;
	}
	
	function _getEmailConfig()
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$config = new stdclass();
		$config->notification_email = $params->get('notification_email');
		$config->notification_subject = $params->get('notification_subject');
		$config->notificationbody = $params->get('notificationbody');
		$config->client_notification_subject = $params->get('client_notification_subject');
		$config->client_notificationbody = $params->get('client_notificationbody');
		return $config;
	}
	
	function getRandom($seed)
	{
		$config = JFactory::getConfig();
		$secret = "";
		$version = new JVersion();
		if($config)
		{
			if($version->RELEASE < "3.0")
				$secret .= $config->getValue( 'config.secret' ) . $config->getValue( 'config.password' );
			else
				$secret .= $config->get( 'config.secret' ) . $config->get( 'config.password' );
		}
		$rand = $seed;
		for($i = 0; $i < 100; $i++)
		{
			$rand .= microtime() . $secret;
			$rand = sha1($rand);
		}
		return $rand;
	}
	
}
