<?php

/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of DigitalMarketX records.
 */
class DigitalMarketXModelPaydebt extends JModelLegacy {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        parent::__construct($config);
    }

	function debug($text)
	{
		/*$db = JFactory::getDBO();
		$text = $db->escape($text);
		$query = "INSERT INTO debug(text, time) VALUES('$text', NOW())";
		$db->setQuery( $query );
		$db->query();*/
	}
	
	public function getPaymentConfig()
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$config = new stdclass();
		$config->paypalaccount = $params->get('paypalaccount', '');
		$config->testmode = $params->get('testmode', 1);
		$config->use_simulator = $params->get('use_simulator', 1);
		return $config;
	}
	
	function handleResponse()
	{
		$paymentConfig = $this->getPaymentConfig();
		$receiver_email = JRequest::getVar('receiver_email');
		$business = JRequest::getVar('business');
		$req = 'cmd=_notify-validate';
		$text = "";
		foreach ($_POST as $key => $value)
		{
			$save_value = JRequest::getVar($key);
			$text .= "(" . $key . " = " . $save_value . ")\r\n";
			$req .= "&" . $key . "=" . urlencode($save_value);
		}
		$payer_email = JRequest::getVar('payer_email');
		$db = JFactory::getDBO();
		$txn_id = JRequest::getVar('txn_id');
		$paid = false;
		if(!$this->_isTransactionPayed($txn_id))
		{
			$validate_response = $this->_validatePayment($req, JRequest::getInt('test_ipn', 0), $paymentConfig);
			$paid = (strcmp ($validate_response, "VERIFIED") == 0) ? 1 : 0;
			$this->debug("validate_response " . $validate_response);
		}
		else
		{
			$this->debug("trans already paid");
			return;
		}
		$txn_id = $db->escape($txn_id);
		$notify_email = "";
		$text = $db->escape($text);
		$validate_response = $db->escape($validate_response);
		$money_id = JRequest::getInt('custom');
		$user_id = JRequest::getInt('item_number');
		$status = '';
		$paid_price = JRequest::getFloat('mc_gross');
		$currency_code = JRequest::getVar('mc_currency');
		$money_currency = null;
		if($paid)
		{
			$money_currency = $this->_getMoneyCurrency($money_id);
			$paid = $money_currency != null && $money_currency->currency == $currency_code;
			if($paid)
			{
				$status = trim(strtoupper(JRequest::getVar('payment_status')));
				$paid = ($status == 'COMPLETED') ? 1 : 0;
			}
		}
		$status = $db->escape($status);
		$amount = JRequest::getFloat('mc_gross');
		$amountPaid = -$amount;
		$fee = JRequest::getFloat('mc_fee', 0);
		$tax = JRequest::getFloat('tax');
		$mc_currency = $db->escape(JRequest::getVar('mc_currency'));
		$esc_receiver_email = $db->escape($receiver_email);
		$esc_user_email = $db->escape($payer_email);
		$query = "INSERT INTO 
			#__digitalmarketx_payments(user_id, user_email, item_id, paid, payment_date, txn_id, response, validate_response, status, amount, tax, fee, currency, receiver_email)
			VALUES($user_id, '$esc_user_email', NULL, $paid, NOW(), '$txn_id', '$text', '$validate_response', '$status', '$amountPaid', '$tax', '$fee', '$mc_currency', '$esc_receiver_email')";
		$db->setQuery( $query );
		$query_result = $db->query();
		$payment_id = $db->insertid();
		if($paid)
		{	
			$this->debug("payment " . $payment_id);
			$this->_updateUserBalance( $money_currency, $amount ); 
		}
	}
	
	function _updateUserBalance($money_currency, $amount)
	{
		if($money_currency == null)
			return false;
		$db = JFactory::getDBO();
		$amount = (float)$amount;
		$claimed = (float)$money_currency->claimed;
		$new_claimed = $claimed - $amount;
		if($new_claimed < 0)
			$new_claimed = 0;
		$money_id = (int)$money_currency->money_id;
		$query = "UPDATE #__digitalmarketx_users_money SET claimed = $new_claimed WHERE money_id = $money_id";
		$db->setQuery( $query );
		$result = $db->query();
		$query = "DELETE FROM #__digitalmarketx_users_money WHERE claimed = 0 AND balance = 0";
		$db->setQuery( $query );
		$db->query();
		return $result ;
	}
	
	function _isTransactionPayed($txn_id)
	{
		$db = JFactory::getDBO();
		$txn_id = $db->escape($txn_id);
		$query = "SELECT payment_id FROM #__digitalmarketx_payments WHERE txn_id = '$txn_id' AND paid = 1";
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	function _validatePayment($req, $test, $paymentConfig)
	{
		if ($test) 
		{
			$root = JURI::root();
			if($paymentConfig->use_simulator)
				return "VERIFIED";
			else
				$paypal = "https://www.sandbox.paypal.com/cgi-bin/webscr'";
		}
		else 
		{
			$paypal = "https://www.paypal.com/cgi-bin/webscr'";
		}
	
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_URL, $paypal);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $req);

		ob_start();
		curl_exec($ch);
		$res = ob_get_contents();
		curl_close($ch);
		ob_end_clean();
		
		return $res;
	}
	
	function _getMoneyCurrency($money_id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT money_id, claimed, currency FROM #__digitalmarketx_users_money WHERE money_id = " . (int)$money_id;
		$db->setQuery( $query );
		return $db->loadObject();
	}
}
