<?php

/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

class DigitalMarketXModelProfile extends JModelList {
	function getCurrentUserProfile()
	{
		$user = JFactory::getUser();
		if($user->id)
		{
			$db = JFactory::getDBO();
			$query = "SELECT * FROM #__digitalmarketx_users WHERE userid = " . (int)$user->id;
			$db->setQuery( $query );
			return $db->loadObject();
		}
		return null;
	}
	
	function getCurrentUserMoney()
	{
		$user = JFactory::getUser();
		if($user->id)
		{
			$db = JFactory::getDBO();
			$query = "SELECT * FROM #__digitalmarketx_users_money WHERE userid = " . (int)$user->id;
			$db->setQuery( $query );
			return $db->loadObjectList();
		}
		return null;
	}
	
	function saveProfile($userid, $paypalAccount)
	{
		$userid = (int)$userid;
		$db = JFactory::getDBO();
		$regex = "/\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/";
		if(preg_match($regex, $paypalAccount))
		{
			$paypalAccount = $db->escape($paypalAccount);
			$query = "SELECT userid FROM #__digitalmarketx_users WHERE userid = $userid";
			$db->setQuery( $query );
			$result = $db->loadResult();
			if($result)
				$query = "UPDATE #__digitalmarketx_users SET paypalaccount = '$paypalAccount' WHERE userid = $userid";
			else
				$query = "INSERT INTO #__digitalmarketx_users(userid, paypalaccount) VALUES($userid, '$paypalAccount')";
			$db->setQuery( $query );
			return $db->query();
		}
		else
		{
			$this->setError(JText::_("COM_DIGITALMARKET_PAYPALACCOUNT_NOT_VALID"));
			return false;
		}
	}
	
	function getCurrency($moneyCurrencyId)
	{
		$moneyCurrencyId = (int)$moneyCurrencyId;
		$db =& JFactory::getDBO();
		$query = "SELECT currency FROM #__digitalmarketx_users_money WHERE money_id = " . $moneyCurrencyId;
		$db->setQuery( $query );
		$currency = $db->loadResult();
		return $currency;
	}
	
	function claimMoney($moneyCurrencyId, $amount)
	{
		$user = JFactory::getUser();
		if(!$user->id)
		{
			$this->setError(JText::_("COM_DIGITALMARKET_LOGIN_TO_CLAIM_MONEY"));
			return false;
		}
		$userid = (int)$user->id;
		$db = JFactory::getDBO();
		$query = "SELECT paypalaccount FROM #__digitalmarketx_users WHERE  userid = $userid";
		$db->setQuery( $query );
		$paypalAccount = $db->loadResult();
		$regex = "/\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/";
		if(!preg_match($regex, $paypalAccount))
		{
			$this->setError(JText::_("COM_DIGITALMARKETX_SPECIFY_ACCOUNT_TO_CLAIM_MONEY"));
			return false;
		}
		
		$moneyCurrencyId = (int)$moneyCurrencyId;
		$query = "SELECT COUNT(*) FROM #__digitalmarketx_users_money 
			WHERE userid = $userid AND money_id = $moneyCurrencyId";
		$db->setQuery( $query );
		$count = $db->loadResult();
		if($count == 0)
			return false;
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$min_days_to_reclaim = (int)$params->get('daystoreclaim', 30);
		$min_amount_to_reclaim = (float)$params->get('minreclaim', 20.00);
		$max_amount_to_reclaim = (float)$params->get('maxreclaim', 1000.00);
		$amount = (float)$amount;
		$query = "SELECT balance FROM #__digitalmarketx_users_money WHERE money_id = $moneyCurrencyId";
		$db->setQuery( $query );
		$balance = (float)$db->loadResult();
		if($balance < $amount)
		{
			$this->setError(JText::_("COM_DIGITALMARKET_TOO_MUCH_TO_CLAIM"));
			return false;
		}else if($amount > $max_amount_to_reclaim)
		{
			$this->setError(JText::_("COM_DIGITALMARKET_TOO_HIGH_TO_CLAIM"));
			return false;
		}
		else if($amount < $min_amount_to_reclaim)
		{
			$this->setError(JText::_("COM_DIGITALMARKET_TOO_LOW_TO_CLAIM"));
			return false;
		}
		else if(!$this->canUserReclaimNow($min_days_to_reclaim))
		{
			$this->setError(JText::_("COM_DIGITALMARKET_TOO_EARLY_TO_CLAIM"));
			return false;
		}
		else
		{
			$query = "UPDATE #__digitalmarketx_users_money 
				SET balance = balance - $amount, claimed = claimed + $amount
				WHERE money_id = $moneyCurrencyId";
			$db->setQuery( $query );
			$result = $db->query();
			$query = "UPDATE #__digitalmarketx_users SET last_time_claimed = NOW() WHERE userid = $userid";
			$db->setQuery( $query );
			$db->query();
			require_once(JPATH_ADMINISTRATOR . DS . "components" . DS . "com_digitalmarketx" . DS . "helpers" . DS .  "digitalmarketx.php");
			DigitalMarketXHelper::notifyClaim($moneyCurrencyId, $amount);
			return $result;
		}
	}
	
	function canUserReclaimNow($min_days_to_reclaim)
	{
		$user = JFactory::getUser();
		if(!$user->id)
			return;
		$db = JFactory::getDBO();
		$query = "SELECT userid, last_time_claimed, 
			(DATE_ADD(last_time_claimed, INTERVAL $min_days_to_reclaim DAY) < NOW()) AS can_reclaim_now
			FROM #__digitalmarketx_users WHERE userid = " . (int)$user->id;
		$db->setQuery( $query );
		$userProfile = $db->loadObject();
		if(!$userProfile || !$userProfile->last_time_claimed)
			$canReclaim = true;
		else
			$canReclaim = $userProfile->can_reclaim_now;
		return $canReclaim;
	}
	
	function setReclaimingOptions($money, $params)
	{
		$min_days_to_reclaim = (int)$params->get('daystoreclaim', 30);
		$min_amount_to_reclaim = (float)$params->get('minreclaim', 20.00);
		$canReclaim = $this->canUserReclaimNow($min_days_to_reclaim);
		foreach($money as $key => $currency)
		{
			$currency->canReclaim = $canReclaim && ($currency->balance >= $min_amount_to_reclaim);
		}
	}
	
	function getNextReclaimDate($min_days_to_reclaim)
	{
		$user = JFactory::getUser();
		if(!$user->id)
			return null;
		$db = JFactory::getDBO();
		$query = "SELECT userid, last_time_claimed, 
			DATE_ADD(last_time_claimed, INTERVAL $min_days_to_reclaim DAY) AS next_claim_date
			FROM #__digitalmarketx_users WHERE userid = " . (int)$user->id;
		$db->setQuery( $query );
		$userProfile = $db->loadObject();
		if(!$userProfile || !$userProfile->last_time_claimed)
			return null;
		else
			return $userProfile->next_claim_date;
	}
	
	public function getSalesStatsQuery()
	{
		$user = JFactory::getUser();
		$db = JFactory::getDBO();
		$query = $db->getQuery( true );
		$query->select('sales.id, sales.doc_id, sales.buyer_id, sales.amount, sales.purchase_time, sales.currency');
		$query->select('docs.title');
		$query->select('buyers.name');
		$query->from('#__digitalmarketx_documents_sales AS sales');
		$query->join('LEFT', '#__digitalmarketx_documents AS docs ON sales.doc_id = docs.id');
		$query->join('LEFT', '#__users AS buyers ON sales.buyer_id = buyers.id');
		$query->where('docs.created_user_id = ' . (int)$user->id);
		return $query;
	}
	
	public function getItems()
	{
		$db = JFactory::getDBO();
		$query = $this->getSalesStatsQuery();
		$db->setQuery( $query , 
			(int)$this->getStart(), 
			(int)$this->getState('list.limit'));
		return $db->loadObjectList();
	}
	
	public function getTotal()
	{
		$db = JFactory::getDBO();
		$query = $this->getSalesStatsQuery();
		$query->clear('select');
		$query->select('COUNT(*)');
		$db->setQuery( $query );
		return $db->loadResult();
	}
}

?>