<?php

/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of DigitalMarketX records.
 */
class DigitalMarketXModelSearch extends JModelList {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        parent::__construct($config);
    }

    /**
     * Method to auto-populate the model state.
     *
     * Note. Calling getState in this method will result in recursion.
     *
     * @since	1.6
     */
    protected function populateState($ordering = null, $direction = null) {
        
        // Initialise variables.
        $app = JFactory::getApplication();

        // List state information
        $limit = $app->getUserStateFromRequest('global.list.limit', 'limit', $app->getCfg('list_limit'));
        $this->setState('list.limit', $limit);

        $limitstart = $app->input->getInt('limitstart', 0);
        $this->setState('list.start', $limitstart);
		
		$searchtext = $app->getUserStateFromRequest('searchtext', 'searchtext', '');
		$category = (int)$app->getUserStateFromRequest('category', 'category', 0);
		$minprice = (float)$app->getUserStateFromRequest('minprice', 'minprice', 0);
		$maxprice = (float)$app->getUserStateFromRequest('maxprice', 'maxprice', 0);
		$minrating = (float)$app->getUserStateFromRequest('minrating', 'minrating', 0);
		$minvotes = (float)$app->getUserStateFromRequest('minvotes', 'minvotes', 0);
		$hasdemo = (int)$app->getUserStateFromRequest('hasdemo', 'hasdemo', 0);
		$hasthumbnail = (int)$app->getUserStateFromRequest('hasthumbnail', 'hasthumbnail', 0);
		$purchased = (int)$app->getUserStateFromRequest('purchased', 'purchased', 1);
		$myfiles = (int)$app->getUserStateFromRequest('myfiles', 'myfiles', 1);
		$sortby = $app->getUserStateFromRequest('sortby', 'sortby', 'title');
		$sorttype = $app->getUserStateFromRequest('sorttype', 'sorttype', 'asc');
		
		$this->setState('searchtext', $searchtext);
		$this->setState('category', $category);
		$this->setState('minprice', $minprice);
		$this->setState('maxprice', $maxprice);
		$this->setState('minrating', $minrating);
		$this->setState('minvotes', $minvotes);
		$this->setState('hasdemo', $hasdemo);
		$this->setState('hasthumbnail', $hasthumbnail);
		$this->setState('purchased', $purchased);
		$this->setState('myfiles', $myfiles);
		$this->setState('sortby', $sortby);
		$this->setState('sorttype', $sorttype);
                
        // List state information.
        parent::populateState($ordering, $direction);
    }
	
	public function getFilters()
	{
		$filter = new StdClass();
		$filter->searchtext = $this->getState('searchtext', '');
		$filter->category = $this->getState('category', 0);
		$filter->minprice = $this->getState('minprice', 0);
		$filter->maxprice = $this->getState('maxprice', 0);
		$filter->minrating = $this->getState('minrating', 0);
		$filter->minvotes = $this->getState('minvotes', 0);
		$filter->hasdemo = $this->getState('hasdemo', 0);
		$filter->hasthumbnail = $this->getState('hasthumbnail', 0);
		$filter->sortby = $this->getState('sortby', 'title');
		$filter->sorttype = $this->getState('sorttype', 'ASC');
		return $filter;
	}

    /**
	 * Build an SQL query to load the list data.
	 *
	 * @return	JDatabaseQuery
	 * @since	1.6
	 */
    protected function getListQuery() {
        // Create a new query object.
        $db = $this->getDbo();
		$myfiles = (int)$this->getState('myfiles', 1);
        $query = $db->getQuery(true);
        $query->select('docs.*, docs.rating_count >= 5 AS valid_rate, 
			#__users.id as owner_id, #__users.name as owner_name');
		$query->from('#__digitalmarketx_documents AS docs');
		$query->join('LEFT', '#__users ON docs.created_user_id = #__users.id');
		$user = JFactory::getUser();
		if(!$user->authorise('digitalmarketx.seeall', 'com_digitalmarketx'))
		{
			$visibleCond = "docs.state = 1";
			if($user->id && $myfiles)
				$visibleCond .= " OR (docs.state = 0 AND created_user_id = " . (int)$user->id . ")";
			$query->where("($visibleCond)");
		}
		$searchText = $this->getState('searchtext', '');
		if($searchText)
		{
			$searchText = $db->escape($searchText);
			$query->where("(docs.title LIKE '%$searchText%' OR docs.description LIKE '%$searchText%'
					OR docs.metatags LIKE '%$searchText%' OR docs.metadescription LIKE '%$searchText%' OR
					#__users.name LIKE '%$searchText%')");
		}
		$category = (int)$this->getState('category', 0);
		if($category)
		{
			$categories = array();
			$this->getSubcategories($categories, $category);
			$cats = implode(",", $categories);
			$query->where("docs.category IN ($cats)");
		}
		$minprice = (float)$this->getState('minprice', 0);
		if($minprice > 0)
		{
			$query->where("docs.price >= $minprice");
		}
		$maxprice = (float)$this->getState('maxprice', 0);
		if($maxprice > 0)
		{
			$query->where("docs.price <= $maxprice");
		}
		$minrating = (float)$this->getState('minrating', 0);
		if($minrating > 0)
		{
			$query->where("docs.rating >= $minrating");
		}
		$minvotes = (int)$this->getState('minvotes', 0);
		if($minvotes > 0)
		{
			$query->where("docs.rating_count >= $minvotes");
		}
		$hasdemo = (int)$this->getState('hasdemo', 0);
		if($hasdemo)
		{
			$query->where("docs.demo_file != '' AND docs.demo_file IS NOT NULL");
		}
		$hasthumbnail = (int)$this->getState('hasthumbnail', 0);
		if($hasthumbnail)
		{
			$query->where("docs.thumbnail != '' AND docs.thumbnail IS NOT NULL");
		}
		if(!$myfiles && $user->id)
		{
			$query->where('docs.created_user_id != ' . (int)$user->id);
		}
		$purchased = (int)$this->getState('purchased', 1);
		if(!$purchased && $user->id)
		{
			$query->where('docs.id NOT IN ( SELECT dl.item_id 
				FROM #__digitalmarketx_download_links AS dl 
				WHERE dl.user_id = ' . (int)$user->id . ')');
		}
		$sortby = $this->getState('sortby', 'title');
		$sorttype = $this->getState('sorttype', 'asc');
		switch($sortby)
		{
		case 'title':
			$sortby = 'docs.title';
			break;
		case 'price':
			$sortby = 'docs.price';
			break;
		case 'rating':
			$sortby = 'docs.rating';
			break;
		case 'votes':
			$sortby = 'docs.rating_count';
			break;
		default:
			$sortby = '';
		}
		if($sortby != '' && ($sorttype == 'asc' || $sorttype == 'desc'))
		{
			$query->order($sortby . " " . $sorttype);
		}
        return $query;
    }
	
	function getSubcategories(&$categories, $category)
	{
		$category = (int)$category;
		$db = JFactory::getDBO();
		$categories []= $category;
		$query = $db->getQuery( true );
		$query->select('id');
		$query->from('#__categories');
		$query->where("parent_id = $category");
		$db->setQuery( $query );
		$subcats = $db->loadColumn();
		if($subcats)
		{
			foreach($subcats as $subcat)
			{
				 $this->getSubcategories($categories, (int)$subcat);
			}
		}
	}
	
	public function getCategories()
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, parent_id, title FROM #__categories WHERE published = 1 AND extension='com_digitalmarketx'";
		$db->setQuery( $query );
		$cats = $db->loadObjectList();
		$cats_ordered = array();
		$this->reorderCats($cats_ordered, $cats, 1, 0);
		return $cats_ordered;
	}
	
	private function reorderCats(&$cats_ordered, $cats, $parent_id, $depth)
	{
		$count = count($cats);
		for($i = 0; $i < $count; $i++)
		{
			$cat = $cats[$i];
			if($cat->parent_id == $parent_id)
			{
				$cat->depth = $depth;
				$cats_ordered[] = $cat;
				$this->reorderCats($cats_ordered, $cats, $cat->id, $depth + 1);
			}
		}
	}
	
	public function canDownload($category)
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$restrict_download = $params->get('restrict_download', 0);
		if($restrict_download == 0)
			return true;
		if($category == 0)
			return true;
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.download', 'com_digitalmarketx.category.'.(int) $category);
	}
	
	public function canDownloadFree($category)
	{
		if($category == 0)
			return true;
		$user = JFactory::getUser();
		return $user->authorise('digitalmarketx.freedownload', 'com_digitalmarketx.category.'.(int) $category);
	}
	
	public function canEdit($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('core.edit', 'com_digitalmarketx.category.'.(int) $category);
	}
	
	public function canEditOwn($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('core.edit.own', 'com_digitalmarketx.category.'.(int) $category);
	}
	
	public function canReport($document, $user_id)
	{
		if($user_id && $document->created_user_id != $user_id)
		{
			$document_id = (int)$document->id;
			$user_id = (int)$user_id;
			$db = JFactory::getDBO();
			$query = "SELECT COUNT(*) FROM #__digitalmarketx_documents_reports
				WHERE doc_id = $document_id AND user_id = $user_id";
			$db->setQuery( $query );
			$result = $db->loadResult();
			return $result == 0;
		}
		return false;
	}
	
	
	public function getDocuments()
	{
		jimport('joomla.filesystem.file');
		$db = $this->getDbo();
		$db->setQuery( $this->getListQuery(), (int)$this->getStart(), (int)$this->getState('list.limit'));
		$documents = $db->loadObjectList();
		$user = JFactory::getUser();
		$open_cart = $this->getUserCar();
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$max_title_length = (int)$params->get('max_title_length', 20);
		if($documents)
		{
			$kb = 1024;
			$mega = 1024 * $kb;
			$giga = 1024 * $mega;
			foreach($documents as $document)
			{
				$document->isItemInCar = false;
				$canEdit = $this->canEdit($document->category);
				$canDownloadFree = $this->canDownloadFree($document->category);
				$canEditOwn = $this->canEditOwn($document->category);
				$canDownload = $this->canDownload($document->category);
				$document->canReport = $this->canReport($document, $user->id);
				$document->description = $this->cleanHtml($document->description);
				$document->cleanDemoText = trim($this->cleanHtml($document->demo_text));
				if(strlen($document->description) > 250)
					$document->description = substr($document->description, 0, 250) . "..";
				$document->description = preg_replace("/\n/", "<br/>", $document->description);
				$size = filesize(JPATH_ROOT . "/" . $document->attachment);
				if($size >= $giga)
				{
					$size = $size / $giga;
					$unit = JText::_("COM_DIGITALMARKETX_SIZE_GB");
				}
				else if($size >= $mega)
				{
					$size = $size / $mega;
					$unit = JText::_("COM_DIGITALMARKETX_SIZE_MB");
				}
				else if($size >= $kb)
				{
					$size = $size / $kb;
					$unit = JText::_("COM_DIGITALMARKETX_SIZE_KB");
				}
				else
				{
					$unit = JText::_("COM_DIGITALMARKETX_SIZE_BYTES");
				}
				if($max_title_length > 0 && strlen($document->title) > $max_title_length)
				{
					$document->title = substr($document->title, 0, $max_title_length) . "..";
				}
				$document->size = round($size, 2);
				$document->unit = $unit;
				$document->filename = $this->getFileName($document->attachment);
				if(JFile::exists(JPATH_ROOT . "/" . $document->thumbnail . "_small.jpg"))
					$document->small_thumbnail = $document->thumbnail . "_small.jpg";
				else
					$document->small_thumbnail = $document->thumbnail;
				$document->canEdit = $canEdit || ($canEditOwn && $user->id && $document->created_user_id == $user->id);
				$document->canDownload = $canDownload || ($user->id && $document->created_user_id == $user->id);
				if( $document->price < 0.000001 || $document->created_user_id == $user->id || $canDownloadFree)
				{
					$document->visible = true;
					$document->paid = true;
				}
				else
				{
					$downloadLink = $this->getDownloadLinkForDocument($document->id);
					$document->downloadLink = $downloadLink;
					if($downloadLink && $downloadLink->valid)
					{
						$document->visible = true;
						$document->paid = true;
					}
					else
					{
						$document->visible = true;
						$document->paid = false;
						$document->isItemInCar = $this->isItemInCar($document, $open_cart);
					}
				}
				if(!$user->authorise('digitalmarketx.seeall', 'com_digitalmarketx'))
					$document->visible = $this->hasUserAccess($document);
			}
		}
		return $documents;
	}
	
	private function getUserCar()
	{
		$user_id = (int)JFactory::getUser()->id;
		if($user_id == 0)
			return 0;
		$db = JFactory::getDBO();
		$query = "SELECT shoppingcart_id FROM #__digitalmarketx_shopping_carts
			WHERE paid = 0 AND in_process = 0 AND user_id = " . $user_id;
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	private function isItemInCar($document, $cart_id)
	{
		if($cart_id == 0)
			return false;
		$cart_id = (int)$cart_id;
		$item_id = (int)$document->id;
		$db = JFactory::getDBO();
		$query = "SELECT COUNT(*) FROM #__digitalmarketx_shopping_cart_item
			WHERE shoppingcart_id = $cart_id AND item_id = $item_id AND `count` > 0";
		$db->setQuery( $query );
		return $db->loadResult() > 0;
	}
	
	private function hasUserAccess($document)
	{
		$user = JFactory::getUser();
		if($user->id == $document->created_user_id)
			return true;
		$db = JFactory::getDBO();
		$query = "SELECT #__digitalmarketx_documents_users.user_id FROM #__digitalmarketx_documents_users 
			WHERE #__digitalmarketx_documents_users.doc_id = " . (int)$document->id;
		$db->setQuery( $query );
		$users = $db->loadColumn();
		if(count($users) == 0)
			return true;
		return array_search($user->id, $users) !== false;
	}
	
	public function cleanHtml($text)
	{
		$text = preg_replace("/<\/?[a-zA-Z0-9]+[^>]*>/", "", $text);
		$text = preg_replace("/&[a-zA-Z]{1,6};/", "", $text);
		return $text;
	}
	
	private function getFileName($attachment)
	{
		$pos = strrpos($attachment, "/");
		if($pos !== false)
			return substr($attachment, $pos + 1);
		else
			return $attachment;
	}
	
	private function getDownloadLinkForDocument($docId)
	{
		$db = JFactory::getDBO();
		$query = "SELECT download_id, item_id, user_id, paid, expiration_date, download_hits, link_max_downloads,
			(paid <> 0 AND expiration_date >= NOW() AND (download_hits = 0 OR download_hits <= link_max_downloads)) AS valid
			FROM #__digitalmarketx_download_links
			WHERE paid = 1 AND item_id = " . (int)$docId;
		$validationQuery = "";
		$user = JFactory::getUser();
		if($user->id)
		{
			$validationQuery .= "user_id = " . (int)$user->id;
		}
		$session = JFactory::getSession();
		$activeDownloads = $session->get("digitalmarketxactivedownloads", null);
		if($activeDownloads && count($activeDownloads) > 0)
		{
			if($validationQuery)
				$validationQuery .= " OR ";
			$active = implode(",", $activeDownloads);
			$validationQuery .= "download_id IN ($active)";
		}
		if($validationQuery)
			$query .= " AND ($validationQuery)";
		else 
			return null;
		$db->setQuery( $query );
		$downloadLink = $db->loadObject();
		return $downloadLink;
	}
	
	private function isAccessible($downloadLink)
	{
		if($downloadLink && $downloadLink->valid)
		{
			if($downloadLink->user_id)
			{
				$user = JFactory::getUser();
				if($user->id == $downloadLink->user_id)
					return true;
			}
			$session = JFactory::getSession();
			$activeDownloads = $session->get("digitalmarketxactivedownloads", null);
			if($activeDownloads && count($activeDownloads) > 0)
			{
				if(array_search($downloadLink->download_id, $activeDownloads) !== false)
					return true;
			}
		}
		return false;
	}
	
	function checkAccessCode($accessCode)
	{
		if(preg_match("/\\S+\\:\\S+\\:\\S+/", $accessCode))
		{
			list($download_id, $hash, $rand) = explode(":", $accessCode);
			$db = JFactory::getDBO();
			$download_id = (int)$download_id;
			$esc_rand = $db->escape($rand);
			$query = "SELECT * FROM #__digitalmarketx_download_links 
				WHERE download_id = $download_id AND random_value = '$esc_rand' AND
				(expiration_date IS NULL OR expiration_date >= NOW()) AND paid <> 0";
			$db->setQuery($query);
			$downloadlink = $db->loadObject();
			if($downloadlink)
			{
				$result = $hash == sha1($downloadlink->secret_word . $rand);
				if($result)
				{
					$session = JFactory::getSession();
					$activeDownloads = $session->get("digitalmarketxactivedownloads", array());
					if(array_search($download_id, $activeDownloads) === false)
					{
						$activeDownloads []= $download_id;
						$session->set("digitalmarketxactivedownloads", $activeDownloads);
					}
				}
			}
		}
	}
	
	public function getSortElements()
	{
		return array("title" => "COM_DIGITALMARKETX_ORDER_BY_TITLE", 
			"price" => "COM_DIGITALMARKETX_ORDER_BY_PRICE",
			"rating" => "COM_DIGITALMARKETX_ORDER_BY_RATING",
			"votes" => "COM_DIGITALMARKETX_ORDER_BY_VOTES");
	}
	
}
