<?php

/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
defined('_JEXEC') or die;

/**
 * Methods supporting a list of DigitalMarketX records.
 */
class DigitalMarketXModelThankyou extends JModelLegacy {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        parent::__construct($config);
    }

	function validateAccessCode($downloadId, $hash, $random)
	{
		$downloadId = (int)$downloadId;
		$db = JFactory::getDBO();
		$e_random = $db->escape($random);
		$query = "SELECT secret_word FROM #__digitalmarketx_download_links 
				WHERE download_id = $downloadId";
		$db->setQuery( $query );
		$secret_word = $db->loadResult();
		return $hash == sha1($secret_word . $random);
	}
	
	function isDownloadPaid($downloadId)
	{
		$downloadId = (int)$downloadId;
		$db = JFactory::getDBO();
		$query = "SELECT paid FROM #__digitalmarketx_download_links 
				WHERE download_id = $downloadId";
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	function isCartPaid($cart_id)
	{
		$cart_id = (int)$cart_id;
		$db = JFactory::getDBO();
		$query = "SELECT paid FROM #__digitalmarketx_shopping_carts 
				WHERE shoppingcart_id = $cart_id";
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	function getShoppingCartThankyou()
	{
		$thank_you_content = "<span size=\"16\">" . JText::_("COM_DIGITALMARKETX_CART_PAYMENT_THANKYOU") . "</span>";
		if(strpos($thank_you_content, "{continue}") === false)
		{
			$thank_you_content .= "<div class=\"front_thank_you_continue_url\"><a href=\"{continue}\">" . JText::_("COM_DIGITALMARKETX_CONTINUE") . "</a></div>";
		}
		$continueUrl = "index.php?option=com_digitalmarketx&view=purchaseditems";
		if(strpos($continueUrl, "&Itemid=") === false)
		{
			$Itemid = JRequest::getInt('Itemid');
			if($Itemid)
				$continueUrl .= "&Itemid=" . $Itemid;
		}
		$thank_you_content = str_replace("{continue}", $continueUrl, $thank_you_content);
		return $thank_you_content;
	}
	
	function getThankyouText($download_id)
	{
		$db = JFactory::getDBO();
		$thank_you_content = "<span size=\"16\">" . JText::_("COM_DIGITALMARKETX_RESOURCE_THANK_YOU") . "</span>";
		if(strpos($thank_you_content, "{continue}") === false)
		{
			$thank_you_content .= "<div class=\"front_thank_you_continue_url\"><a href=\"{continue}\">" . JText::_("COM_DIGITALMARKETX_CONTINUE") . "</a></div>";
		}
		$db->setQuery("SELECT download_link FROM #__digitalmarketx_download_links WHERE download_id = " . (int)$download_id);
		$download_link = $db->loadResult();
		if(strpos($download_link, "&Itemid=") === false)
		{
			$Itemid = JRequest::getInt('Itemid');
			if($Itemid)
				$download_link .= "&Itemid=" . $Itemid;
		}
		$thank_you_content = str_replace("{continue}", $download_link, $thank_you_content);
		return $thank_you_content;
	}
}
