<?php

/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
defined('_JEXEC') or die;

/**
 * Methods supporting a list of DigitalMarketX records.
 */
class DigitalMarketXModelUpload extends JModelLegacy {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        parent::__construct($config);
    }
	
	public function canUpload($category)
	{
		$user = JFactory::getUser();
		if($category)
			return $user->authorise('digitalmarketx.upload', 'com_digitalmarketx.category.' . $category);
		else
			return $user->authorise('digitalmarketx.upload', 'com_digitalmarketx');
	}
	
	public function canChangePrice()
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.changeprice', 'com_digitalmarketx');
	}
	
	public function canChangeCurrency()
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.changecurrency', 'com_digitalmarketx');
	}
	
	public function canUploadToCategory($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.upload', 'com_digitalmarketx.category.'.(int)$category);
	}
	
	public function canEditState()
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('core.edit.state', 'com_digitalmarketx');
	}
	
	public function canAssignUser()
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.assignusers', 'com_digitalmarketx');
	}
	
	public function canAssignUserInCategory($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.assignusers', 'com_digitalmarketx.category.'.(int)$category);
	}
	
	public function canChangePriceInCategory($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.changeprice', 'com_digitalmarketx.category.'.(int)$category);
	}
	
	public function canChangeCurrencyInCategory($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.changecurrency', 'com_digitalmarketx.category.'.(int)$category);
	}
	
	public function canEditStateInCategory($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('core.edit.state', 'com_digitalmarketx.category.'.(int)$category);
	}
	
	
	public function getCategories()
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, parent_id, title FROM #__categories WHERE published = 1 AND extension='com_digitalmarketx'";
		$db->setQuery( $query );
		$cats = $db->loadObjectList();
		$cats_ordered = array();
		$this->reorderCats($cats_ordered, $cats, 1, 0);
		return $cats_ordered;
	}
	
	public function canUseHTML()
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.htmledit', 'com_digitalmarketx');
	}
	
	public function getCurrencies()
	{
		return array("USD", "AUD", "BRL", "CAD", "CZK", "DKK", "EUR",
			"HKD", "HUF", "ILS", "JPY", "MYR", "MXN", "NOK", "PHP",
			"PLN", "GBP", "SGD", "SEK", "CHF", 
			"TWD", "THB");
		
	}
	
	private function reorderCats(&$cats_ordered, $cats, $parent_id, $depth)
	{
		$count = count($cats);
		for($i = 0; $i < $count; $i++)
		{
			$cat = $cats[$i];
			if($cat->parent_id == $parent_id)
			{
				$cat->depth = $depth;
				$cat->enabled = $this->canUploadToCategory($cat->id);
				$cat->canChangePrice = $this->canChangePriceInCategory($cat->id);
				$cat->canChangeCurrency = $this->canChangeCurrencyInCategory($cat->id);
				$cat->canEditState = $this->canEditStateInCategory($cat->id);
				$cat->canAssignUser = $this->canAssignUserInCategory($cat->id);
				$cats_ordered[] = $cat;
				$this->reorderCats($cats_ordered, $cats, $cat->id, $depth + 1);
			}
		}
	}

}
