<?php

/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of DigitalMarketX records.
 */
class DigitalMarketXModelUsers extends JModelList {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        parent::__construct($config);
    }

    /**
     * Method to auto-populate the model state.
     *
     * Note. Calling getState in this method will result in recursion.
     *
     * @since	1.6
     */
    protected function populateState($ordering = null, $direction = null) {
        
        // Initialise variables.
        $app = JFactory::getApplication();

        // List state information
        $limit = $app->getUserStateFromRequest('global.list.limit', 'limit', $app->getCfg('list_limit'));
        $this->setState('list.limit', $limit);

        $limitstart = JFactory::getApplication()->input->getInt('limitstart', 0);
        $this->setState('list.start', $limitstart);
		
		$search = $app->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);
		        
        // List state information.
        parent::populateState($ordering, $direction);
    }

    /**
	 * Build an SQL query to load the list data.
	 *
	 * @return	JDatabaseQuery
	 * @since	1.6
	 */
    protected function getListQuery() {
        // Create a new query object.
        $db = $this->getDbo();
        $query = $db->getQuery(true);

        // Select the required fields from the table.
        $query->select(
                $this->getState(
                        'list.select', 'id, name'
                )
        );
        
        $query->from('#__users');
		$query->where('block = 0');
		$query->where("#__users.id <> " . (int)(JFactory::getUser()->id));
		// Filter by search in title
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$search = $db->Quote('%'.$db->escape($search, true).'%');
			$searchQuery = "#__users.name LIKE " . $search ;
			$query->where($searchQuery);
		}
		$filter = $this->getGroupsFilter();
		if($filter)
		{
			$query->where($filter);
		}
        return $query;
    }
	
	private function getGroupsFilter()
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$filter = $params->get('user_doc_assigment', 'all_no_su');
		$user = JFactory::getUser();
		if($filter == 'same')
		{
			$where = "#__users.id IN 
				(SELECT umap.user_id FROM #__user_usergroup_map as umap
				 WHERE umap.group_id IN (" . implode(',', $user->groups) . ") )";
		}
		else if($filter == 'same_and_lower')
		{
			$groups = $user->getAuthorisedGroups();
			$where = "#__users.id IN 
				(SELECT umap.user_id FROM #__user_usergroup_map as umap
				 WHERE umap.group_id IN (" . implode(',', $groups) . ") )";
		}
		else if($filter == 'all_no_su')
		{
			$where = "#__users.id IN 
				(SELECT umap.user_id FROM #__user_usergroup_map as umap
					WHERE umap.group_id <> 8)";
		}
		else
		{
			$where = "";
		}
		return $where;
	}
	
}
