<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */
 
 // No direct access
defined('_JEXEC') or die;
 
 /**
 * Method to build Route
 * @param array $query
 */ 
function DigitalMarketXBuildRoute(&$query)
{
	$segments = array();
	if(isset($query['view']))
	{
		$view = $query['view'];
		if($view == 'category')
		{
			$id = $query['id'];
			$db = JFactory::getDBO();
			$db->setQuery("SELECT id, alias FROM #__categories WHERE id = " . (int)$id);
			$cat = $db->loadObject();
			if($cat)
				$segments []= $id . "-" . $cat->alias;
			unset($query['view']);
			unset($query['id']);
		}
		else  if($view == 'edit' || $view == 'pay' || $view == 'details' || $view == 'comment')
		{
			$segments []= $view;
			unset($query['view']);
			if(isset($query['id']))
			{
				$id = $query['id'];
				$segments []= DigitalMarketXGetAliasForDocument($id);
				unset($query['id']);
			}
		}
		else if($view == 'demo')
		{
			$segments []= $view;
			unset($query['view']);
			if(isset($query['id']))
			{
				$id = $query['id'];
				$segments []= DigitalMarketXGetAliasForDocument($id);
				unset($query['id']);
			}
			unset($query['tmpl']);
		}
		else if($view == 'users')
		{
			$segments []= $view;
			unset($query['view']);
			unset($query['tmpl']);
		}
		else if($view == 'profile' || $view == 'upload' || $view == 'paycart' || $view == "cart")
		{
			$segments []= $view;
			unset($query['view']);
		}
		else if($view == 'items')
		{
			$segments []= 'user_items';
			unset($query['view']);
		}
		else if($view == 'purchaseditems')
		{
			$segments []= 'purchased_items';
			unset($query['view']);
		}
		else if($view == 'search')
		{
			if(isset($query['results']))
			{
				$segments []= 'search_results';
				unset($query['results']);
			}
			else
			{
				$segments []= 'search';
			}
			unset($query['view']);
		}
		else if($view == 'commentreply')
		{
			$segments []= 'reply';
			if(isset($query['vote']))
			{
				$segments []= (int)$query['vote'];
				unset($query['vote']);
			}
			unset($query['view']);
		}
		else if($view == 'report')
		{
			$segments []= 'report';
			if(isset($query['id']))
			{
				$id = (int)$query['id'];
				$segments []= DigitalMarketXGetAliasForDocument($id);
				unset($query['id']);
			}
			unset($query['view']);
			if(isset($query['tmpl']))
				unset($query['tmpl']);
		}
	}
	else if(isset($query['task']))
	{
		$task = $query['task'];
		if($task == 'document.download')
		{
			$segments []= 'download';
			$id = $query['id'];
			$segments []= DigitalMarketXGetAliasForDocument($id);
			unset($query['task']);
			unset($query['id']);
		}
		else if($task == 'document.downloaddemo')
		{
			$segments []= 'downloaddemo';
			$id = $query['id'];
			$segments []= DigitalMarketXGetAliasForDocument($id);
			unset($query['task']);
			unset($query['id']);
		}
	}
	return $segments;
}

/**
 * Method to parse Route
 * @param array $segments
 */ 
function DigitalMarketXParseRoute($segments)
{
	$vars = array();
	if(count($segments) > 0)
	{
		if($segments[0] == 'edit' || $segments[0] == 'pay' || 
			$segments[0] == 'details' || $segments[0] == 'comment' ||
			$segments[0] == 'report')
		{
			$vars['view'] = $segments[0];
			if(count($segments) > 1)
			{
				$id = (int)$segments[1];
				$vars['id'] = $id;
			}
		}
		else if($segments[0] == 'demo')
		{
			$vars['view'] = $segments[0];
			if(count($segments) > 1)
			{
				$id = (int)$segments[1];
				$vars['id'] = $id;
				$vars['tmpl'] = 'component';
			}
		}
		else if($segments[0] == 'users')
		{
			$vars['view'] = $segments[0];
			$vars['tmpl'] = 'component';
		}
		else if($segments[0] == 'profile' || $segments[0] == 'upload' || $segments[0] == 'paycart' || $segments[0] == 'cart')
		{
			$vars['view'] = $segments[0];
		}
		else if($segments[0] == 'download')
		{
			$vars['task'] = 'document.download';
			if(count($segments) > 1)
			{
				$id = (int)$segments[1];
				$vars['id'] = $id;
			}
		}
		else if($segments[0] == 'downloaddemo')
		{
			$vars['task'] = 'document.downloaddemo';
			if(count($segments) > 1)
			{
				$id = (int)$segments[1];
				$vars['id'] = $id;
			}
		}
		else if($segments[0] == 'user_items')
		{
			$vars['view'] = 'items';
		}
		else if($segments[0] == 'purchased_items')
		{
			$vars['view'] = 'purchaseditems';
		}
		else if($segments[0] == 'search_results')
		{
			$vars['view'] = 'search';
			$vars['results'] = 1;
		}
		else if($segments[0] == 'search')
		{
			$vars['view'] = 'search';
		}
		else if($segments[0] == 'reply')
		{
			$vars['view'] = 'commentreply';
			if(count($segments) > 1)
			{
				$vars['vote'] = (int)$segments[1];
			}
		}
		else
		{
			$vars['view'] = 'category';
			$id = (int)$segments[0];
			$vars['id'] = $id;
		}
	}
	return $vars;
}

function DigitalMarketXGetAliasForDocument($id)
{
	$db = JFactory::getDBO();
	$query = "SELECT id, alias, title FROM #__digitalmarketx_documents WHERE id = " . (int)$id;
	$db->setQuery( $query );
	$doc = $db->loadObject();
	if($doc)
	{
		$alias = "";
		if($doc->alias)
		{
			$alias = $doc->alias;
			$alias = preg_replace('/\./', "_", $alias);
		}
		else
		{
			$alias = $doc->title;
			$alias = preg_replace("//", "a", $alias);
			$alias = preg_replace("//", "e", $alias);
			$alias = preg_replace("//", "i", $alias);
			$alias = preg_replace("//", "o", $alias);
			$alias = preg_replace("//", "u", $alias);
			$alias = preg_replace("//", "A", $alias);
			$alias = preg_replace("//", "E", $alias);
			$alias = preg_replace("//", "I", $alias);
			$alias = preg_replace("//", "O", $alias);
			$alias = preg_replace("//", "U", $alias);
			$alias = preg_replace("//", "n", $alias);
			$alias = preg_replace("//", "N", $alias);
			$alias = preg_replace('/\./', "_", $alias);
			$alias = preg_replace("/\\s/", "_", $alias);
			
		}
		return $id . "-" . $alias;
	}
	else
		return $id;
}