<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');

require_once JPATH_COMPONENT . DS . 'helpers' . DS . 'digitalmarketx.php';

$sitedocument = JFactory::getDocument();
$sitedocument->addScriptDeclaration("var sc_loading_text = '" . JText::_("COM_DIGITALMARKERX_ADDINGTOCART", true) . "';");
$sitedocument->addScriptDeclaration("var sc_add_text = '" . JText::_("COM_DIGITALMARKETX_ADDTOCART", true) . "';");
$sitedocument->addScriptDeclaration("var sc_remove_text = '" . JText::_("COM_DIGITALMARKETX_REMOVEFROMCART", true) . "';")
?>
<div class="category-layout">
<?php
$root = JURI::root();
?>
<h1>
	<?php echo $this->escape($this->header); ?>
</h1>
<div class="documents-list">
	<?php
	if(count($this->documents) == 0)
	{
	?>
	<span class="noitems"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_NO_PURCHASED_ITEMS"));?></span>
	<?php
	}
	$mootoolsIncluded = false;
	foreach($this->documents as $document)
	{
		if($document->visible)
		{
			DigitalMarketXHelper::renderDocumentPreview($document);
		}
	}	
	?>
	</div>
	<div class="pagination">
	<?php echo $this->pagination->getPagesLinks();?>
	</div>
</div>
