<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');
require_once JPATH_COMPONENT . DS . 'helpers' . DS . 'digitalmarketx.php';

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewAllItems extends JViewLegacy
{
	protected $state = null;
	protected $item = null;
	protected $items = null;

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		$model = $this->getModel();
		$accesscode = JRequest::getVar('digitalmarketxaccesscode');
		if($accesscode)
		{
			$model->checkAccessCode($accesscode);
		}
		$this->state = $this->get('State');
		$this->params	= $this->state->get('params');
		$this->header = $this->params->get("view_header");
		$model->order = $this->params->get('items_order', 0);
		// Initialise variables
		$documents  		= $this->get('documents');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		if($this->header == "")
			$this->header = JText::_("COM_DIGITALMARKETX_ALL_ITEMS");
		$option = JRequest::getVar('option');
		$this->assignRef('documents',	$documents);
		$showDownload = true;
		$this->assignRef('showDownload', $showDownload);
		$this->pagination	= $this->get('Pagination');	
		
		VersionLayer::script('jquery-1.7.1.min.js', 'components/'. $option . '/js/');
		VersionLayer::script('cart.js', 'components/'. $option . '/js/');
		$this->_prepareDocument();
		DigitalMarketXHelper::renderStyle();
		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function _prepareDocument()
	{
		$document = JFactory::getDocument();
		if($this->params->get('menu-meta_description'))
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}
		if($this->params->get('menu-meta_keywords'))
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}
		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
	}
}
