﻿<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');

?>
<div class="cart-layout">
<div class="adminform">
	<fieldset>
		<?php
		if(count($this->items) == 0)
		{
			echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_NO_ITEMS_IN_CART"));
		}
		else
		{
		?>
		<table width="100%">
			<thead>
			<tr>
			<th width="60%">
			<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_CART_ITEM"));?>
			</th>
			<th width="20%">
			<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_CART_PRICE"));?>
			</th>
			<th width="20%">
			<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_CARTREMOVEFROMCART"));?>
			</th>
			</tr>
			</thead>
		<tbody>
			<?php
			$sum = array();
			$first_currency = '';
			foreach($this->items as $item)
			{
				if($first_currency == '')
					$first_currency = $item->currency;
				if(!array_key_exists($item->currency, $sum))
					$sum[$item->currency] = 0;
				$sum[$item->currency] += $item->price;
			?>
			<tr>
			<td>
			<?php
			echo htmlspecialchars($item->title);
			?>
			</td>
			<td align="center">
			<?php
			echo htmlspecialchars($item->price . " " . $item->currency);
			?>
			</td>
			<td>
			<a href="<?php echo JRoute::_("index.php?option=com_digitalmarketx&task=cart.removeItemFromCart&id=" . (int)$item->id);?>" class="button_link">
			<div class="cartbutton">
			<div>
			<?php
			echo htmlspecialchars( JText::_("COM_DIGITALMARKETX_CARTREMOVEFROMCART") );
			?>
			</div>
			</div>
			</a>
			</td>
			</tr>
			<?php
			}
			?>
		
		</tbody>
		<tfoot>
		<tr>
		<td colspan="3" align="right">
			<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_CART_TOTAL"));
			$amount = 0;
			if(count($sum) > 0)
			{
				$amount = $sum[$first_currency];
				echo htmlspecialchars($sum[$first_currency] . " " . $first_currency);
			}
			else
				echo "0.00";
			?>
		</td>
		</tr>
		<tr>
		<td colspan="3" align="right">
		<div class="button-box">
		<a href="<?php echo JRoute::_("index.php?option=com_digitalmarketx&task=cart.checkout&id=" . (int)$this->cart_id);?>" class="button_link">
		<div class="paybutton">
		<div>
		<?php
		echo htmlspecialchars( JText::_("COM_DIGITALMARKETX_CART_CHECK_OUT") );
		?>
		</div>
		</div>
		</a>
		</div>
		</td>
		</tr>
		</tfoot>
		</table>
		<?php
		}
		?>
	</fieldset>
</div>
</div>