<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewCart extends JViewLegacy
{
	protected $state = null;
	protected $item = null;
	protected $items = null;

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		$model = $this->getModel();
	
		// Initialise variables
		$this->items   = $model->getCartItems();
		$this->cart_id = $model->getCartId();
		$this->user_id = (int)JFactory::getUser()->id;
		$this->paymentConfig = $model->getPaymentConfig();
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		$option = JRequest::getVar('option');
		$this->params = JComponentHelper::getParams('com_digitalmarketx');
		VersionLayer::stylesheet('cart.css', 'components/'. $option . '/assets/');
		VersionLayer::stylesheet('common.css', 'components/'. $option . '/assets/');
		$style = $this->params->get('buttons_style', 2);
		$this->paymentConfig = $model->getPaymentConfig();
		if($style == 0)
			VersionLayer::stylesheet('green.css', 'components/'. $option . '/assets/');
		else if($style == 1)
			VersionLayer::stylesheet('orange.css', 'components/'. $option . '/assets/');
		else
			VersionLayer::stylesheet('trans.css', 'components/'. $option . '/assets/');
		parent::display($tpl);
	}

}
