<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');

require_once JPATH_COMPONENT . DS . 'helpers' . DS . 'digitalmarketx.php';

$sitedocument = JFactory::getDocument();
$sitedocument->addScriptDeclaration("var sc_loading_text = '" . JText::_("COM_DIGITALMARKERX_ADDINGTOCART", true) . "';");
$sitedocument->addScriptDeclaration("var sc_add_text = '" . JText::_("COM_DIGITALMARKETX_ADDTOCART", true) . "';");
$sitedocument->addScriptDeclaration("var sc_remove_text = '" . JText::_("COM_DIGITALMARKETX_REMOVEFROMCART", true) . "';");
?>
<div class="category-layout">
<?php
$root = JURI::root();
if(isset($this->category->parent_id) && $this->category->parent_id)
{
?>
<a href="<?php echo JRoute::_("index.php?option=com_digitalmarketx&view=category&id=" . (int)$this->category->parent_id);?>">
<img src="<?php echo $root . "components/com_digitalmarketx/assets/images/up.png";?>" 
	alt="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_PARENT_CATEGORY"));?>"
	title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_PARENT_CATEGORY"));?>"/>
</a>
<?php
if(!JFactory::getUser()->id || $this->canUpload)
{
?>
<div class="uploadlink">
<a href="<?php echo JRoute::_("index.php?option=com_digitalmarketx&view=upload&cat=" . (int)$this->category->id);?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_UPLOAD_TO_THIS_CATEGORY"));?></a>
</div>
<?php
}
?>

<h1>
	<?php echo $this->escape($this->category->title); ?>
</h1>
<?php
if($this->show_category_image && $this->category->image)
{
?>
<div class="category_image"><img src="<?php echo htmlspecialchars(JUri::root() . $this->category->image);?>"/></div>
<?php
}
?>
<div class="category-desc">
	<?php echo JHtml::_('content.prepare', $this->category->description, '', ''); ?>
</div>
<?php
}
?>
<?php
	if(count($this->categories) > 0)
	{
?>
	<div class="subcategories-box">
	
<?php
		$Itemid = JRequest::getInt("Itemid");
		foreach($this->categories as $category)
		{
		$url = "index.php?option=com_digitalmarketx&view=category&id=" . (int)$category->id;
		if($Itemid)
			$url .= "&Itemid=" . $Itemid;
		$url = JRoute::_($url);
?>
		<div class="subcategory <?php if($this->category_list_layout == 0) echo "layout2"; else echo "layout1";?>">
		<?php
		if($this->show_category_image && $category->image)
		{
		?>
		<div class="category_image"><img src="<?php echo htmlspecialchars(JUri::root() . $category->image);?>"/></div>
		<?php
		}
		?>
		<a class="childcategorylink" href="<?php echo $url?>"><?php echo htmlspecialchars($category->title)?></a>
		</div>
<?php
		}
?>
		<div style="clear: both;"></div>
	</div>
	<br/>
	<hr/>
	<br/>
<?php
	}
	?>
	<div class="documents-list">
	<?php
	$mootoolsIncluded = false;
	if(count($this->documents) == 0)
	{
	?>
	<span class="noitems"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_NO_ITEMS"));?></span>
	<?php
	}
	foreach($this->documents as $document)
	{
		if($document->visible)
		{
			DigitalMarketXHelper::renderDocumentPreview($document);
		}
	}
	?>
	</div>
	<div class="pagination">
	<?php echo $this->pagination->getPagesLinks();?>
	</div>
</div>
