<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');
require_once JPATH_COMPONENT . DS . 'helpers' . DS . 'digitalmarketx.php';

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewCategory extends JViewLegacy
{
	protected $state = null;
	protected $item = null;
	protected $items = null;

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		$model = $this->getModel();
		$accesscode = JRequest::getVar('digitalmarketxaccesscode');
		if($accesscode)
		{
			$model->checkAccessCode($accesscode);
		}
	
		// Initialise variables
		$state				= $this->get('State');
		$categories			= $model->getCategories();
		$category			= $this->get('Category');
		$documents  		= $this->get('documents');
		$canDownload 		= $model->canDownload();
		$canDownloadFree	= $model->canDownloadFree();
		$canUpload  		= $model->canUploadToCategory();

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		$option = JRequest::getVar('option');
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$this->show_category_image = (int)$params->get('show_category_image', 0);
		$this->category_list_layout = (int)$params->get('category_list_layout', 0);
		VersionLayer::script('jquery-1.7.1.min.js', 'components/'. $option . '/js/');
		VersionLayer::script('cart.js', 'components/'. $option . '/js/');

		$this->assignRef('category',	$category);
		$this->assignRef('categories',	$categories);
		$this->assignRef('state',		$state);
		$this->assignRef('documents',	$documents);
		$this->assignRef('canDownload',		$canDownload);
		$this->assignRef('canDownloadFree',	$canDownloadFree);
		$this->assignRef('canUpload',	$canUpload);
		$showDownload = true;
		$this->assignRef('showDownload', $showDownload);
		$this->pagination	= $this->get('Pagination');	
		if(isset($category) && $category)
			$this->_prepareDocument($category);
		DigitalMarketXHelper::renderStyle();
		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function _prepareDocument($category)
	{
		$document = JFactory::getDocument();
		$document->setTitle($category->title);
		if($category->metadesc)
			$document->setDescription($category->metadesc);
		if($category->metakey)
			$document->setMetadata('keywords', $category->metakey);
		$categories = DigitalMarketXHelper::getParentCategories($category->id);
		DigitalMarketXHelper::buildPathWay($categories);
	}
}
