<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewComment extends JViewLegacy
{

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		$this->document_id = JRequest::getInt('id', 0);
		$model = $this->getModel();
		$category = $model->getDocumentCategory($this->document_id);
		if($model->canSubmitComment($category, $this->document_id))
		{
			if(!$model->requireDownloadBeforeComment() || 
				$model->isDocumentDownloaded($this->document_id))
			{
				VersionLayer::stylesheet('common.css', 'components/'. JRequest::getVar('option') . '/assets/');
				VersionLayer::stylesheet('comment.css', 'components/'. JRequest::getVar('option') . '/assets/');
				parent::display($tpl);
			}
			else
			{
				$url = "index.php?option=com_digitalmarketx&view=details&id=" . (int)$this->document_id;
				$Itemid = JRequest::getInt("Itemid");
				if($Itemid)
					$url .= "&Itemid=" . $Itemid;
				JFactory::getApplication()->redirect($url, 
					JText::_("COM_DIGITALMARKETX_DOWNLOAD_BEFORE_COMMENT_NEEDED"),
					"error");
			}
		}
		else if(JFactory::getUser()->id)
			echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_COMMENT_NOT_ALLOWED"));
		else
		{
			$return = "index.php?option=com_digitalmarketx&view=details&id=" . (int)$this->document_id;
			$url = "index.php?option=com_users&view=login&return=" . base64_encode($return);
			JFactory::getApplication()->redirect($url);
		}
	}

}
