﻿<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');

require_once JPATH_COMPONENT . DS . 'helpers' . DS . 'digitalmarketx.php';

$sitedocument = JFactory::getDocument();
$sitedocument->addScriptDeclaration("var sc_loading_text = '" . JText::_("COM_DIGITALMARKERX_ADDINGTOCART", true) . "';");
$sitedocument->addScriptDeclaration("var sc_add_text = '" . JText::_("COM_DIGITALMARKETX_ADDTOCART", true) . "';");
$sitedocument->addScriptDeclaration("var sc_remove_text = '" . JText::_("COM_DIGITALMARKETX_REMOVEFROMCART", true) . "';");


?>
<div class="category-layout">
<?php
$root = JURI::root();
if($this->category->id)
{
?>
<a href="<?php echo JRoute::_("index.php?option=com_digitalmarketx&view=category&id=" . (int)$this->category->id);?>">
<img src="<?php echo $root . "components/com_digitalmarketx/assets/images/up.png";?>" 
	alt="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_PARENT_CATEGORY"));?>"
	title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_PARENT_CATEGORY"));?>"/>
</a>
<h1>
	<?php echo $this->escape($this->document->title); ?>
</h1>

	<div class="documents-list">
	<?php
	if($this->document->visible)
	{
		DigitalMarketXHelper::renderDocumentDetails($this->document);
	}
	?>
	</div>
	<?php
?>
</div>
<h2><?php echo htmlspecialchars(JText::sprintf("COM_DIGITALMARKETX_COMMENTS", $this->pagination->total));?></h2>
<hr/>
<?php
if(!JFactory::getUser()->id || $this->canComment)
{
?>
<div class="submitcomment-link">
<a href="<?php echo JRoute::_("index.php?option=com_digitalmarketx&view=comment&id=" . (int)$this->document->id);?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SUBMIT_COMMENT"));?></a>
</div>
<?php
}
?>
<?php
}
?>
<?php
if(count($this->votes) == 0)
{
?>
<h1><span class="nocomments"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_NO_COMMENTS"));?></span></h1>
<?php
}
else
{
foreach($this->votes as $vote)
{
	$vote->document = $this->document;
	DigitalMarketXHelper::renderVote($vote);
}
?>
	<div class="pagination">
	<?php echo $this->pagination->getPagesLinks();?>
	</div>
<?php
}
?>