<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');
require_once JPATH_COMPONENT . DS . 'helpers' . DS . 'digitalmarketx.php';

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewDetails extends JViewLegacy
{
	protected $state = null;
	protected $item = null;
	protected $items = null;

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		$model = $this->getModel();
		$accesscode = JRequest::getVar('digitalmarketxaccesscode');
		if($accesscode)
		{
			$model->checkAccessCode($accesscode);
		}
	
		// Initialise variables
		$documentId			= JRequest::getInt('id');;
		$document  			= $model->getDocument($documentId);
		$category			= $model->getCategory($document->category);
		$canDownload 		= $model->canDownload($document->category);
		$canComment 		= $model->canSubmitComment($document);
		$this->votes 		= $model->getItems();
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		$option = JRequest::getVar('option');
		
		VersionLayer::script('jquery-1.7.1.min.js', 'components/'. $option . '/js/');
		VersionLayer::script('cart.js', 'components/'. $option . '/js/');

		$this->assignRef('category',	$category);
		$this->assignRef('document',	$document);
		$this->assignRef('canDownload',		$canDownload);
		$this->assignRef('canComment',		$canComment);
		$showDownload = true;
		$this->assignRef('showDownload', $showDownload);
		$this->pagination = $this->get('Pagination');	
		if(isset($document) && $document)
			$this->_prepareDocument($document);
		DigitalMarketXHelper::renderStyle();
		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function _prepareDocument($document)
	{
		if($document->metadescription)
			JFactory::getDocument()->setDescription($document->metadescription);
		else
		{
			$desc = $document->cleanDescription;
			if(strlen($desc) > 150)
			{
				$desc = substr($desc, 0, 145) . "...";
			}
			JFactory::getDocument()->setDescription($desc);
		}
		if($document->metatags)
			JFactory::getDocument()->setMetadata('keywords', $document->metatags);
		$categories = DigitalMarketXHelper::getDocumentParentCategories($document->id);
		DigitalMarketXHelper::buildPathWay($categories);
		JFactory::getDocument()->setTitle($document->title);
	}
}
