<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');

$root = JURI::root();
//JHTML::_('behavior.mootools'); 
JHTML::_('behavior.modal');
JHtml::_('behavior.keepalive');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
?>
<script type="text/javascript">
function validateUploadForm()
{
	var title = document.getElementById('uploadtitle');
	if(title.value.trim() == '')
	{
		alert('<?php echo JText::_("COM_DIGITALMARKETX_TYPE_TITLE", true);?>');
		return false;
	}
	var uploadcategory = document.getElementById('uploadcategory');
	if(uploadcategory.value == '0')
	{
		alert('<?php echo JText::_("COM_DIGITALMARKETX_SELECT_CATEGORY", true);?>');
		return false;
	}
	var minprice = <?php echo $minprice = (float)$this->params->get('minprice', 0.01);?>;
	var maxprice = <?php echo $maxprice = (float)$this->params->get('maxprice', 1000000);?>;
	var uploadprice = document.getElementById('uploadprice');
	var regexp = /^\s*\d+(\.\d{0,2})?\s*$/;
	if(!regexp.test(uploadprice.value))
	{
		alert('<?php echo JText::_("COM_DIGITALMARKETX_SPECIFY_PRICE", true);?>');
		return false;
	}
	var price = parseFloat(uploadprice.value);
	if(price < minprice || price > maxprice)
	{
		alert('<?php echo addslashes(JText::sprintf("COM_DIGITALMARKET_PRICE_OUTOFRANGE", $minprice, $maxprice));?>');
		return false;
	}
	return true;
}
var defaultPrice = <?php echo (float)$this->params->get('defaultprice', 10.00);?>;
var defaultcurrency = <?php echo (float)$this->params->get('defaultcurrency', 'USD');?>;
var categories = new Array();
var cat;
<?php
	foreach($this->categories as $category)
	{
	?>
	cat = new Object;
	cat.id = <?php echo (int)$category->id;?>;
	cat.canChangePrice = <?php echo $category->canChangePrice ? 'true' : 'false';?>;
	cat.canChangeCurrency = <?php echo $category->canChangeCurrency ? 'true' : 'false';?>;
	cat.canEditState = <?php echo $category->canEditState ? 'true' : 'false';?>;
	cat.canAssignUsers = <?php echo $category->canAssignUser ? 'true' : 'false';?>;
	categories.push( cat );
	<?php
	}
?>
</script>
<form method="post" action="<?php echo JRoute::_("index.php?option=com_digitalmarketx&task=document.save");?>" name="uploadForm" id="upload-form" enctype="multipart/form-data" onsubmit="return validateUploadForm();">
<div class="adminform">
	<fieldset>
		<legend><?php echo htmlspecialchars(JText::_('COM_DIGITALMARKET_EDIT')); ?></legend>
		<input type="hidden" name="docid" value="<?php echo htmlspecialchars($this->document->id);?>"/>
		<ul class="adminformlist">
		<li><label for="uploadtitle" class="hasTip required" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_TITLE_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_FORM_LBL_DOCUMENT_TITLE"));?><span class="required">*</span></label>
		<input type="text" name="title" id="uploadtitle" maxlength="255" size="50" value="<?php echo htmlspecialchars($this->document->title);?>"/>
		</li>
		<li><label for="uploadcategory" class="hasTip required" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_CATEGORY_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_FORM_LBL_DOCUMENT_CATEGORY"));?><span class="required">*</span></label>
		<select name="category" id="uploadcategory" onchange="categoryChanged();">
		<option value="0"><?php  echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SELECT_CATEGORY"));?></option>
		<?php
		$currentCat = null;
		foreach($this->categories as $category)
		{
		$title = "";
		for($i = 0; $i < $category->depth; $i++)
			$title .= "--";
		$title .= htmlspecialchars($category->title);
		$selected = $this->document->category == $category->id;
		?>
		<option value="<?php echo htmlspecialchars($category->id)?>" 
			<?php if($selected) {echo "selected"; $currentCat = $category;}?>
			<?php if(!$category->enabled && !$selected) echo "disabled"; ?>><?php echo $title;?></option>
		<?php
		}
		?>
		</select>
		</li>
		<?php
		$disabled = ($currentCat && $currentCat->canChangePrice) ? "" : "disabled";
		?>
		<li><label for="uploadprice" class="hasTip required" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_PRICE_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_PRICE"));?><span class="required">*</span></label>
		<input type="text" name="price" id="uploadprice" maxlength="30" size="10" value="<?php echo htmlspecialchars($this->document ? $this->document->price : $this->params->get('defaultprice', 10));?>" <?php echo $disabled;?>/>
		</li>
		<li><label for="uploadcurrency" class="hasTip required" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_CURRENCY_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_CURRENCY"));?><span class="required">*</span></label>
		<?php
		$disabled = ($currentCat && $currentCat->canChangePrice && $currentCat->canChangeCurrency) ? "" : "disabled";
		?>
		<select name="currency" id="uploadcurrency" <?php echo $disabled;?>>
		<?php
		$cur = $this->document ? $this->document->currency : $this->params->get('defaultcurrency', 'USD');
		foreach($this->currencies as $currency)
		{
		$selected = ($cur == $currency) ? "selected" : "";;
		$currency = htmlspecialchars($currency);
		?>
		<option value="<?php echo $currency;?>" <?php echo $selected;?>><?php echo $currency;?></option>
		<?php
		}
		?>
		</select>
		</li>
		<li>
		<label for="published" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_PUBLISHED_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_PUBLISHED"));?></label>
		<?php
		$disabled = ($currentCat && $currentCat->canEditState)  ? "" : "disabled";
		?>
		<input type="checkbox" name="published" id="published" value="1" <?php if($this->document->state == 1) echo "checked";?> <?php echo $disabled;?>/>
		</li>
		<?php 
		//if($this->canAssignUser)
		{
		?>
		<li id="select_users_region" <?php if(!$this->canAssignUser){?> style="display: none;" <?php }?>>
		<div style="clear:both;"></div>
		<label class="hasTip required" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_USERS_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DESTINATION_USERS"));?></label>
		<?php
		$values = "";
		foreach($this->document->users as $user)
		{
			if($values != "")
				$values .= ",";
			$values .= (int)$user->user_id;
		}
		?>
		<input type="hidden" name="destusers_userids" id="destusers_userids" value="<?php echo $values;?>"/>
		<div id="destusers_usernames" class="dmuserbox">
		<?php
		foreach($this->document->users as $user)
		{
		?>
		<div id="userli_<?php echo (int)$user->user_id;?>" style="float: left;">
		<span><?php echo htmlspecialchars($user->name);?></span>
		<input type="button" value="x" style="float: right;" onclick="removeUser('destusers', '<?php echo (int)$user->user_id;?>');"/>
		</div>
		<?php
		}
		?>
		</div>
		
		<div class="modalbutton">
		<a class="modal" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SELECT_USERS"));?>" href="index.php?option=com_digitalmarketx&view=users&tmpl=component&field=destusers" rel="{handler: 'iframe', size: {x: 500, y: 300}}"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SELECT_USERS"));?></a>
		</div>
		</li>
		<?php
		}
		/*else
		{
		?>
		<input type="hidden" name="destusers_userids" value="no"/>
		<?php
		}*/
		?>
		<li>
		<div style="clear:both;"></div>
		<?php
		$disabled = ($currentCat && $currentCat->enabled)  ? "" : "disabled";
		?>
		<label for="file" class="hasTip required" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_FILE_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_FILE"));?><span class="required">*</span></label>
		<input type="file" name="file" id="file" size="40" <?php echo $disabled;?>/>
		<div class="file"><?php echo htmlspecialchars($this->document->attachment);?></div>
		</li>
		<li>
		<div style="clear:both;"></div>
		<label for="thumbnail" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_THUMBNAIL_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_THUMBNAIL_PREVIEW"));?></label>
		<input type="file" name="thumbnail" id="thumbnail" size="40" <?php echo $disabled;?>/>
		<div class="file"><?php echo htmlspecialchars($this->document->thumbnail);?></div>
		</li>
		<li>
		<div style="clear:both;"></div>
		<label for="demo_file" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_DEMO_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_DEMO"));?></label>
		<input type="file" name="demo_file" id="demo_file" size="40" <?php echo $disabled;?>/>
		<div class="file"><?php echo htmlspecialchars($this->document->demo_file);?></div>
		<input type="hidden" name="demo_text" value=""/>
		</li>
		<li><label for="keywords" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_KEYWORDS_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_FILE_KEYWORDS"));?></label>
		<input type="text" name="keywords" id="keywords" maxlength="255" size="50" value="<?php echo htmlspecialchars($this->document->metatags);?>"/>
		</li>
		<li>
		<label for="description" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_DESCRIPTION_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DESCRIPTION"));?></label>
		<?php
		if($this->canUseHtml)
		{
		?>
		<div style="float:left;">
		<?php
		$editor = JFactory::getEditor();
		echo $editor->display('description', $this->document->description, '100%', '200', '20', '20', false);	
		?>
		</div>
		<?php
		}
		else
		{
		?>
		<textarea style="width:60%; height:250px;" name="description" id="description" maxlength="5000"><?php
		echo htmlspecialchars($this->document->description);
		?></textarea>
		<?php
		}
		?>
		</li>
		</ul>
		<div style="clear: both;"></div>
		<?php
		$detailsUrl = JRoute::_("index.php?option=com_digitalmarketx&view=details&id=" . (int)$this->document->id);
		$version = new JVersion();
		if($version->RELEASE < "3.0")
		{
		?>
		<div class="uploadbuttons">
		<button type="submit" class="submitbutton" name="upload"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_UPDATE"));?></button>
		<a href="<?php echo $detailsUrl;?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_CANCEL"));?></a>
		</div>
		<?php
		}
		else
		{
		?>
		<div id="form-login-submit" class="control-group">
		<div class="controls">
			<button type="submit" tabindex="0" name="upload" class="btn btn-primary"><?php echo JText::_('COM_DIGITALMARKET_UPDATE') ?></button>
			<a class="btn" href="<?php echo $detailsUrl;?>" title="<?php echo JText::_('JCANCEL');?>"><?php echo JText::_('JCANCEL');?></a>
		</div>
		</div>
		<?php
		}
		?>
	</fieldset>
</div>
</form>