<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

require_once JPATH_COMPONENT . DS . 'helpers' . DS . 'digitalmarketx.php';

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewEdit extends JViewLegacy
{

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		$model = $this->getModel();
		$id = JRequest::getInt('id');
		$doc = $model->getDocument($id);
		if($model->canEdit($doc))
		{
			$categories = $model->getCategories();
			$currencies = $model->getCurrencies();
			$canUseHtml = $model->canUseHTML();
			$canAssignUser = $model->canAssignUserInCategory($doc->category);
			if(!$canUseHtml)
			{
				$doc->description = $model->cleanHtml($doc->description);
				$doc->demo_text = $model->cleanHtml($doc->demo_text);
			}
			$option = JRequest::getVar('option');
			$params = JComponentHelper::getParams('com_digitalmarketx');
			VersionLayer::stylesheet('common.css', 'components/'. $option . '/assets/');
			VersionLayer::stylesheet('upload.css', 'components/'. $option . '/assets/');
			VersionLayer::stylesheet('selusers.css', 'components/'. $option . '/assets/');
			VersionLayer::script('upload.js', 'components/'. $option . '/js/');
			VersionLayer::script('users.js', 'components/'. $option . '/js/');
			$this->assignRef('categories', $categories);
			$this->assignRef('currencies', $currencies);
			$this->assignRef('params', $params);
			$this->assignRef('document', $doc);
			$this->assignRef('canUseHtml', $canUseHtml);
			$this->assignRef('canAssignUser', $canAssignUser);
			$this->_prepareDocument($doc);
			parent::display($tpl);
		}
		else
			echo htmlspecialchars(JText::_("COM_DIGITALMARKET_EDIT_NOT_ALLOWED"));
	}
	
	/**
	 * Prepares the document
	 */
	protected function _prepareDocument($document)
	{
		if($document->metadescription)
			JFactory::getDocument()->setDescription($document->metadescription);
		else
		{
			$desc = $document->cleanDescription;
			if(strlen($desc) > 150)
			{
				$desc = substr($desc, 0, 145) . "...";
			}
			JFactory::getDocument()->setDescription($desc);
		}
		if($document->metatags)
			JFactory::getDocument()->setMetadata('keywords', $document->metatags);
		$categories = DigitalMarketXHelper::getDocumentParentCategories($document->id);
		$edit = new Stdclass();
		$edit->title = $document->title;
		$edit->url = "";
		$categories []= $edit;
		DigitalMarketXHelper::buildPathWay($categories);
	}

}
