<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');

$root = JURI::root();
?>
<div class="payment-layout">
<div class="payment-header">
	<?php  echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_PAYMENT_HEADER")); ?>
</div>
<div class="front_title"><?php echo htmlspecialchars($this->document->title)."&nbsp;&nbsp;&nbsp;";?></div>
<span class="front_price_label"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_PRICE"));?></span>
<span class="front_price_data"><?php echo htmlspecialchars($this->document->price) . "&nbsp;" . htmlspecialchars($this->document->currency);?></span>
<br/>
</div>
<?php
$paypal_button_lang_folder = JText::_("COM_DIGITALMARKETX_PAYPAL_BUTTON_LANGUAGE_FOLDER");
if($this->paymentConfig)
{
	if($this->paymentConfig->testmode)
	{
		if($this->paymentConfig->use_simulator)
			$paypal = "index.php?option=com_digitalmarketx&amp;task=paypal.simulatepay";
		else
			$paypal = "https://www.sandbox.paypal.com/cgi-bin/webscr";
	}
	else
		$paypal = "https://www.paypal.com/cgi-bin/webscr";
}
?>
<form action="<?php echo $paypal;?>" method="post" >
<input type="hidden" name="cmd" value="_xclick"/>
<input type="hidden" name="business" value="<?php echo htmlspecialchars($this->paymentConfig->paypalaccount);?>"/>
<input type="hidden" name="custom" value="<?php echo htmlspecialchars($this->downloadLink->downloadId . "-" . (int)(JFactory::getUser()->id));?>"/>
<input type="hidden" name="item_number" value="<?php echo htmlspecialchars($this->document->id); ?>"/>
<input type="hidden" name="item_name" value="<?php echo htmlspecialchars($this->document->title); ?>"/>
<input type="hidden" name="amount" value="<?php echo htmlspecialchars($this->document->price); ?>"/>
<input type="hidden" name="currency_code" value="<?php echo htmlspecialchars($this->document->currency); ?>"/>
<input type="hidden" name="notify_url" value="<?php echo $root;?>index.php?option=com_digitalmarketx&amp;task=paypal.confirmpay"/>
<?php
	$return = $root . "index.php?option=com_digitalmarketx&amp;view=thankyou&amp;digitalmarketxaccesscode=" . urlencode($this->downloadLink->accessCode);
	$Itemid = JRequest::getInt('Itemid');
	if($Itemid)
		$return .= "&amp;Itemid=" . $Itemid;
?>
<input type="hidden" name="return" value="<?php echo $return;?>"/>
<input type="hidden" name="no_note" value="1"/>
<input type="hidden" name="no_shipping" value="1"/>
<input type="hidden" name="rm" value="2"/>
<input type="image" src="http://www.paypal.com/<?php echo $paypal_button_lang_folder;?>/i/btn/btn_paynowCC_LG.gif" name="submit" alt="<?php echo JText::_("COM_DIGITALMARKETX_PAYPAL_BUTTON_ALTERNATE_TEXT");?>"/>
<img alt="" src="https://www.paypal.com/<?php echo $paypal_button_lang_folder;?>/i/scr/pixel.gif" width="1" height="1"/>
</form>
