<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewPay extends JViewLegacy
{

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		// Initialise variables
		$model = $this->getModel();
		$paymentConfig = $this->get('PaymentConfig');
		$docId = JRequest::getInt('id');
		$document = $model->getDocument($docId);
		if($model->canDownload($document->category))
		{
			$downloadLink = $model->createDownloadLink($docId);
			// Check for errors.
			if (count($errors = $this->get('Errors'))) {
				JError::raiseWarning(500, implode("\n", $errors));
				return false;
			}
			$option = JRequest::getVar('option');
			VersionLayer::stylesheet('pay.css', 'components/'. $option . '/assets/');
			$this->assignRef('paymentConfig',	$paymentConfig);
			$this->assignRef('document',	$document);
			$this->assignRef('downloadLink',	$downloadLink);
			JFactory::getDocument()->setTitle( htmlspecialchars( JText::_("COM_DIGITALMARKETX_PAYMENT_PAGE_TITLE") ));
			parent::display($tpl);
		}
		else
		{
			$user = JFactory::getUser();
			if(!$user->id)
			{
				$Itemid = JRequest::getInt("Itemid");
				$app = JFactory::getApplication();
				$return = "index.php?option=com_digitalmarketx&view=pay&id=" . $docId;
				if($Itemid)
					$return .= "&Itemid=" . $Itemid;
				$url = "index.php?option=com_users&view=login&return=" . base64_encode($return);
				if($Itemid)
					$url .= "&Itemid=" . $Itemid;
				$app->redirect($url);
				exit;
			}
			else
			{
				echo JText::_("COM_DIGITALMARKETX_YOUR_USER_GROUP_IS_NOT_ALLOWED_TO_DOWNLOAD");
			}
		}
	}

}
