<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewPayCart extends JViewLegacy
{

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		// Initialise variables
		$model = $this->getModel();
		$this->paymentConfig = $this->get('PaymentConfig');
		$this->cart = $model->getCart();
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		JFactory::getDocument()->setTitle( htmlspecialchars( JText::_("COM_DIGITALMARKETX_CART_CHECKOUT_PAGE_TITLE") ));
		$option = JRequest::getVar('option');
		VersionLayer::stylesheet('pay.css', 'components/'. $option . '/assets/');
		parent::display($tpl);
	}

}
