<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');

$root = JURI::root();
?>
<script type="text/javascript">
function validateUpdateForm()
{
	var regex = /\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/;
	var profilepaypalaccount = document.getElementById('profilepaypalaccount');
	if(!regex.test(profilepaypalaccount.value))
	{
		alert('<?php echo JText::_("COM_DIGITALMARKET_PAYPALACCOUNT_NOT_VALID", true);?>');
		return false;
	}
	return true;
}

function validateClaim(i)
{
	var money = document.getElementById('money' + i);
	var balance = document.getElementById('balance' + i);
	var regex = /\d+(\.\d{0,2})?/;
	if(!regex.test(money.value))
	{
		alert('<?php echo JText::_("COM_DIGITALMARKET_WRONG_NUMBER", true);?>');
		return false;
	}
	var amountToClaim = parseFloat(money.value);
	var amountMax = parseFloat(balance.value);
	if(amountToClaim > amountMax)
	{
		alert('<?php echo JText::_("COM_DIGITALMARKET_TOO_MUCH_TO_CLAIM", true);?>');
		return false;
	}
	return true;
}
</script>
<form method="post" action="<?php echo JRoute::_("index.php?option=com_digitalmarketx&task=profile.save");?>" name="profileForm" id="profile-form" onsubmit="return validateUpdateForm();">
<div class="adminform">
	<fieldset>
		<legend><?php echo htmlspecialchars(JText::_('COM_DIGITALMARKET_PROFILE')); ?></legend>
		<ul class="adminformlist">
		<li><label for="profilepaypalaccount"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_PAYPAL_ACCOUNT"));?></label>
		<input type="text" name="paypalaccount" id="profilepaypalaccount" value="<?php if($this->profile) echo htmlspecialchars($this->profile->paypalaccount);?>" maxlength="255" size="40"/>
		</li>
		</ul>
		<div style="clear: both;"></div>
		<div class="formbuttons">
		<input type="submit" class="submitbutton" name="updateprofile" value="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_UPDATE"));?>"/>
		</div>
	</fieldset>
</div>
</form>
<div class="adminform">
	<fieldset>
<div class="profile-message"><?php echo htmlspecialchars(JText::sprintf("COM_DIGITALMARKET_MINIMUM_CLAIM_AMOUNT", $this->minreclaim));?></div>
<div class="profile-message"><?php echo htmlspecialchars(JText::sprintf("COM_DIGITALMARKET_MAXIMUM_CLAIM_AMOUNT", $this->maxreclaim));?></div>
<div class="profile-message"><?php echo htmlspecialchars(JText::sprintf("COM_DIGITALMARKET_MANAGER_PERCENT", $this->managerpercent));?></div>
<div class="profile-message">
<?php
	if($this->nextClaimDate)
	{
		$date = new JDate($this->nextClaimDate);
		$today = new JDate();
		if($today < $this->nextClaimDate)
		{
			$dateFormat = JText::_("COM_DIGITALMARKET_DATE_FORMAT");
			echo htmlspecialchars(JText::sprintf("COM_DIGITALMARKET_NEXT_CLAIM_DATE", $date->format($dateFormat)));
		}
		else
			echo htmlspecialchars(JText::sprintf("COM_DIGITALMARKET_DAYS_TO_CLAIM_ARE", $this->daystoreclaim));
	}
	else
		echo htmlspecialchars(JText::sprintf("COM_DIGITALMARKET_DAYS_TO_CLAIM_ARE", $this->daystoreclaim));
?>
</div>
    </fieldset>
</div>
<?php
if ( $this->money && count($this->money) > 0)
{
	$max_amount_to_reclaim =(float)$this->params->get('maxreclaim', 1000.00);
?>
<div class="adminform">
	<fieldset>
	<legend><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_MONEY"));?></legend>
	<table>
	<thead>
	<th>
	<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_AMOUNT_EARNED"));?>
	</th>
	<th>
	<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_AMOUNT_TO_CLAIM"));?>
	</th>
	<th>
	<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_AMOUNT_CLAIMED"));?>
	</th>
	</thead>
	<?php foreach($this->money as $currency) {?>
	<tr>
	<?php if($currency->balance > 0.001 ||  $currency->claimed  > 0.001){?>
	<td align="right"><?php echo htmlspecialchars($currency->balance . " " . $currency->currency);?></td>
	<td>
	<?php if($currency->canReclaim){
		$to_claim = $currency->balance;
		if($to_claim > $max_amount_to_reclaim)
			$to_claim = $max_amount_to_reclaim;
	?>
	<form method="post" action="<?php echo JRoute::_("index.php?option=com_digitalmarketx&task=profile.claim");?>" onsubmit="return validateClaim(<?php echo (int)$currency->money_id;?>);">
	<input type="hidden" name="moneyid" value="<?php echo htmlspecialchars($currency->money_id);?>"/>
	<input type="hidden" name="balance" id="balance<?php echo htmlspecialchars($currency->money_id);?>" value="<?php echo htmlspecialchars($currency->balance);?>"/>
	<input type="text" value="<?php echo htmlspecialchars($to_claim);?>" name="money" id="money<?php echo htmlspecialchars($currency->money_id);?>"/>
	<input type="submit" class="submitbutton claim" name="claim" value="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_CLAIM"));?>"/>
	</form>
	<?php } 
	?>
	</td>
	<td>
	<?php
	if($currency->claimed > 0.001)
	{
		echo htmlspecialchars($currency->claimed . " " . $currency->currency);
	}
	?>
	</td>
	<?php }?>
	</tr>
	<?php }?>
	</table>
	</fieldset>
</div>
<?php
}
else
	echo htmlspecialchars(JText::_("COM_DIGITALMARKET_YOU_HAVE_NO_MONEY"));
?>
<div class="adminform">
<fieldset>
<legend><?php echo htmlspecialchars(JText::_('COM_DIGITALMARKETX_STATS_HEADER')); ?></legend>
<table>
	<thead>
	<th><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_STATS_FILE"));?></th>
	<th><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_STATS_AMOUNT"));?></th>
	<th><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_STATS_DATE"));?></th>
	<th><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_STATS_BUYER"));?></th>
	</thead>
	<tfoot>
	<tr>
	<td align="center" colspan="4">
	<div class="pagination">
	<?php echo $this->pagination->getPagesLinks();?>
	</div>
	</td>
	</tr>
	</tfoot>
	<tbody>
	<?php
	foreach($this->salesStats as $stat)
	{
	?>
	<tr>
	<td><?php echo htmlspecialchars($stat->title);?></td>
	<td><?php echo htmlspecialchars($stat->amount) . "&nbsp;" . 
		htmlspecialchars($stat->currency);?></td>
	<td><?php 
	$params = JComponentHelper::getParams('com_digitalmarketx');
	$format = $params->get('date_format', 'l, F d, Y h:i:s a');
	if($format == '')
		$format = 'l, F d, Y h:i:s a';
	$date = new JDate($stat->purchase_time);
	echo htmlspecialchars($date->format($format));
	?></td>
	<td><?php echo htmlspecialchars($stat->name);?></td>
	</tr>
	<?php
	}
	?>
	</tbody>
</table>
</fieldset>
</div>