<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewProfile extends JViewLegacy
{

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		$user = JFactory::getUser();
		if($user->id)
		{
			$model = $this->getModel();
			$profile = $model->getCurrentUserProfile();
			$money = $model->getCurrentUserMoney();
			$option = JRequest::getVar('option');
			$params = JComponentHelper::getParams('com_digitalmarketx');
			$this->daystoreclaim = (int)$params->get('daystoreclaim', 30);
			$this->minreclaim = (float)$params->get('minreclaim', 20.00);
			$this->maxreclaim = (float)$params->get('maxreclaim', 1000.00);
			$this->managerpercent = (float)$params->get('managerpercent', 10.00);
			$this->nextClaimDate = $model->getNextReclaimDate($this->daystoreclaim);
			$model->setReclaimingOptions($money, $params);
			$this->salesStats = $model->getItems();
			$this->salesStatsCount = $model->getTotal();
			$this->pagination	= $this->get('Pagination');	
			VersionLayer::stylesheet('common.css', 'components/'. $option . '/assets/');
			VersionLayer::stylesheet('profile.css', 'components/'. $option . '/assets/');
			$this->assignRef('profile', $profile);
			$this->assignRef('money', $money);
			$this->assignRef('params', $params);
			parent::display($tpl);
		}
		else
			echo htmlspecialchars(JText::_("COM_DIGITALMARKET_LOGIN_TO_VIEW_PROFILE"));
	}

}
