<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');
require_once JPATH_COMPONENT . DS . 'helpers' . DS . 'digitalmarketx.php';

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewPurchasedItems extends JViewLegacy
{
	protected $state = null;
	protected $item = null;
	protected $items = null;

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		$model = $this->getModel();
		$accesscode = JRequest::getVar('digitalmarketxaccesscode');
		if($accesscode)
		{
			$model->checkAccessCode($accesscode);
		}
	
		// Initialise variables
		$documents  		= $this->get('documents');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		$option = JRequest::getVar('option');
		$this->assignRef('documents',	$documents);
		$showDownload = true;
		$this->assignRef('showDownload', $showDownload);
		$this->pagination	= $this->get('Pagination');	
		$this->_prepareDocument();
		DigitalMarketXHelper::renderStyle();
		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function _prepareDocument()
	{
		$document = JFactory::getDocument();
		$document->setTitle(JText::_("COM_DIGITALMARKETX_MY_PURCHASED_ITEMS_TITLE"));
		$document->setDescription(JText::_("COM_DIGITALMARKETX_MY_PURCHASED_DESCRIPTION"));
	}
}
