<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');

$root = JURI::root();
?>
<script type="text/javascript">
function validateCommentForm()
{
	var title = document.getElementById('comment_title');
	if(title.value.trim() == '')
	{
		alert('<?php echo JText::_("COM_DIGITALMARKETX_TYPE_REPORT_TITLE", true);?>');
		return false;
	}
	var text = document.getElementById('comment_text');
	if(text.value.trim() == '')
	{
		alert('<?php echo JText::_("COM_DIGITALMARKETX_TYPE_REPORT_TEXT", true);?>');
		return false;
	}
	return true;
}

</script>
<form method="post" action="<?php echo JRoute::_("index.php?option=com_digitalmarketx&task=report.submit");?>" name="commentForm" onsubmit="return validateCommentForm();">
<div class="adminform">
	<fieldset>
		<legend><?php echo htmlspecialchars(JText::_('COM_DIGITALMARKETX_REPORT')); ?></legend>
		<ul class="adminformlist">
		<li><label for="comment_title"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_REPORT_TITLE"));?><span class="required">*</span></label>
		<input type="text" name="title" id="comment_title" maxlength="80" size="80"/>
		</li>
		<li>
		<label for="comment_text"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_REPORT_TEXT"));?></label>
		<textarea style="width:60%; height:250px;" name="comment_text" id="comment_text" maxlength="2000"></textarea>
		</li>
		
		</ul>
		<div style="clear: both;"></div>
		<?php
		$detailsUrl = JRoute::_("index.php?option=com_digitalmarketx&view=details&id=" . (int)$this->document_id);
		$version = new JVersion();
		if($version->RELEASE < "3.0")
		{
		?>
		<div class="commentbuttons">
		<button type="submit" class="submitbutton" name="comment"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SEND_REPORT"));?></button>
		<?php
		if($this->document_id)
		{
		?>
		<a href="<?php echo $detailsUrl;?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_CANCEL"));?></a>
		<?php 
		}
		?>
		</div>
		<?php
		}
		else
		{
		?>
		<div id="form-login-submit" class="control-group">
		<div class="controls">
			<button type="submit" tabindex="0" name="upload" class="btn btn-primary"><?php echo JText::_('COM_DIGITALMARKETX_SEND_REPORT') ?></button>
			<a class="btn" href="<?php echo $detailsUrl;?>" title="<?php echo JText::_('JCANCEL');?>"><?php echo JText::_('JCANCEL');?></a>
		</div>
		</div>
		<?php
		}
		?>
	</fieldset>
</div>
<input type="hidden" name="document_id" value="<?php echo htmlspecialchars($this->document_id);?>"/>
</form>