<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');
require_once JPATH_COMPONENT . DS . 'helpers' . DS . 'digitalmarketx.php';
require_once JPATH_COMPONENT_ADMINISTRATOR . DS  . 'config.php';
JHtml::_('behavior.tooltip');
$root = JURI::root();

$sitedocument = JFactory::getDocument();
$sitedocument->addScriptDeclaration("var sc_loading_text = '" . JText::_("COM_DIGITALMARKERX_ADDINGTOCART", true) . "';");
$sitedocument->addScriptDeclaration("var sc_add_text = '" . JText::_("COM_DIGITALMARKETX_ADDTOCART", true) . "';");
$sitedocument->addScriptDeclaration("var sc_remove_text = '" . JText::_("COM_DIGITALMARKETX_REMOVEFROMCART", true) . "';");

?>
<h1>
	<?php echo $this->escape(JText::_("COM_DIGITALMARKETX_SEARCH")); ?>
</h1>
<?php
if(!$this->showResults)
{
?>
<form method="post" action="<?php echo JRoute::_("index.php?option=com_digitalmarketx&view=search&results=1");?>" name="searchForm">
<div class="adminform">
	<fieldset>
		<legend><?php echo htmlspecialchars(JText::_('COM_DIGITALMARKETX_SEARCH')); ?></legend>
		<ul class="adminformlist">
		<li><label for="searchtext" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SEARCH_TEXT_HINT"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SEARCH_TEXT"));?></label>
		<input type="text" name="searchtext" id="searchtext" maxlength="255" size="40"/>
		</li>
		<li><label for="category" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_CATEGORY_HINT"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_CATEGORY"));?></label>
		<select name="category" id="category">
		<option value="0"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_ALL_CATEGORIES"));?></option>
		<?php
		foreach($this->categories as $category)
		{
		?>
		<option value="<?php echo (int)$category->id;?>"><?php echo str_repeat("&nbsp;&nbsp;", $category->depth) . htmlspecialchars($category->title);?></option>
		<?php
		}
		?>
		</select>
		</li>
		<li><label for="minprice" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_MIN_PRICE_HINT"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_MIN_PRICE"));?></label>
		<input type="text" name="minprice" id="minprice" maxlength="10" size="10" />
		</li>
		<li><label for="maxprice" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_MAX_PRICE_HINT"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_MAX_PRICE"));?></label>
		<input type="text" name="maxprice" id="maxprice" maxlength="10" size="10"/>
		</li>
		<li><label for="minrating" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_MIN_RATING_HINT"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_MIN_RATING"));?></label>
		<select name="minrating" id="minrating">
			<option value="0"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_NO_RATED"));?></option>
		<?php for($i = 1; $i <= 5; $i++){?>
			<option value="<?php echo $i;?>"><?php echo $i;?></option>
		<?php
			}
		?>
		</select>
		</li>
		<li><label for="minvotes" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_MIN_VOTES_HINT"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_MIN_VOTES"));?></label>
		<input type="text" name="minvotes" id="minvotes" maxlength="10" size="10"/>
		</li>
		<li><label for="hasdemo" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_HAS_DEMO_HINT"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_HAS_DEMO"));?></label>
		<select name="hasdemo" id="hasdemo">
			<option value="0"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOESNT_MATTER"));?></option>
			<option value="1"><?php echo htmlspecialchars(JText::_("JYES"));?></option>
		</select>
		</li>
		<li><label for="hasthumbnail" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_HAS_THUMBNAIL_HINT"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_HAS_THUMBNAIL"));?></label>
		<select name="hasthumbnail" id="hasthumbnail">
			<option value="0"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOESNT_MATTER"));?></option>
			<option value="1"><?php echo htmlspecialchars(JText::_("JYES"));?></option>
		</select>
		</li>
		<?php
		if(ADVANCED_SEARCH)
		{
		?>
		<li><label for="purchased" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SEARCH_INCLUDE_PURCHASED_FILES_HINT"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SEARCH_INCLUDE_PURCHASED_FILES"));?></label>
		<select name="purchased" id="purchased">
			<option value="0"><?php echo htmlspecialchars(JText::_("JNO"));?></option>
			<option value="1" selected><?php echo htmlspecialchars(JText::_("JYES"));?></option>
		</select>
		</li>
		<li><label for="myfiles" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SEARCH_INCLUDE_MY_FILES_HINT"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SEARCH_INCLUDE_MY_FILES"));?></label>
		<select name="myfiles" id="myfiles">
			<option value="0"><?php echo htmlspecialchars(JText::_("JNO"));?></option>
			<option value="1" selected><?php echo htmlspecialchars(JText::_("JYES"));?></option>
		</select>
		</li>
		<?php
		}
		else
		{
		?>
		<input type="hidden" name="purchased" value="1"/>
		<input type="hidden" name="myfiles" value="1"/>
		<?php
		}
		?>
		<li><label for="sortby" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_ORDERING_HINT"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_ORDERING"));?></label>
		<select name="sortby" id="sortby">
		<?php
		foreach($this->sortElements as $key => $element)
		{
		?>
		<option value="<?php echo htmlspecialchars($key);?>"><?php echo htmlspecialchars(JText::_($element));?></option>
		<?php
		}
		?>
		</select>&nbsp;&nbsp;&nbsp;
		<select name="sorttype">
		<option value="asc"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_ORDER_ASCENDING")); ?></option>
		<option value="desc"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_ORDER_DESCENDING")); ?></option>
		</select>
		</li>
		</ul>
		<div style="clear: both;"></div>
		<?php
		$version = new JVersion();
		if($version->RELEASE < "3.0")
		{
		?>
		<div class="formbuttons">
		<button type="submit" class="submitbutton" name="search"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SEARCH_BUTTON"));?></button>
		</div>
		<?php
		}
		else
		{
		?>
		<div id="form-login-submit" class="control-group">
		<div class="controls">
			<button type="submit" tabindex="0" name="upload" class="btn btn-primary"><?php echo JText::_('COM_DIGITALMARKETX_SEARCH_BUTTON') ?></button>
		</div>
		</div>
		<?php
		}
		?>
	</fieldset>
</div>
</form>
<?php
}
else
{
?>
<div class="documents-list">
<?php
$mootoolsIncluded = false;
if(count($this->documents) == 0)
{
?>
<span class="noitems"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_NO_RESULTS"));?></span>
<?php
}
foreach($this->documents as $document)
{
	DigitalMarketXHelper::renderDocumentPreview($document);
}
?>
</div>
<div class="pagination">
<?php echo $this->pagination->getPagesLinks();?>
</div>
<?php
}
?>